/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.lightccsl.core.stepper;

import fr.kairos.common.IFactory;
import fr.kairos.lightccsl.core.stepper.GenericStepper;
import fr.kairos.lightccsl.core.stepper.IBackend;
import fr.kairos.lightccsl.core.stepper.IClockBuilder;
import fr.kairos.lightccsl.core.stepper.ISolutionSet;
import fr.kairos.lightccsl.core.stepper.ISpecificationToSolution;
import fr.kairos.timesquare.ccsl.simple.AUtility;
import fr.kairos.timesquare.ccsl.simple.ISpecificationBuilder;
import fr.kairos.timesquare.ccsl.simple.IUtility;

public class StepperUtility
extends AUtility
implements IUtility {
    public static String NB_STEPS = "NbSteps";
    public static String DEBUG = "Debug";
    public static String INTERACTIVE = "Interactive";
    private ISpecificationToSolution spec2sol;
    private GenericStepper stepper;
    private IBackend backend;

    public StepperUtility(ISpecificationToSolution spec2sol) {
        this.spec2sol = spec2sol;
    }

    public void setBackend(IBackend backend) {
        this.backend = backend;
    }

    @Override
    public final void treat(String name, ISpecificationBuilder consumer) {
        try {
            IClockBuilder clockBuilder = null;
            if (this.backend != null) {
                clockBuilder = this.backend.init(this);
            }
            this.stepper = new GenericStepper(new SolutionBuilder(consumer), clockBuilder);
            if (this.getBooleanParam(INTERACTIVE, true)) {
                this.stepper.interactiveStep();
            } else {
                this.stepper.stepAndPrint(this.getIntParam(NB_STEPS, 10), this.getBooleanParam(DEBUG, false));
            }
            if (this.backend != null) {
                this.backend.finish(name);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class SolutionBuilder
    implements IFactory<ISolutionSet> {
        private ISpecificationBuilder consumer;

        public SolutionBuilder(ISpecificationBuilder consumer) {
            this.consumer = consumer;
        }

        @Override
        public ISolutionSet build() {
            return StepperUtility.this.spec2sol.buildSolutionsFor(this.consumer, StepperUtility.this.stepper, StepperUtility.this.stepper);
        }
    }
}

