/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.parser;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import org.aspectj.ajdt.internal.compiler.parser.AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Literal;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.RecoveredType;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.TheOriginalJDTParserClass;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class Parser
extends TheOriginalJDTParserClass {
    private static final String ASPECTJ_DECLARATION_FACTORY = "org.aspectj.ajdt.internal.compiler.parser.DeclarationFactory";
    private static IDeclarationFactory declarationFactory;
    protected int aspectIntPtr;
    protected int[] aspectIntStack;
    private static final boolean AJ_DEBUG = false;

    static {
        try {
            Parser.initTables(Parser.class);
            declarationFactory = (IDeclarationFactory)Class.forName(ASPECTJ_DECLARATION_FACTORY).newInstance();
        }
        catch (IOException ex) {
            throw new ExceptionInInitializerError(ex.getMessage());
        }
        catch (InstantiationException ex) {
            throw new ExceptionInInitializerError(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new ExceptionInInitializerError(ex.getMessage());
        }
        catch (ClassNotFoundException ex) {
            System.err.println("Warning: AspectJ declaration factory class not found on classpath");
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.aspectIntPtr = -1;
        this.aspectIntStack = new int[4];
    }

    @Override
    public void initialize(boolean initializeNLS) {
        super.initialize(initializeNLS);
        this.aspectIntPtr = -1;
        this.aspectIntStack = new int[4];
    }

    @Override
    public void initializeScanner() {
        this.scanner = new Scanner(false, false, this.options.getSeverity(256) != 256, this.options.sourceLevel, this.options.taskTags, this.options.taskPriorities, this.options.isTaskCaseSensitive, this.options.enablePreviewFeatures);
    }

    void println(Object o) {
    }

    private void printStack(Object[] s, int p) {
        List<Object> list = Arrays.asList(s);
        System.out.println("  " + list.subList(0, p + 1));
    }

    private void printStack(int[] s, int p) {
        StringBuffer buf = new StringBuffer("[");
        int i = 0;
        while (i < p + 1) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(Integer.toString(s[i]));
            ++i;
        }
        buf.append("]");
        System.out.println("  " + buf);
    }

    private void printStack(long[] s, int p) {
        StringBuffer buf = new StringBuffer("[");
        int i = 0;
        while (i < p + 1) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(Long.toString(s[i]));
            ++i;
        }
        buf.append("]");
        System.out.println("  " + buf);
    }

    private void printStack(char[][] s, int p) {
        StringBuffer buf = new StringBuffer("[");
        int i = 0;
        while (i < p + 1) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(new String(s[i]));
            ++i;
        }
        buf.append("]");
        System.out.println("  " + buf);
    }

    public void display() {
    }

    @Override
    protected MethodDeclaration createMethodDeclaration(CompilationResult result) {
        return declarationFactory.createMethodDeclaration(result);
    }

    @Override
    protected ConstructorDeclaration createConstructorDeclaration(CompilationResult result) {
        return declarationFactory.createConstructorDeclaration(result);
    }

    @Override
    protected void consumeMethodInvocationName() {
        super.consumeMethodInvocationName();
        MessageSend m = (MessageSend)this.expressionStack[this.expressionPtr];
        if (CharOperation.equals(m.selector, "proceed".toCharArray())) {
            this.expressionStack[this.expressionPtr] = declarationFactory.createProceed(m);
        }
    }

    @Override
    protected void consumeToken(int type) {
        this.currentTokenStart = this.scanner.startPosition;
        super.consumeToken(type);
        switch (type) {
            case 9: {
                this.pushOnAspectIntStack(this.scanner.currentPosition - 1);
                this.pushOnAspectIntStack(this.scanner.startPosition);
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                this.pushIdentifier();
                this.flushCommentsDefinedPriorTo(this.currentTokenStart);
                this.scanner.commentPtr = -1;
            }
        }
    }

    protected void consumeAspectDeclaration() {
        this.consumeClassDeclaration();
    }

    protected void consumeAspectHeader() {
        this.consumeClassHeader();
    }

    protected void consumeAspectHeaderName(boolean isPrivileged) {
        TypeDeclaration aspectDecl = declarationFactory.createAspect(this.compilationUnit.compilationResult);
        if (this.nestedMethod[this.nestedType] == 0) {
            if (this.nestedType != 0) {
                aspectDecl.bits |= 0x400;
            }
        } else {
            aspectDecl.bits |= 0x100;
            this.markEnclosingMemberWithLocalType();
            this.blockReal();
        }
        this.println("aspect header name: ");
        this.display();
        long pos = this.identifierPositionStack[this.identifierPtr];
        aspectDecl.sourceEnd = (int)pos;
        aspectDecl.sourceStart = (int)(pos >>> 32);
        aspectDecl.name = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        aspectDecl.declarationSourceStart = this.aspectIntStack[this.aspectIntPtr--];
        --this.aspectIntPtr;
        this.eatIdentifier();
        if (isPrivileged) {
            pos = this.eatIdentifier();
            declarationFactory.setPrivileged(aspectDecl, true);
        }
        aspectDecl.modifiersSourceStart = this.intStack[this.intPtr--];
        aspectDecl.modifiers = this.intStack[this.intPtr--];
        if (isPrivileged) {
            aspectDecl.modifiersSourceStart = this.intStack[this.intPtr--];
            aspectDecl.modifiers |= this.intStack[this.intPtr--];
        }
        if (aspectDecl.modifiersSourceStart >= 0) {
            aspectDecl.declarationSourceStart = aspectDecl.modifiersSourceStart;
        }
        this.println("modifiers: " + aspectDecl.modifiers);
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            aspectDecl.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, aspectDecl.annotations, 0, length);
        }
        aspectDecl.bodyStart = aspectDecl.sourceEnd + 1;
        this.pushOnAstStack(aspectDecl);
        this.listLength = 0;
        if (this.currentElement != null) {
            this.lastCheckPoint = aspectDecl.bodyStart;
            this.currentElement = this.currentElement.add(aspectDecl, 0);
            this.lastIgnoredToken = -1;
        }
        aspectDecl.javadoc = this.javadoc;
        this.javadoc = null;
        this.display();
    }

    protected void consumeAspectHeaderNameWithTypeParameters(boolean isPriviliged) {
        TypeDeclaration typeDecl = (TypeDeclaration)this.astStack[this.astPtr];
        int length = this.genericsLengthStack[this.genericsLengthPtr--];
        this.genericsPtr -= length;
        typeDecl.typeParameters = new TypeParameter[length];
        System.arraycopy(this.genericsStack, this.genericsPtr + 1, typeDecl.typeParameters, 0, length);
        typeDecl.bodyStart = typeDecl.typeParameters[length - 1].declarationSourceEnd + 1;
        this.listTypeParameterLength = 0;
        if (this.currentElement != null) {
            this.lastCheckPoint = typeDecl.bodyStart;
        }
    }

    private long eatIdentifier() {
        long pos = this.identifierPositionStack[this.identifierPtr];
        --this.identifierPtr;
        --this.identifierLengthPtr;
        return pos;
    }

    protected void consumeAspectHeaderRest() {
        this.concatNodeLists();
        this.display();
        ASTNode pseudoTokens = this.popPseudoTokens("{");
        this.println("pseudo: " + pseudoTokens);
        TypeDeclaration aspectDecl = (TypeDeclaration)this.astStack[this.astPtr];
        declarationFactory.setDominatesPatternFrom(aspectDecl, pseudoTokens, this);
        declarationFactory.setPerClauseFrom(aspectDecl, pseudoTokens, this);
    }

    protected void consumePointcutDeclaration() {
        this.consumePointcutDesignatorOnDeclaration();
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    public int getCurrentTokenStart() {
        return this.currentTokenStart;
    }

    protected void consumeEmptyPointcutDeclaration() {
        MethodDeclaration pcutDecl = (MethodDeclaration)this.astStack[this.astPtr];
        pcutDecl.bodyEnd = this.endStatementPosition;
    }

    protected void consumePointcutHeader() {
        MethodDeclaration ret = declarationFactory.createPointcutDeclaration(this.compilationUnit.compilationResult);
        long pos = this.identifierPositionStack[this.identifierPtr];
        ret.sourceStart = (int)(pos >>> 32);
        ret.selector = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        ret.javadoc = this.javadoc;
        this.javadoc = null;
        this.eatIdentifier();
        ret.declarationSourceStart = this.intStack[this.intPtr--];
        ret.modifiers = this.intStack[this.intPtr--];
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            ret.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, ret.annotations, 0, length);
        }
        this.pushOnAstStack(ret);
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumeAroundDeclaration() {
        this.consumeMethodDeclaration(true, false);
    }

    protected void consumeAroundHeader() {
        this.consumePointcutDesignatorOnAdvice();
        this.resetModifiers();
        this.consumeMethodHeader();
    }

    protected void consumeAroundHeaderName() {
        int length;
        MethodDeclaration adviceDecl = declarationFactory.createAroundAdviceDeclaration(this.compilationUnit.compilationResult);
        long pos = this.eatIdentifier();
        adviceDecl.sourceStart = (int)(pos >>> 32);
        adviceDecl.selector = new char[]{'a', 'j', 'c', '$', 'a', 'd', 'v', 'i', 'c', 'e'};
        TypeReference returnType = this.getTypeReference(this.intStack[this.intPtr--]);
        adviceDecl.declarationSourceStart = this.intStack[this.intPtr--];
        adviceDecl.modifiers = this.intStack[this.intPtr--];
        adviceDecl.returnType = returnType;
        if ((length = this.expressionLengthStack[this.expressionLengthPtr--]) != 0) {
            adviceDecl.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, adviceDecl.annotations, 0, length);
        }
        adviceDecl.javadoc = this.javadoc;
        this.javadoc = null;
        this.pushOnAstStack(adviceDecl);
    }

    protected void consumePointcutDesignatorOnAdvice() {
        ASTNode des = this.popPointcutDesignator("{");
        MethodDeclaration adviceDecl = (MethodDeclaration)this.astStack[this.astPtr];
        declarationFactory.setPointcutDesignatorOnAdvice(adviceDecl, des);
        adviceDecl.sourceEnd = des.sourceEnd;
        adviceDecl.bodyStart = des.sourceEnd + 1;
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumePointcutDesignatorOnDeclaration() {
        ASTNode des = this.popPointcutDesignator(";");
        MethodDeclaration pcutDecl = (MethodDeclaration)this.astStack[this.astPtr];
        declarationFactory.setPointcutDesignatorOnPointcut(pcutDecl, des);
        pcutDecl.sourceEnd = des.sourceEnd;
        pcutDecl.bodyStart = des.sourceEnd + 1;
        pcutDecl.bodyEnd = this.endPosition;
        pcutDecl.declarationSourceEnd = this.flushCommentsDefinedPriorTo(this.endStatementPosition);
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumeBasicAdviceDeclaration() {
        this.consumeMethodDeclaration(true, false);
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumeBasicAdviceHeader() {
        this.consumePointcutDesignatorOnAdvice();
        this.resetModifiers();
        this.consumeMethodHeader();
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumeBasicAdviceHeaderName(boolean isAfter) {
        int length;
        MethodDeclaration adviceDecl = isAfter ? declarationFactory.createAfterAdviceDeclaration(this.compilationUnit.compilationResult) : declarationFactory.createBeforeAdviceDeclaration(this.compilationUnit.compilationResult);
        long pos = this.eatIdentifier();
        adviceDecl.selector = new char[]{'a', 'j', 'c', '$', 'a', 'd', 'v', 'i', 'c', 'e'};
        adviceDecl.sourceStart = (int)(pos >>> 32);
        adviceDecl.declarationSourceStart = this.intStack[this.intPtr--];
        adviceDecl.modifiers = this.intStack[this.intPtr--];
        if ((length = this.expressionLengthStack[this.expressionLengthPtr--]) != 0) {
            adviceDecl.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, adviceDecl.annotations, 0, length);
        }
        adviceDecl.javadoc = this.javadoc;
        this.javadoc = null;
        this.pushOnAstStack(adviceDecl);
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumeExtraParameterWithFormal() {
        Argument arg = (Argument)this.astStack[this.astPtr--];
        --this.astLengthPtr;
        declarationFactory.setExtraArgument((MethodDeclaration)this.astStack[this.astPtr], arg);
        this.consumeExtraParameterNoFormal();
    }

    protected void consumeExtraParameterNoFormal() {
        long pos = this.identifierPositionStack[this.identifierPtr];
        int end = (int)pos;
        int start = (int)(pos >>> 32);
        char[] name = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        MethodDeclaration adviceDecl = (MethodDeclaration)this.astStack[this.astPtr];
        declarationFactory.isAfterAdvice(adviceDecl);
        if (CharOperation.equals(name, "throwing".toCharArray())) {
            declarationFactory.setAfterThrowingAdviceKind(adviceDecl);
        } else if (CharOperation.equals(name, "returning".toCharArray())) {
            declarationFactory.setAfterReturningAdviceKind(adviceDecl);
        } else {
            this.problemReporter().parseError(start, end, this.currentToken, name, String.valueOf(name), new String[]{"throwing", "returning", ":"});
        }
    }

    protected void consumeClassBodyDeclarationInAspect() {
    }

    protected void consumeDeclareDeclaration() {
        this.concatNodeLists();
        ASTNode tokens = this.popPseudoTokens(";");
        MethodDeclaration declareDecl = declarationFactory.createDeclareDeclaration(this.compilationUnit.compilationResult, tokens, this);
        this.display();
        this.pushOnAstStack(declareDecl);
    }

    protected void consumeDeclareAnnotation(char kind) {
        this.concatNodeLists();
        ASTNode tokens = this.popPseudoTokens(";");
        Annotation[] annotations = new Annotation[1];
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, annotations, 0, length);
        }
        MethodDeclaration declareDecl = declarationFactory.createDeclareAnnotationDeclaration(this.compilationUnit.compilationResult, tokens, annotations[0], this, kind);
        this.pushOnAstStack(declareDecl);
    }

    protected void consumeDeclareAnnotationHeader() {
        this.consumePseudoTokenIdentifier();
        this.consumePseudoTokenIdentifier();
        this.swapAstStack();
        this.consumePseudoTokens();
        this.consumePseudoToken("@", 0, false);
        this.swapAstStack();
        this.consumePseudoTokens();
        this.consumePseudoToken(":", 0, false);
        this.consumePseudoTokens();
        this.display();
    }

    protected void consumeDeclareHeader() {
        this.consumePseudoTokenIdentifier();
        this.consumePseudoTokenIdentifier();
        this.swapAstStack();
        this.consumePseudoTokens();
        this.consumePseudoToken(":", 0, false);
        this.consumePseudoTokens();
        this.display();
    }

    protected void consumeInterTypeFieldHeader(boolean hasTypeParameters) {
        this.display();
        long pos = this.identifierPositionStack[this.identifierPtr];
        int end = (int)pos;
        int start = (int)(pos >>> 32);
        char[] identifierName = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        if (hasTypeParameters) {
            this.pushOnGenericsIdentifiersLengthStack(this.identifierLengthStack[this.identifierLengthPtr]);
        } else {
            this.consumeClassOrInterfaceName();
        }
        TypeReference onType = this.getTypeReference(0);
        TypeReference returnType = this.getTypeReference(this.intStack[this.intPtr--]);
        this.display();
        int decSourceStart = this.intStack[this.intPtr--];
        int fieldModifiers = this.intStack[this.intPtr--];
        MethodDeclaration dec = declarationFactory.createInterTypeFieldDeclaration(this.compilationUnit.compilationResult, onType);
        dec.returnType = returnType;
        dec.sourceStart = start;
        dec.sourceEnd = end;
        declarationFactory.setSelector(dec, identifierName);
        dec.declarationSourceStart = decSourceStart;
        declarationFactory.setDeclaredModifiers(dec, fieldModifiers);
        dec.bodyEnd = this.endPosition;
        dec.javadoc = this.javadoc;
        this.javadoc = null;
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            dec.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, dec.annotations, 0, length);
        }
        this.pushOnAstStack(dec);
        this.println("consumed field: " + dec);
        this.display();
    }

    protected void consumeExitITDVariableWithoutInitializer() {
        MethodDeclaration itdDecl = (MethodDeclaration)this.astStack[this.astPtr];
        declarationFactory.setInitialization(itdDecl, null);
    }

    protected void consumeExitITDVariableWithInitializer() {
        --this.expressionLengthPtr;
        MethodDeclaration itdDecl = (MethodDeclaration)this.astStack[this.astPtr];
        Expression initialization = this.expressionStack[this.expressionPtr--];
        declarationFactory.setInitialization(itdDecl, initialization);
        itdDecl.declarationSourceEnd = initialization.sourceEnd;
    }

    protected void consumeInterTypeFieldDeclaration() {
        MethodDeclaration dec = (MethodDeclaration)this.astStack[this.astPtr];
        dec.bodyEnd = this.endPosition;
        dec.declarationSourceEnd = this.flushCommentsDefinedPriorTo(this.endStatementPosition);
    }

    protected void consumeInterTypeMethodDeclaration(boolean isNotAbstract) {
        this.consumeMethodDeclaration(isNotAbstract, false);
    }

    protected void consumeInterTypeMethodHeader() {
        this.consumeMethodHeader();
    }

    protected void consumeInterTypeConstructorDeclaration() {
        this.consumeMethodDeclaration(true, false);
    }

    protected void consumeInterTypeConstructorHeader() {
        this.consumeMethodHeader();
    }

    protected void consumeInterTypeMethodHeaderName(boolean hasMethodTypeParameters, boolean hasGenericTypeParameters) {
        this.display();
        MethodDeclaration md = declarationFactory.createInterTypeMethodDeclaration(this.compilationUnit.compilationResult);
        char[] name = this.identifierStack[this.identifierPtr];
        long selectorSource = this.identifierPositionStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        if (hasGenericTypeParameters) {
            this.pushOnGenericsIdentifiersLengthStack(this.identifierLengthStack[this.identifierLengthPtr]);
        } else {
            this.consumeClassOrInterfaceName();
        }
        TypeReference onType = this.getTypeReference(0);
        md.returnType = this.getTypeReference(this.intStack[this.intPtr--]);
        if (hasMethodTypeParameters) {
            int tp_length = this.genericsLengthStack[this.genericsLengthPtr--];
            this.genericsPtr -= tp_length;
            md.typeParameters = new TypeParameter[tp_length];
            System.arraycopy(this.genericsStack, this.genericsPtr + 1, md.typeParameters, 0, tp_length);
        }
        declarationFactory.setOnType(md, onType);
        md.declarationSourceStart = this.intStack[this.intPtr--];
        declarationFactory.setDeclaredModifiers(md, this.intStack[this.intPtr--]);
        md.sourceStart = (int)(selectorSource >>> 32);
        this.pushOnAstStack(md);
        md.sourceEnd = this.lParenPos;
        md.bodyStart = this.lParenPos + 1;
        declarationFactory.setSelector(md, name);
        this.listLength = 0;
        md.javadoc = this.javadoc;
        this.javadoc = null;
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            md.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, md.annotations, 0, length);
        }
        if (this.currentElement != null) {
            if (this.currentElement instanceof RecoveredType || this.scanner.getLineNumber(md.returnType.sourceStart) == this.scanner.getLineNumber(md.sourceStart)) {
                this.lastCheckPoint = md.bodyStart;
                this.currentElement = this.currentElement.add(md, 0);
                this.lastIgnoredToken = -1;
            } else {
                this.lastCheckPoint = md.sourceStart;
                this.restartRecovery = true;
            }
        }
    }

    protected void consumeInterTypeConstructorHeaderName(boolean hasConstructorTypeParameters, boolean hasTargetTypeParameters) {
        this.display();
        MethodDeclaration md = declarationFactory.createInterTypeConstructorDeclaration(this.compilationUnit.compilationResult);
        if (!hasTargetTypeParameters) {
            this.consumeClassOrInterfaceName();
        }
        TypeReference onType = this.getTypeReference(0);
        declarationFactory.setOnType(md, onType);
        this.println("got onType: " + onType);
        this.display();
        --this.intPtr;
        md.returnType = TypeReference.baseTypeReference(6, 0, null);
        if (hasConstructorTypeParameters) {
            int tp_length = this.genericsLengthStack[this.genericsLengthPtr--];
            this.genericsPtr -= tp_length;
            md.typeParameters = new TypeParameter[tp_length];
            System.arraycopy(this.genericsStack, this.genericsPtr + 1, md.typeParameters, 0, tp_length);
        }
        md.declarationSourceStart = this.intStack[this.intPtr--];
        declarationFactory.setDeclaredModifiers(md, this.intStack[this.intPtr--]);
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            md.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, md.annotations, 0, length);
        }
        md.sourceStart = onType.sourceStart;
        this.pushOnAstStack(md);
        md.sourceEnd = this.lParenPos;
        md.bodyStart = this.lParenPos + 1;
        this.listLength = 0;
        declarationFactory.setSelector(md, (String.valueOf(new String(CharOperation.concatWith(onType.getTypeName(), '_'))) + "_new").toCharArray());
        if (this.currentElement != null) {
            if (this.currentElement instanceof RecoveredType) {
                this.currentElement = this.currentElement.add(md, 0);
                this.lastIgnoredToken = -1;
            } else {
                this.lastCheckPoint = md.sourceStart;
                this.restartRecovery = true;
            }
        }
    }

    protected void consumePseudoToken(String value) {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        this.consumePseudoToken(value, 0, false);
    }

    protected void consumePseudoToken(String value, int popFromIntStack, boolean isIdentifier) {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        this.intPtr -= popFromIntStack;
        int start = this.currentTokenStart;
        int end = start + value.length() - 1;
        ASTNode tok = declarationFactory.createPseudoToken(this, value, isIdentifier);
        tok.sourceStart = start;
        tok.sourceEnd = end;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokenIdentifier() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        long pos = this.identifierPositionStack[this.identifierPtr];
        int end = (int)pos;
        int start = (int)(pos >>> 32);
        char[] name = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        ASTNode tok = declarationFactory.createPseudoToken(this, new String(name), true);
        tok.sourceStart = start;
        tok.sourceEnd = end;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokenIf() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        Expression expr = this.expressionStack[this.expressionPtr--];
        --this.expressionLengthPtr;
        this.println("expr: " + expr);
        int start = this.intStack[this.intPtr--];
        ASTNode tok = declarationFactory.createIfPseudoToken(this, expr);
        tok.sourceStart = start;
        tok.sourceEnd = this.rParenPos;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokenLiteral() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        Literal literal = (Literal)this.expressionStack[this.expressionPtr--];
        --this.expressionLengthPtr;
        ASTNode tok = declarationFactory.createPseudoToken(this, new String(literal.source()), false);
        declarationFactory.setLiteralKind(tok, "string");
        tok.sourceStart = literal.sourceStart;
        tok.sourceEnd = literal.sourceEnd;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokenModifier() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        this.consumePseudoToken(Modifier.toString(this.modifiers), 0, true);
        this.modifiers = 0;
    }

    protected void consumePseudoTokenPrimitiveType() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        TypeReference type = this.getTypeReference(0);
        ASTNode tok = declarationFactory.createPseudoToken(this, type.toString(), true);
        tok.sourceStart = type.sourceStart;
        tok.sourceEnd = type.sourceEnd;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokens() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        this.optimizedConcatNodeLists();
    }

    @Override
    protected void consumeRule(int act) {
        switch (act) {
            case 41: {
                this.consumePrimitiveType();
                break;
            }
            case 55: {
                this.consumeReferenceType();
                break;
            }
            case 59: {
                this.consumeClassOrInterfaceName();
                break;
            }
            case 60: {
                this.consumeClassOrInterface();
                break;
            }
            case 61: {
                this.consumeGenericType();
                break;
            }
            case 62: {
                this.consumeGenericTypeWithDiamond();
                break;
            }
            case 63: {
                this.consumeArrayTypeWithTypeArgumentsName();
                break;
            }
            case 64: {
                this.consumePrimitiveArrayType();
                break;
            }
            case 65: {
                this.consumeNameArrayType();
                break;
            }
            case 66: {
                this.consumeGenericTypeNameArrayType();
                break;
            }
            case 67: {
                this.consumeGenericTypeArrayType();
                break;
            }
            case 73: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 74: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 83: {
                this.consumeQualifiedName();
                break;
            }
            case 86: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 91: {
                this.consumeUnannotatableQualifiedName();
                break;
            }
            case 92: {
                this.consumeQualifiedName(false);
                break;
            }
            case 93: {
                this.consumeQualifiedName(true);
                break;
            }
            case 94: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 98: {
                this.consumeOneMoreTypeAnnotation();
                break;
            }
            case 99: {
                this.consumeTypeAnnotation();
                break;
            }
            case 100: {
                this.consumeTypeAnnotation();
                break;
            }
            case 101: {
                this.consumeTypeAnnotation();
                break;
            }
            case 102: {
                this.consumeAnnotationName();
                break;
            }
            case 103: {
                this.consumeNormalAnnotation(true);
                break;
            }
            case 104: {
                this.consumeMarkerAnnotation(true);
                break;
            }
            case 105: {
                this.consumeSingleMemberAnnotation(true);
                break;
            }
            case 106: {
                this.consumeNonTypeUseName();
                break;
            }
            case 107: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 108: {
                this.consumeExplicitThisParameter(false);
                break;
            }
            case 109: {
                this.consumeExplicitThisParameter(true);
                break;
            }
            case 110: {
                this.consumeVariableDeclaratorIdParameter();
                break;
            }
            case 111: {
                this.consumeCompilationUnit();
                break;
            }
            case 112: {
                this.consumeInternalCompilationUnit();
                break;
            }
            case 113: {
                this.consumeInternalCompilationUnit();
                break;
            }
            case 114: {
                this.consumeInternalCompilationUnitWithTypes();
                break;
            }
            case 115: {
                this.consumeInternalCompilationUnitWithTypes();
                break;
            }
            case 116: {
                this.consumeInternalCompilationUnit();
                break;
            }
            case 117: {
                this.consumeInternalCompilationUnitWithTypes();
                break;
            }
            case 118: {
                this.consumeInternalCompilationUnitWithTypes();
                break;
            }
            case 119: {
                this.consumeEmptyInternalCompilationUnit();
                break;
            }
            case 120: {
                this.consumeInternalCompilationUnitWithModuleDeclaration();
                break;
            }
            case 121: {
                this.consumeInternalCompilationUnitWithModuleDeclaration();
                break;
            }
            case 122: {
                this.consumeModuleDeclaration();
                break;
            }
            case 123: {
                this.consumeModuleHeader();
                break;
            }
            case 125: {
                this.consumeModuleModifiers();
                break;
            }
            case 128: {
                this.consumeEmptyModuleStatementsOpt();
                break;
            }
            case 131: {
                this.consumeModuleStatements();
                break;
            }
            case 137: {
                this.consumeRequiresStatement();
                break;
            }
            case 138: {
                this.consumeSingleRequiresModuleName();
                break;
            }
            case 139: {
                this.consumeModifiers();
                break;
            }
            case 140: {
                this.consumeDefaultModifiers();
                break;
            }
            case 142: {
                this.consumeModifiers2();
                break;
            }
            case 145: {
                this.consumeExportsStatement();
                break;
            }
            case 146: {
                this.consumeExportsHeader();
                break;
            }
            case 148: {
                this.consumeTargetModuleList();
                break;
            }
            case 149: {
                this.consumeSingleTargetModuleName();
                break;
            }
            case 151: {
                this.consumeTargetModuleNameList();
                break;
            }
            case 152: {
                this.consumeSinglePkgName();
                break;
            }
            case 153: {
                this.consumeOpensStatement();
                break;
            }
            case 154: {
                this.consumeOpensHeader();
                break;
            }
            case 155: {
                this.consumeUsesStatement();
                break;
            }
            case 156: {
                this.consumeUsesHeader();
                break;
            }
            case 157: {
                this.consumeProvidesStatement();
                break;
            }
            case 158: {
                this.consumeProvidesInterface();
                break;
            }
            case 159: {
                this.consumeSingleServiceImplName();
                break;
            }
            case 161: {
                this.consumeServiceImplNameList();
                break;
            }
            case 162: {
                this.consumeWithClause();
                break;
            }
            case 163: {
                this.consumeReduceImports();
                break;
            }
            case 164: {
                this.consumeEnterCompilationUnit();
                break;
            }
            case 187: {
                this.consumeCatchHeader();
                break;
            }
            case 189: {
                this.consumeImportDeclarations();
                break;
            }
            case 191: {
                this.consumeTypeDeclarations();
                break;
            }
            case 192: {
                this.consumePackageDeclaration();
                break;
            }
            case 193: {
                this.consumePackageDeclarationNameWithModifiers();
                break;
            }
            case 194: {
                this.consumePackageDeclarationName();
                break;
            }
            case 195: {
                this.consumePackageComment();
                break;
            }
            case 200: {
                this.consumeImportDeclaration();
                break;
            }
            case 201: {
                this.consumeSingleTypeImportDeclarationName();
                break;
            }
            case 202: {
                this.consumeImportDeclaration();
                break;
            }
            case 203: {
                this.consumeTypeImportOnDemandDeclarationName();
                break;
            }
            case 206: {
                this.consumeEmptyTypeDeclaration();
                break;
            }
            case 211: {
                this.consumeModifiers2();
                break;
            }
            case 224: {
                this.consumeAnnotationAsModifier();
                break;
            }
            case 237: {
                this.consumeAspectDeclaration();
                break;
            }
            case 238: {
                this.consumeAspectHeader();
                break;
            }
            case 241: {
                this.consumeAspectHeaderNameWithTypeParameters(false);
                break;
            }
            case 242: {
                this.consumeAspectHeaderNameWithTypeParameters(true);
                break;
            }
            case 243: {
                this.consumeAspectHeaderName(false);
                break;
            }
            case 244: {
                this.consumeAspectHeaderName(true);
                break;
            }
            case 246: {
                this.consumeAspectHeaderRest();
                break;
            }
            case 247: {
                this.consumePseudoTokenIdentifier();
                break;
            }
            case 250: {
                this.consumeClassBodyDeclarations();
                break;
            }
            case 251: {
                this.consumeEmptyClassBodyDeclarationsopt();
                break;
            }
            case 252: {
                this.consumeClassBodyDeclarationsopt();
                break;
            }
            case 253: {
                this.consumeClassBodyDeclarationInAspect();
                break;
            }
            case 257: {
                this.consumeClassBodyDeclaration();
                break;
            }
            case 267: {
                this.consumeEmptyTypeDeclaration();
                break;
            }
            case 269: {
                this.consumeMethodDeclaration(true, false);
                break;
            }
            case 270: {
                this.consumeMethodDeclaration(false, false);
                break;
            }
            case 271: {
                this.consumeMethodHeader();
                break;
            }
            case 272: {
                this.consumeMethodHeaderNameWithTypeParameters(false);
                break;
            }
            case 273: {
                this.consumeMethodHeaderName(false);
                break;
            }
            case 274: {
                this.consumeEmptyPointcutDeclaration();
                break;
            }
            case 275: {
                this.consumePointcutDeclaration();
                break;
            }
            case 276: {
                this.consumePointcutHeader();
                break;
            }
            case 279: {
                this.consumeAroundDeclaration();
                break;
            }
            case 280: {
                this.consumeAroundHeader();
                break;
            }
            case 281: {
                this.consumeAroundHeaderName();
                break;
            }
            case 282: {
                this.consumeAroundHeaderNameMissingReturnType();
                break;
            }
            case 283: {
                this.consumeBasicAdviceDeclaration();
                break;
            }
            case 286: {
                this.consumeBasicAdviceHeader();
                break;
            }
            case 287: {
                this.consumeBasicAdviceHeader();
                break;
            }
            case 288: {
                this.consumeBasicAdviceHeaderName(false);
                break;
            }
            case 289: {
                this.consumeBasicAdviceHeaderName(true);
                break;
            }
            case 290: {
                this.consumeExtraParameterWithFormal();
                break;
            }
            case 291: {
                this.consumeExtraParameterNoFormal();
                break;
            }
            case 292: {
                this.consumeExtraParameterNoFormal();
                break;
            }
            case 294: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 295: {
                this.consumeZeroTypeAnnotations();
                this.consumeQualifiedName();
                break;
            }
            case 300: {
                this.consumeInterTypeMethodDeclaration(true);
                break;
            }
            case 301: {
                this.consumeInterTypeMethodHeader();
                break;
            }
            case 302: {
                this.consumeInterTypeMethodHeaderName(false, false);
                break;
            }
            case 303: {
                this.consumeInterTypeMethodHeaderNameIllegallyUsingTypePattern("*");
                break;
            }
            case 304: {
                this.consumeInterTypeMethodHeaderNameIllegallyUsingTypePattern("+");
                break;
            }
            case 305: {
                this.consumeInterTypeMethodHeaderName(false, true);
                break;
            }
            case 306: {
                this.consumeInterTypeMethodHeaderName(true, false);
                break;
            }
            case 307: {
                this.consumeInterTypeMethodHeaderName(true, true);
                break;
            }
            case 308: {
                this.consumeInterTypeMethodDeclaration(false);
                break;
            }
            case 309: {
                this.convertTypeParametersToSingleTypeReferences();
                break;
            }
            case 310: {
                this.consumeInterTypeConstructorDeclaration();
                break;
            }
            case 311: {
                this.consumeInterTypeConstructorHeader();
                break;
            }
            case 312: {
                this.consumeInterTypeConstructorHeaderName(false, false);
                break;
            }
            case 313: {
                this.consumeInterTypeConstructorHeaderNameIllegallyUsingTypePattern("*");
                break;
            }
            case 314: {
                this.consumeInterTypeConstructorHeaderNameIllegallyUsingTypePattern("+");
                break;
            }
            case 315: {
                this.consumeInterTypeConstructorHeaderName(true, false);
                break;
            }
            case 316: {
                this.consumeInterTypeConstructorHeaderName(false, true);
                break;
            }
            case 317: {
                this.consumeInterTypeConstructorHeaderName(true, true);
                break;
            }
            case 318: {
                this.consumeInterTypeFieldDeclaration();
                break;
            }
            case 319: {
                this.consumeInterTypeFieldHeader(false);
                break;
            }
            case 320: {
                this.consumeInterTypeFieldHeaderIllegallyAttemptingToUseATypePattern("*");
                break;
            }
            case 321: {
                this.consumeInterTypeFieldHeaderIllegallyAttemptingToUseATypePattern("+");
                break;
            }
            case 322: {
                this.consumeInterTypeFieldHeader(true);
                break;
            }
            case 323: {
                this.consumeExitITDVariableWithoutInitializer();
                break;
            }
            case 324: {
                this.consumeExitITDVariableWithInitializer();
                break;
            }
            case 326: {
                this.consumeDeclareDeclaration();
                break;
            }
            case 327: {
                this.consumeDeclareHeader();
                break;
            }
            case 328: {
                this.consumeDeclareAnnotation(' ');
                break;
            }
            case 329: {
                this.consumeDeclareAnnotation('+');
                break;
            }
            case 330: {
                this.consumeDeclareAnnotation('-');
                break;
            }
            case 333: {
                this.consumeDeclareAnnotationHeader();
                break;
            }
            case 336: {
                this.consumePseudoTokens();
                break;
            }
            case 337: {
                this.consumePseudoTokens();
                break;
            }
            case 339: {
                this.consumePseudoTokens();
                break;
            }
            case 340: {
                this.consumePseudoToken(":");
                break;
            }
            case 341: {
                this.consumePseudoTokenIdentifier();
                break;
            }
            case 342: {
                this.consumePseudoToken("(");
                break;
            }
            case 343: {
                this.consumePseudoToken(")");
                break;
            }
            case 344: {
                this.consumePseudoToken(".");
                break;
            }
            case 345: {
                this.consumePseudoToken("*");
                break;
            }
            case 346: {
                this.consumePseudoToken("+");
                break;
            }
            case 347: {
                this.consumePseudoToken("=");
                break;
            }
            case 348: {
                this.consumePseudoToken("&&");
                break;
            }
            case 349: {
                this.consumePseudoToken("||");
                break;
            }
            case 350: {
                this.consumePseudoToken("!");
                break;
            }
            case 351: {
                this.consumePseudoToken(",");
                break;
            }
            case 352: {
                this.consumePseudoToken("[");
                break;
            }
            case 353: {
                this.consumePseudoToken("]");
                break;
            }
            case 354: {
                this.consumePseudoToken("@");
                break;
            }
            case 355: {
                this.consumePseudoToken("...");
                break;
            }
            case 356: {
                this.consumePseudoToken("?");
                break;
            }
            case 357: {
                this.consumePseudoToken("<");
                break;
            }
            case 358: {
                this.consumePseudoToken(">");
                break;
            }
            case 359: {
                this.consumePseudoToken(">>");
                break;
            }
            case 360: {
                this.consumePseudoToken(">>>");
                break;
            }
            case 361: {
                this.consumePseudoToken("&");
                break;
            }
            case 362: {
                this.consumePseudoToken("!=");
                break;
            }
            case 363: {
                this.consumePseudoTokenPrimitiveType();
                break;
            }
            case 364: {
                this.consumePseudoTokenModifier();
                break;
            }
            case 365: {
                this.consumePseudoTokenLiteral();
                break;
            }
            case 366: {
                this.consumePseudoToken("this", 1, true);
                break;
            }
            case 367: {
                this.consumePseudoToken("class", 1, true);
                break;
            }
            case 368: {
                this.consumePseudoToken("super", 1, true);
                break;
            }
            case 369: {
                this.consumePseudoTokenIf();
                break;
            }
            case 370: {
                this.consumePseudoToken("assert", 1, true);
                break;
            }
            case 371: {
                this.consumePseudoToken("import", 1, true);
                break;
            }
            case 372: {
                this.consumePseudoToken("package", 1, true);
                break;
            }
            case 373: {
                this.consumePseudoToken("throw", 1, true);
                break;
            }
            case 374: {
                this.consumePseudoToken("new", 1, true);
                break;
            }
            case 375: {
                this.consumePseudoToken("do", 1, true);
                break;
            }
            case 376: {
                this.consumePseudoToken("for", 1, true);
                break;
            }
            case 377: {
                this.consumePseudoToken("switch", 1, true);
                break;
            }
            case 378: {
                this.consumePseudoToken("try", 1, true);
                break;
            }
            case 379: {
                this.consumePseudoToken("while", 1, true);
                break;
            }
            case 380: {
                this.consumePseudoToken("break", 1, true);
                break;
            }
            case 381: {
                this.consumePseudoToken("continue", 1, true);
                break;
            }
            case 382: {
                this.consumePseudoToken("return", 1, true);
                break;
            }
            case 383: {
                this.consumePseudoToken("case", 1, true);
                break;
            }
            case 384: {
                this.consumePseudoToken("catch", 0, true);
                break;
            }
            case 385: {
                this.consumePseudoToken("instanceof", 0, true);
                break;
            }
            case 386: {
                this.consumePseudoToken("else", 0, true);
                break;
            }
            case 387: {
                this.consumePseudoToken("extends", 0, true);
                break;
            }
            case 388: {
                this.consumePseudoToken("finally", 0, true);
                break;
            }
            case 389: {
                this.consumePseudoToken("implements", 0, true);
                break;
            }
            case 390: {
                this.consumePseudoToken("throws", 0, true);
                break;
            }
            case 391: {
                this.consumeClassDeclaration();
                break;
            }
            case 392: {
                this.consumeIntertypeClassDeclaration();
                break;
            }
            case 393: {
                this.consumeIntertypeClassHeader();
                break;
            }
            case 394: {
                this.consumeIntertypeTypeHeaderNameWithTypeParameters();
                break;
            }
            case 396: {
                this.consumeIntertypeClassHeaderName(false);
                break;
            }
            case 397: {
                this.consumeIntertypeClassHeaderName(true);
                break;
            }
            case 398: {
                this.consumeClassHeader();
                break;
            }
            case 399: {
                this.consumeTypeHeaderNameWithTypeParameters();
                break;
            }
            case 401: {
                this.consumeClassHeaderName1();
                break;
            }
            case 402: {
                this.consumeClassHeaderExtends();
                break;
            }
            case 403: {
                this.consumeClassHeaderImplements();
                break;
            }
            case 405: {
                this.consumeInterfaceTypeList();
                break;
            }
            case 406: {
                this.consumeInterfaceType();
                break;
            }
            case 409: {
                this.consumeClassBodyDeclarations();
                break;
            }
            case 413: {
                this.consumeClassBodyDeclaration();
                break;
            }
            case 414: {
                this.consumeDiet();
                break;
            }
            case 415: {
                this.consumeClassBodyDeclaration();
                break;
            }
            case 416: {
                this.consumeCreateInitializer();
                break;
            }
            case 424: {
                this.consumeEmptyTypeDeclaration();
                break;
            }
            case 427: {
                this.consumeFieldDeclaration();
                break;
            }
            case 429: {
                this.consumeVariableDeclarators();
                break;
            }
            case 432: {
                this.consumeEnterVariable();
                break;
            }
            case 433: {
                this.consumeExitVariableWithInitialization();
                break;
            }
            case 434: {
                this.consumeExitVariableWithoutInitialization();
                break;
            }
            case 435: {
                this.consumeForceNoDiet();
                break;
            }
            case 436: {
                this.consumeRestoreDiet();
                break;
            }
            case 441: {
                this.consumeMethodDeclaration(true, false);
                break;
            }
            case 442: {
                this.consumeMethodDeclaration(true, true);
                break;
            }
            case 443: {
                this.consumeMethodDeclaration(false, false);
                break;
            }
            case 444: {
                this.consumeMethodHeader();
                break;
            }
            case 445: {
                this.consumeMethodHeader();
                break;
            }
            case 446: {
                this.consumeMethodHeaderNameWithTypeParameters(false);
                break;
            }
            case 447: {
                this.consumeMethodHeaderName(false);
                break;
            }
            case 448: {
                this.consumeMethodHeaderNameWithTypeParameters(false);
                break;
            }
            case 449: {
                this.consumeMethodHeaderName(false);
                break;
            }
            case 450: {
                this.consumePushCombineModifiers();
                break;
            }
            case 451: {
                this.consumeMethodHeaderRightParen();
                break;
            }
            case 452: {
                this.consumeMethodHeaderExtendedDims();
                break;
            }
            case 453: {
                this.consumeMethodHeaderThrowsClause();
                break;
            }
            case 454: {
                this.consumeConstructorHeader();
                break;
            }
            case 455: {
                this.consumeConstructorHeaderNameWithTypeParameters();
                break;
            }
            case 456: {
                this.consumeConstructorHeaderName();
                break;
            }
            case 457: {
                this.consumeConstructorHeaderName();
                break;
            }
            case 459: {
                this.consumeFormalParameterList();
                break;
            }
            case 460: {
                this.consumeFormalParameter(false);
                break;
            }
            case 461: {
                this.consumeFormalParameter(true);
                break;
            }
            case 462: {
                this.consumeFormalParameter(true);
                break;
            }
            case 463: {
                this.consumeCatchFormalParameter();
                break;
            }
            case 464: {
                this.consumeCatchType();
                break;
            }
            case 465: {
                this.consumeUnionTypeAsClassType();
                break;
            }
            case 466: {
                this.consumeUnionType();
                break;
            }
            case 468: {
                this.consumeClassTypeList();
                break;
            }
            case 469: {
                this.consumeClassTypeElt();
                break;
            }
            case 470: {
                this.consumeMethodBody();
                break;
            }
            case 471: {
                this.consumeNestedMethod();
                break;
            }
            case 472: {
                this.consumeStaticInitializer();
                break;
            }
            case 473: {
                this.consumeStaticOnly();
                break;
            }
            case 474: {
                this.consumeConstructorDeclaration();
                break;
            }
            case 475: {
                this.consumeInvalidConstructorDeclaration();
                break;
            }
            case 476: {
                this.consumeExplicitConstructorInvocation(0, 3);
                break;
            }
            case 477: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(0, 3);
                break;
            }
            case 478: {
                this.consumeExplicitConstructorInvocation(0, 2);
                break;
            }
            case 479: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(0, 2);
                break;
            }
            case 480: {
                this.consumeExplicitConstructorInvocation(1, 2);
                break;
            }
            case 481: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(1, 2);
                break;
            }
            case 482: {
                this.consumeExplicitConstructorInvocation(2, 2);
                break;
            }
            case 483: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(2, 2);
                break;
            }
            case 484: {
                this.consumeExplicitConstructorInvocation(1, 3);
                break;
            }
            case 485: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(1, 3);
                break;
            }
            case 486: {
                this.consumeExplicitConstructorInvocation(2, 3);
                break;
            }
            case 487: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(2, 3);
                break;
            }
            case 488: {
                this.consumeInterfaceDeclaration();
                break;
            }
            case 489: {
                this.consumeInterfaceHeader();
                break;
            }
            case 490: {
                this.consumeTypeHeaderNameWithTypeParameters();
                break;
            }
            case 492: {
                this.consumeInterfaceHeaderName1();
                break;
            }
            case 493: {
                this.consumeInterfaceHeaderExtends();
                break;
            }
            case 496: {
                this.consumeInterfaceMemberDeclarations();
                break;
            }
            case 497: {
                this.consumeEmptyTypeDeclaration();
                break;
            }
            case 499: {
                this.consumeInterfaceMethodDeclaration(false);
                break;
            }
            case 500: {
                this.consumeInterfaceMethodDeclaration(false);
                break;
            }
            case 501: {
                this.consumeInterfaceMethodDeclaration(true);
                break;
            }
            case 502: {
                this.consumeInvalidConstructorDeclaration(true);
                break;
            }
            case 503: {
                this.consumeInvalidConstructorDeclaration(false);
                break;
            }
            case 514: {
                this.consumeRecordDeclaration();
                break;
            }
            case 515: {
                this.consumeRecordHeaderPart();
                break;
            }
            case 516: {
                this.consumeRecordHeaderNameWithTypeParameters();
                break;
            }
            case 518: {
                this.consumeRecordHeaderName1();
                break;
            }
            case 519: {
                this.consumeRecordComponentHeaderRightParen();
                break;
            }
            case 520: {
                this.consumeRecordHeader();
                break;
            }
            case 521: {
                this.consumeRecordComponentsopt();
                break;
            }
            case 524: {
                this.consumeRecordComponents();
                break;
            }
            case 526: {
                this.consumeRecordComponent(false);
                break;
            }
            case 527: {
                this.consumeRecordComponent(true);
                break;
            }
            case 528: {
                this.consumeRecordComponent(true);
                break;
            }
            case 529: {
                this.consumeRecordBody();
                break;
            }
            case 530: {
                this.consumeEmptyRecordBodyDeclaration();
                break;
            }
            case 533: {
                this.consumeRecordBodyDeclarations();
                break;
            }
            case 534: {
                this.consumeRecordBodyDeclaration();
                break;
            }
            case 535: {
                this.consumeRecordBodyDeclaration();
                break;
            }
            case 536: {
                this.consumeCompactConstructorDeclaration();
                break;
            }
            case 537: {
                this.consumeCompactConstructorHeader();
                break;
            }
            case 538: {
                this.consumeCompactConstructorHeaderName();
                break;
            }
            case 539: {
                this.consumeCompactConstructorHeaderNameWithTypeParameters();
                break;
            }
            case 541: {
                this.consumeInstanceOfExpression();
                break;
            }
            case 545: {
                this.consumeTypeTestPattern();
                break;
            }
            case 547: {
                this.consumePushLeftBrace();
                break;
            }
            case 548: {
                this.consumeEmptyArrayInitializer();
                break;
            }
            case 549: {
                this.consumeArrayInitializer();
                break;
            }
            case 550: {
                this.consumeArrayInitializer();
                break;
            }
            case 552: {
                this.consumeVariableInitializers();
                break;
            }
            case 553: {
                this.consumeBlock();
                break;
            }
            case 554: {
                this.consumeOpenBlock();
                break;
            }
            case 555: {
                this.consumeBlockStatement();
                break;
            }
            case 556: {
                this.consumeBlockStatements();
                break;
            }
            case 564: {
                this.consumeInvalidInterfaceDeclaration();
                break;
            }
            case 565: {
                this.consumeInvalidAnnotationTypeDeclaration();
                break;
            }
            case 566: {
                this.consumeInvalidEnumDeclaration();
                break;
            }
            case 567: {
                this.consumeLocalVariableDeclarationStatement();
                break;
            }
            case 568: {
                this.consumeLocalVariableDeclaration();
                break;
            }
            case 569: {
                this.consumeLocalVariableDeclaration();
                break;
            }
            case 570: {
                this.consumePushModifiers();
                break;
            }
            case 571: {
                this.consumePushModifiersForHeader();
                break;
            }
            case 572: {
                this.consumePushRealModifiers();
                break;
            }
            case 600: {
                this.consumeEmptyStatement();
                break;
            }
            case 601: {
                this.consumeStatementLabel();
                break;
            }
            case 602: {
                this.consumeStatementLabel();
                break;
            }
            case 603: {
                this.consumeLabel();
                break;
            }
            case 604: {
                this.consumeExpressionStatement();
                break;
            }
            case 613: {
                this.consumeStatementIfNoElse();
                break;
            }
            case 614: {
                this.consumeStatementIfWithElse();
                break;
            }
            case 615: {
                this.consumeStatementIfWithElse();
                break;
            }
            case 616: {
                this.consumeStatementSwitch();
                break;
            }
            case 617: {
                this.consumeEmptySwitchBlock();
                break;
            }
            case 620: {
                this.consumeSwitchBlock();
                break;
            }
            case 622: {
                this.consumeSwitchBlockStatements();
                break;
            }
            case 624: {
                this.consumeSwitchBlockStatement();
                break;
            }
            case 626: {
                this.consumeSwitchLabels();
                break;
            }
            case 627: {
                this.consumeCaseLabel();
                break;
            }
            case 628: {
                this.consumeDefaultLabel();
                break;
            }
            case 631: {
                this.consumeSwitchExpression();
                break;
            }
            case 634: {
                this.consumeSwitchLabeledRule();
                break;
            }
            case 635: {
                this.consumeSwitchLabeledExpression();
                break;
            }
            case 636: {
                this.consumeSwitchLabeledBlock();
                break;
            }
            case 637: {
                this.consumeSwitchLabeledThrowStatement();
                break;
            }
            case 638: {
                this.consumeDefaultLabelExpr();
                break;
            }
            case 639: {
                this.consumeCaseLabelExpr();
                break;
            }
            case 640: {
                this.consumeSwitchLabelCaseLhs();
                break;
            }
            case 641: {
                this.consumeStatementYield();
                break;
            }
            case 642: {
                this.consumeStatementWhile();
                break;
            }
            case 643: {
                this.consumeStatementWhile();
                break;
            }
            case 644: {
                this.consumeStatementDo();
                break;
            }
            case 645: {
                this.consumeStatementFor();
                break;
            }
            case 646: {
                this.consumeStatementFor();
                break;
            }
            case 647: {
                this.consumeForInit();
                break;
            }
            case 651: {
                this.consumeStatementExpressionList();
                break;
            }
            case 652: {
                this.consumeSimpleAssertStatement();
                break;
            }
            case 653: {
                this.consumeAssertStatement();
                break;
            }
            case 654: {
                this.consumeStatementBreak();
                break;
            }
            case 655: {
                this.consumeStatementBreakWithLabel();
                break;
            }
            case 656: {
                this.consumeStatementContinue();
                break;
            }
            case 657: {
                this.consumeStatementContinueWithLabel();
                break;
            }
            case 658: {
                this.consumeStatementReturn();
                break;
            }
            case 659: {
                this.consumeStatementThrow();
                break;
            }
            case 660: {
                this.consumeThrowExpression();
                break;
            }
            case 661: {
                this.consumeStatementSynchronized();
                break;
            }
            case 662: {
                this.consumeOnlySynchronized();
                break;
            }
            case 663: {
                this.consumeStatementTry(false, false);
                break;
            }
            case 664: {
                this.consumeStatementTry(true, false);
                break;
            }
            case 665: {
                this.consumeStatementTry(false, true);
                break;
            }
            case 666: {
                this.consumeStatementTry(true, true);
                break;
            }
            case 667: {
                this.consumeResourceSpecification();
                break;
            }
            case 668: {
                this.consumeResourceOptionalTrailingSemiColon(false);
                break;
            }
            case 669: {
                this.consumeResourceOptionalTrailingSemiColon(true);
                break;
            }
            case 670: {
                this.consumeSingleResource();
                break;
            }
            case 671: {
                this.consumeMultipleResources();
                break;
            }
            case 672: {
                this.consumeResourceOptionalTrailingSemiColon(true);
                break;
            }
            case 673: {
                this.consumeResourceAsLocalVariableDeclaration();
                break;
            }
            case 674: {
                this.consumeResourceAsLocalVariableDeclaration();
                break;
            }
            case 675: {
                this.consumeResourceAsLocalVariable();
                break;
            }
            case 676: {
                this.consumeResourceAsFieldAccess();
                break;
            }
            case 678: {
                this.consumeExitTryBlock();
                break;
            }
            case 680: {
                this.consumeCatches();
                break;
            }
            case 681: {
                this.consumeStatementCatch();
                break;
            }
            case 683: {
                this.consumeLeftParen();
                break;
            }
            case 684: {
                this.consumeRightParen();
                break;
            }
            case 689: {
                this.consumePrimaryNoNewArrayThis();
                break;
            }
            case 690: {
                this.consumePrimaryNoNewArray();
                break;
            }
            case 691: {
                this.consumePrimaryNoNewArrayWithName();
                break;
            }
            case 694: {
                this.consumePrimaryNoNewArrayNameThis();
                break;
            }
            case 695: {
                this.consumeQualifiedSuperReceiver();
                break;
            }
            case 696: {
                this.consumePrimaryNoNewArrayName();
                break;
            }
            case 697: {
                this.consumePrimaryNoNewArrayArrayType();
                break;
            }
            case 698: {
                this.consumePrimaryNoNewArrayPrimitiveArrayType();
                break;
            }
            case 699: {
                this.consumePrimaryNoNewArrayPrimitiveType();
                break;
            }
            case 705: {
                this.consumeReferenceExpressionTypeArgumentsAndTrunk(false);
                break;
            }
            case 706: {
                this.consumeReferenceExpressionTypeArgumentsAndTrunk(true);
                break;
            }
            case 707: {
                this.consumeReferenceExpressionTypeForm(true);
                break;
            }
            case 708: {
                this.consumeReferenceExpressionTypeForm(false);
                break;
            }
            case 709: {
                this.consumeReferenceExpressionGenericTypeForm();
                break;
            }
            case 710: {
                this.consumeReferenceExpressionPrimaryForm();
                break;
            }
            case 711: {
                this.consumeReferenceExpressionPrimaryForm();
                break;
            }
            case 712: {
                this.consumeReferenceExpressionSuperForm();
                break;
            }
            case 713: {
                this.consumeEmptyTypeArguments();
                break;
            }
            case 715: {
                this.consumeIdentifierOrNew(false);
                break;
            }
            case 716: {
                this.consumeIdentifierOrNew(true);
                break;
            }
            case 717: {
                this.consumeLambdaExpression();
                break;
            }
            case 718: {
                this.consumeNestedLambda();
                break;
            }
            case 719: {
                this.consumeTypeElidedLambdaParameter(false);
                break;
            }
            case 725: {
                this.consumeFormalParameterList();
                break;
            }
            case 726: {
                this.consumeTypeElidedLambdaParameter(true);
                break;
            }
            case 729: {
                this.consumeElidedLeftBraceAndReturn();
                break;
            }
            case 730: {
                this.consumeAllocationHeader();
                break;
            }
            case 731: {
                this.consumeClassInstanceCreationExpressionWithTypeArguments();
                break;
            }
            case 732: {
                this.consumeClassInstanceCreationExpression();
                break;
            }
            case 733: {
                this.consumeClassInstanceCreationExpressionQualifiedWithTypeArguments();
                break;
            }
            case 734: {
                this.consumeClassInstanceCreationExpressionQualified();
                break;
            }
            case 735: {
                this.consumeClassInstanceCreationExpressionQualified();
                break;
            }
            case 736: {
                this.consumeClassInstanceCreationExpressionQualifiedWithTypeArguments();
                break;
            }
            case 737: {
                this.consumeEnterInstanceCreationArgumentList();
                break;
            }
            case 738: {
                this.consumeClassInstanceCreationExpressionName();
                break;
            }
            case 739: {
                this.consumeClassBodyopt();
                break;
            }
            case 741: {
                this.consumeEnterAnonymousClassBody(false);
                break;
            }
            case 742: {
                this.consumeClassBodyopt();
                break;
            }
            case 744: {
                this.consumeEnterAnonymousClassBody(true);
                break;
            }
            case 746: {
                this.consumeArgumentList();
                break;
            }
            case 747: {
                this.consumeArrayCreationHeader();
                break;
            }
            case 748: {
                this.consumeArrayCreationHeader();
                break;
            }
            case 749: {
                this.consumeArrayCreationExpressionWithoutInitializer();
                break;
            }
            case 750: {
                this.consumeArrayCreationExpressionWithInitializer();
                break;
            }
            case 751: {
                this.consumeArrayCreationExpressionWithoutInitializer();
                break;
            }
            case 752: {
                this.consumeArrayCreationExpressionWithInitializer();
                break;
            }
            case 754: {
                this.consumeDimWithOrWithOutExprs();
                break;
            }
            case 756: {
                this.consumeDimWithOrWithOutExpr();
                break;
            }
            case 757: {
                this.consumeDims();
                break;
            }
            case 760: {
                this.consumeOneDimLoop(false);
                break;
            }
            case 761: {
                this.consumeOneDimLoop(true);
                break;
            }
            case 762: {
                this.consumeFieldAccess(false);
                break;
            }
            case 763: {
                this.consumeFieldAccess(true);
                break;
            }
            case 764: {
                this.consumeFieldAccess(false);
                break;
            }
            case 765: {
                this.consumeMethodInvocationName();
                break;
            }
            case 766: {
                this.consumeMethodInvocationNameWithTypeArguments();
                break;
            }
            case 767: {
                this.consumeMethodInvocationPrimaryWithTypeArguments();
                break;
            }
            case 768: {
                this.consumeMethodInvocationPrimary();
                break;
            }
            case 769: {
                this.consumeMethodInvocationPrimary();
                break;
            }
            case 770: {
                this.consumeMethodInvocationPrimaryWithTypeArguments();
                break;
            }
            case 771: {
                this.consumeMethodInvocationSuperWithTypeArguments();
                break;
            }
            case 772: {
                this.consumeMethodInvocationSuper();
                break;
            }
            case 773: {
                this.consumeArrayAccess(true);
                break;
            }
            case 774: {
                this.consumeArrayAccess(true);
                break;
            }
            case 775: {
                this.consumeArrayAccess(false);
                break;
            }
            case 776: {
                this.consumeArrayAccess(false);
                break;
            }
            case 778: {
                this.consumePostfixExpression();
                break;
            }
            case 781: {
                this.consumeUnaryExpression(14, true);
                break;
            }
            case 782: {
                this.consumeUnaryExpression(13, true);
                break;
            }
            case 783: {
                this.consumePushPosition();
                break;
            }
            case 786: {
                this.consumeUnaryExpression(14);
                break;
            }
            case 787: {
                this.consumeUnaryExpression(13);
                break;
            }
            case 789: {
                this.consumeUnaryExpression(14, false);
                break;
            }
            case 790: {
                this.consumeUnaryExpression(13, false);
                break;
            }
            case 792: {
                this.consumeUnaryExpression(12);
                break;
            }
            case 793: {
                this.consumeUnaryExpression(11);
                break;
            }
            case 795: {
                this.consumeCastExpressionWithPrimitiveType();
                break;
            }
            case 796: {
                this.consumeCastExpressionWithGenericsArray();
                break;
            }
            case 797: {
                this.consumeCastExpressionWithQualifiedGenericsArray();
                break;
            }
            case 798: {
                this.consumeCastExpressionLL1();
                break;
            }
            case 799: {
                this.consumeCastExpressionLL1WithBounds();
                break;
            }
            case 800: {
                this.consumeCastExpressionWithNameArray();
                break;
            }
            case 801: {
                this.consumeZeroAdditionalBounds();
                break;
            }
            case 805: {
                this.consumeOnlyTypeArgumentsForCastExpression();
                break;
            }
            case 806: {
                this.consumeInsideCastExpression();
                break;
            }
            case 807: {
                this.consumeInsideCastExpressionLL1();
                break;
            }
            case 808: {
                this.consumeInsideCastExpressionLL1WithBounds();
                break;
            }
            case 809: {
                this.consumeInsideCastExpressionWithQualifiedGenerics();
                break;
            }
            case 811: {
                this.consumeBinaryExpression(15);
                break;
            }
            case 812: {
                this.consumeBinaryExpression(9);
                break;
            }
            case 813: {
                this.consumeBinaryExpression(16);
                break;
            }
            case 815: {
                this.consumeBinaryExpression(14);
                break;
            }
            case 816: {
                this.consumeBinaryExpression(13);
                break;
            }
            case 818: {
                this.consumeBinaryExpression(10);
                break;
            }
            case 819: {
                this.consumeBinaryExpression(17);
                break;
            }
            case 820: {
                this.consumeBinaryExpression(19);
                break;
            }
            case 822: {
                this.consumeBinaryExpression(4);
                break;
            }
            case 823: {
                this.consumeBinaryExpression(6);
                break;
            }
            case 824: {
                this.consumeBinaryExpression(5);
                break;
            }
            case 825: {
                this.consumeBinaryExpression(7);
                break;
            }
            case 827: {
                this.consumeInstanceOfExpression();
                break;
            }
            case 829: {
                this.consumeEqualityExpression(18);
                break;
            }
            case 830: {
                this.consumeEqualityExpression(29);
                break;
            }
            case 832: {
                this.consumeBinaryExpression(2);
                break;
            }
            case 834: {
                this.consumeBinaryExpression(8);
                break;
            }
            case 836: {
                this.consumeBinaryExpression(3);
                break;
            }
            case 838: {
                this.consumeBinaryExpression(0);
                break;
            }
            case 840: {
                this.consumeBinaryExpression(1);
                break;
            }
            case 842: {
                this.consumeConditionalExpression(23);
                break;
            }
            case 845: {
                this.consumeAssignment();
                break;
            }
            case 847: {
                this.ignoreExpressionAssignment();
                break;
            }
            case 848: {
                this.consumeAssignmentOperator(30);
                break;
            }
            case 849: {
                this.consumeAssignmentOperator(15);
                break;
            }
            case 850: {
                this.consumeAssignmentOperator(9);
                break;
            }
            case 851: {
                this.consumeAssignmentOperator(16);
                break;
            }
            case 852: {
                this.consumeAssignmentOperator(14);
                break;
            }
            case 853: {
                this.consumeAssignmentOperator(13);
                break;
            }
            case 854: {
                this.consumeAssignmentOperator(10);
                break;
            }
            case 855: {
                this.consumeAssignmentOperator(17);
                break;
            }
            case 856: {
                this.consumeAssignmentOperator(19);
                break;
            }
            case 857: {
                this.consumeAssignmentOperator(2);
                break;
            }
            case 858: {
                this.consumeAssignmentOperator(8);
                break;
            }
            case 859: {
                this.consumeAssignmentOperator(3);
                break;
            }
            case 860: {
                this.consumeExpression();
                break;
            }
            case 863: {
                this.consumeEmptyExpression();
                break;
            }
            case 866: {
                this.consumeConstantExpressions();
                break;
            }
            case 870: {
                this.consumeEmptyClassBodyDeclarationsopt();
                break;
            }
            case 871: {
                this.consumeClassBodyDeclarationsopt();
                break;
            }
            case 872: {
                this.consumeDefaultModifiers();
                break;
            }
            case 873: {
                this.consumeModifiers();
                break;
            }
            case 874: {
                this.consumeEmptyBlockStatementsopt();
                break;
            }
            case 876: {
                this.consumeEmptyDimsopt();
                break;
            }
            case 878: {
                this.consumeEmptyArgumentListopt();
                break;
            }
            case 882: {
                this.consumeFormalParameterListopt();
                break;
            }
            case 886: {
                this.consumeEmptyInterfaceMemberDeclarationsopt();
                break;
            }
            case 887: {
                this.consumeInterfaceMemberDeclarationsopt();
                break;
            }
            case 888: {
                this.consumeNestedType();
                break;
            }
            case 889: {
                this.consumeEmptyForInitopt();
                break;
            }
            case 891: {
                this.consumeEmptyForUpdateopt();
                break;
            }
            case 895: {
                this.consumeEmptyCatchesopt();
                break;
            }
            case 897: {
                this.consumeEnumDeclaration();
                break;
            }
            case 898: {
                this.consumeEnumHeader();
                break;
            }
            case 899: {
                this.consumeEnumHeaderName();
                break;
            }
            case 900: {
                this.consumeEnumHeaderNameWithTypeParameters();
                break;
            }
            case 901: {
                this.consumeEnumBodyNoConstants();
                break;
            }
            case 902: {
                this.consumeEnumBodyNoConstants();
                break;
            }
            case 903: {
                this.consumeEnumBodyWithConstants();
                break;
            }
            case 904: {
                this.consumeEnumBodyWithConstants();
                break;
            }
            case 906: {
                this.consumeEnumConstants();
                break;
            }
            case 907: {
                this.consumeEnumConstantHeaderName();
                break;
            }
            case 908: {
                this.consumeEnumConstantHeader();
                break;
            }
            case 909: {
                this.consumeEnumConstantWithClassBody();
                break;
            }
            case 910: {
                this.consumeEnumConstantNoClassBody();
                break;
            }
            case 911: {
                this.consumeArguments();
                break;
            }
            case 912: {
                this.consumeEmptyArguments();
                break;
            }
            case 914: {
                this.consumeEnumDeclarations();
                break;
            }
            case 915: {
                this.consumeEmptyEnumDeclarations();
                break;
            }
            case 917: {
                this.consumeEnhancedForStatement();
                break;
            }
            case 918: {
                this.consumeEnhancedForStatement();
                break;
            }
            case 919: {
                this.consumeEnhancedForStatementHeaderInit(false);
                break;
            }
            case 920: {
                this.consumeEnhancedForStatementHeaderInit(true);
                break;
            }
            case 921: {
                this.consumeEnhancedForStatementHeader();
                break;
            }
            case 922: {
                this.consumeImportDeclaration();
                break;
            }
            case 923: {
                this.consumeSingleStaticImportDeclarationName();
                break;
            }
            case 924: {
                this.consumeImportDeclaration();
                break;
            }
            case 925: {
                this.consumeStaticImportOnDemandDeclarationName();
                break;
            }
            case 926: {
                this.consumeTypeArguments();
                break;
            }
            case 927: {
                this.consumeOnlyTypeArguments();
                break;
            }
            case 929: {
                this.consumeTypeArgumentList1();
                break;
            }
            case 931: {
                this.consumeTypeArgumentList();
                break;
            }
            case 932: {
                this.consumeTypeArgument();
                break;
            }
            case 936: {
                this.consumeReferenceType1();
                break;
            }
            case 937: {
                this.consumeTypeArgumentReferenceType1();
                break;
            }
            case 939: {
                this.consumeTypeArgumentList2();
                break;
            }
            case 942: {
                this.consumeReferenceType2();
                break;
            }
            case 943: {
                this.consumeTypeArgumentReferenceType2();
                break;
            }
            case 945: {
                this.consumeTypeArgumentList3();
                break;
            }
            case 948: {
                this.consumeReferenceType3();
                break;
            }
            case 949: {
                this.consumeWildcard();
                break;
            }
            case 950: {
                this.consumeWildcardWithBounds();
                break;
            }
            case 951: {
                this.consumeWildcardBoundsExtends();
                break;
            }
            case 952: {
                this.consumeWildcardBoundsSuper();
                break;
            }
            case 953: {
                this.consumeWildcard1();
                break;
            }
            case 954: {
                this.consumeWildcard1WithBounds();
                break;
            }
            case 955: {
                this.consumeWildcardBounds1Extends();
                break;
            }
            case 956: {
                this.consumeWildcardBounds1Super();
                break;
            }
            case 957: {
                this.consumeWildcard2();
                break;
            }
            case 958: {
                this.consumeWildcard2WithBounds();
                break;
            }
            case 959: {
                this.consumeWildcardBounds2Extends();
                break;
            }
            case 960: {
                this.consumeWildcardBounds2Super();
                break;
            }
            case 961: {
                this.consumeWildcard3();
                break;
            }
            case 962: {
                this.consumeWildcard3WithBounds();
                break;
            }
            case 963: {
                this.consumeWildcardBounds3Extends();
                break;
            }
            case 964: {
                this.consumeWildcardBounds3Super();
                break;
            }
            case 965: {
                this.consumeTypeParameterHeader();
                break;
            }
            case 966: {
                this.consumeTypeParameters();
                break;
            }
            case 968: {
                this.consumeTypeParameterList();
                break;
            }
            case 970: {
                this.consumeTypeParameterWithExtends();
                break;
            }
            case 971: {
                this.consumeTypeParameterWithExtendsAndBounds();
                break;
            }
            case 973: {
                this.consumeAdditionalBoundList();
                break;
            }
            case 974: {
                this.consumeAdditionalBound();
                break;
            }
            case 976: {
                this.consumeTypeParameterList1();
                break;
            }
            case 977: {
                this.consumeTypeParameter1();
                break;
            }
            case 978: {
                this.consumeTypeParameter1WithExtends();
                break;
            }
            case 979: {
                this.consumeTypeParameter1WithExtendsAndBounds();
                break;
            }
            case 981: {
                this.consumeAdditionalBoundList1();
                break;
            }
            case 982: {
                this.consumeAdditionalBound1();
                break;
            }
            case 988: {
                this.consumeUnaryExpression(14);
                break;
            }
            case 989: {
                this.consumeUnaryExpression(13);
                break;
            }
            case 992: {
                this.consumeUnaryExpression(12);
                break;
            }
            case 993: {
                this.consumeUnaryExpression(11);
                break;
            }
            case 996: {
                this.consumeBinaryExpression(15);
                break;
            }
            case 997: {
                this.consumeBinaryExpressionWithName(15);
                break;
            }
            case 998: {
                this.consumeBinaryExpression(9);
                break;
            }
            case 999: {
                this.consumeBinaryExpressionWithName(9);
                break;
            }
            case 1000: {
                this.consumeBinaryExpression(16);
                break;
            }
            case 1001: {
                this.consumeBinaryExpressionWithName(16);
                break;
            }
            case 1003: {
                this.consumeBinaryExpression(14);
                break;
            }
            case 1004: {
                this.consumeBinaryExpressionWithName(14);
                break;
            }
            case 1005: {
                this.consumeBinaryExpression(13);
                break;
            }
            case 1006: {
                this.consumeBinaryExpressionWithName(13);
                break;
            }
            case 1008: {
                this.consumeBinaryExpression(10);
                break;
            }
            case 1009: {
                this.consumeBinaryExpressionWithName(10);
                break;
            }
            case 1010: {
                this.consumeBinaryExpression(17);
                break;
            }
            case 1011: {
                this.consumeBinaryExpressionWithName(17);
                break;
            }
            case 1012: {
                this.consumeBinaryExpression(19);
                break;
            }
            case 1013: {
                this.consumeBinaryExpressionWithName(19);
                break;
            }
            case 1015: {
                this.consumeBinaryExpression(4);
                break;
            }
            case 1016: {
                this.consumeBinaryExpressionWithName(4);
                break;
            }
            case 1017: {
                this.consumeBinaryExpression(6);
                break;
            }
            case 1018: {
                this.consumeBinaryExpressionWithName(6);
                break;
            }
            case 1019: {
                this.consumeBinaryExpression(5);
                break;
            }
            case 1020: {
                this.consumeBinaryExpressionWithName(5);
                break;
            }
            case 1021: {
                this.consumeBinaryExpression(7);
                break;
            }
            case 1022: {
                this.consumeBinaryExpressionWithName(7);
                break;
            }
            case 1024: {
                this.consumeInstanceOfExpressionWithName();
                break;
            }
            case 1025: {
                this.consumeInstanceOfExpression();
                break;
            }
            case 1027: {
                this.consumeEqualityExpression(18);
                break;
            }
            case 1028: {
                this.consumeEqualityExpressionWithName(18);
                break;
            }
            case 1029: {
                this.consumeEqualityExpression(29);
                break;
            }
            case 1030: {
                this.consumeEqualityExpressionWithName(29);
                break;
            }
            case 1032: {
                this.consumeBinaryExpression(2);
                break;
            }
            case 1033: {
                this.consumeBinaryExpressionWithName(2);
                break;
            }
            case 1035: {
                this.consumeBinaryExpression(8);
                break;
            }
            case 1036: {
                this.consumeBinaryExpressionWithName(8);
                break;
            }
            case 1038: {
                this.consumeBinaryExpression(3);
                break;
            }
            case 1039: {
                this.consumeBinaryExpressionWithName(3);
                break;
            }
            case 1041: {
                this.consumeBinaryExpression(0);
                break;
            }
            case 1042: {
                this.consumeBinaryExpressionWithName(0);
                break;
            }
            case 1044: {
                this.consumeBinaryExpression(1);
                break;
            }
            case 1045: {
                this.consumeBinaryExpressionWithName(1);
                break;
            }
            case 1047: {
                this.consumeConditionalExpression(23);
                break;
            }
            case 1048: {
                this.consumeConditionalExpressionWithName(23);
                break;
            }
            case 1052: {
                this.consumeAnnotationTypeDeclarationHeaderName();
                break;
            }
            case 1053: {
                this.consumeAnnotationTypeDeclarationHeaderNameWithTypeParameters();
                break;
            }
            case 1054: {
                this.consumeAnnotationTypeDeclarationHeaderNameWithTypeParameters();
                break;
            }
            case 1055: {
                this.consumeAnnotationTypeDeclarationHeaderName();
                break;
            }
            case 1056: {
                this.consumeAnnotationTypeDeclarationHeader();
                break;
            }
            case 1057: {
                this.consumeAnnotationTypeDeclaration();
                break;
            }
            case 1059: {
                this.consumeEmptyAnnotationTypeMemberDeclarationsopt();
                break;
            }
            case 1060: {
                this.consumeAnnotationTypeMemberDeclarationsopt();
                break;
            }
            case 1062: {
                this.consumeAnnotationTypeMemberDeclarations();
                break;
            }
            case 1063: {
                this.consumeMethodHeaderNameWithTypeParameters(true);
                break;
            }
            case 1064: {
                this.consumeMethodHeaderName(true);
                break;
            }
            case 1065: {
                this.consumeEmptyMethodHeaderDefaultValue();
                break;
            }
            case 1066: {
                this.consumeMethodHeaderDefaultValue();
                break;
            }
            case 1067: {
                this.consumeMethodHeader();
                break;
            }
            case 1068: {
                this.consumeAnnotationTypeMemberDeclaration();
                break;
            }
            case 1076: {
                this.consumeAnnotationName();
                break;
            }
            case 1077: {
                this.consumeNormalAnnotation(false);
                break;
            }
            case 1078: {
                this.consumeEmptyMemberValuePairsopt();
                break;
            }
            case 1081: {
                this.consumeMemberValuePairs();
                break;
            }
            case 1082: {
                this.consumeMemberValuePair();
                break;
            }
            case 1083: {
                this.consumeEnterMemberValue();
                break;
            }
            case 1084: {
                this.consumeExitMemberValue();
                break;
            }
            case 1086: {
                this.consumeMemberValueAsName();
                break;
            }
            case 1089: {
                this.consumeMemberValueArrayInitializer();
                break;
            }
            case 1090: {
                this.consumeMemberValueArrayInitializer();
                break;
            }
            case 1091: {
                this.consumeEmptyMemberValueArrayInitializer();
                break;
            }
            case 1092: {
                this.consumeEmptyMemberValueArrayInitializer();
                break;
            }
            case 1093: {
                this.consumeEnterMemberValueArrayInitializer();
                break;
            }
            case 1095: {
                this.consumeMemberValues();
                break;
            }
            case 1096: {
                this.consumeMarkerAnnotation(false);
                break;
            }
            case 1097: {
                this.consumeSingleMemberAnnotationMemberValue();
                break;
            }
            case 1098: {
                this.consumeSingleMemberAnnotation(false);
                break;
            }
            case 1099: {
                this.consumeRecoveryMethodHeaderNameWithTypeParameters();
                break;
            }
            case 1100: {
                this.consumeRecoveryMethodHeaderName();
                break;
            }
            case 1101: {
                this.consumeRecoveryMethodHeaderNameWithTypeParameters();
                break;
            }
            case 1102: {
                this.consumeRecoveryMethodHeaderName();
                break;
            }
            case 1103: {
                this.consumeMethodHeader();
                break;
            }
            case 1104: {
                this.consumeMethodHeader();
            }
        }
    }

    protected void consumeQualifiedName() {
        this.consumeQualifiedName(false);
    }

    private void consumeIntertypeClassHeader() {
        TypeDeclaration typeDecl = (TypeDeclaration)this.astStack[this.astPtr];
        if (this.currentToken == 49) {
            typeDecl.bodyStart = this.scanner.currentPosition;
        }
        if (this.currentElement != null) {
            this.restartRecovery = true;
        }
        this.scanner.commentPtr = -1;
    }

    private void consumeIntertypeClassDeclaration() {
        TypeDeclaration typeDecl;
        boolean hasConstructor;
        int length;
        if ((length = this.astLengthStack[this.astLengthPtr--]) != 0) {
            this.dispatchDeclarationInto(length);
        }
        if (!(hasConstructor = (typeDecl = (TypeDeclaration)this.astStack[this.astPtr]).checkConstructors(this))) {
            switch (TypeDeclaration.kind(typeDecl.modifiers)) {
                case 1: 
                case 3: {
                    boolean insideFieldInitializer = false;
                    if (this.diet) {
                        int i = this.nestedType;
                        while (i > 0) {
                            if (this.variablesCounter[i] > 0) {
                                insideFieldInitializer = true;
                                break;
                            }
                            --i;
                        }
                    }
                    typeDecl.createDefaultConstructor(!this.diet || insideFieldInitializer, true);
                }
            }
        }
        if (this.scanner.containsAssertKeyword) {
            typeDecl.bits |= 1;
        }
        typeDecl.addClinit();
        typeDecl.bodyEnd = this.endStatementPosition;
        if (length == 0 && !this.containsComment(typeDecl.bodyStart, typeDecl.bodyEnd)) {
            typeDecl.bits |= 8;
        }
        typeDecl.declarationSourceEnd = this.flushCommentsDefinedPriorTo(this.endStatementPosition);
    }

    private void consumeIntertypeTypeHeaderNameWithTypeParameters() {
        TypeDeclaration typeDecl = (TypeDeclaration)this.astStack[this.astPtr];
        int length = this.genericsLengthStack[this.genericsLengthPtr--];
        this.genericsPtr -= length;
        typeDecl.typeParameters = new TypeParameter[length];
        System.arraycopy(this.genericsStack, this.genericsPtr + 1, typeDecl.typeParameters, 0, length);
        typeDecl.bodyStart = typeDecl.typeParameters[length - 1].declarationSourceEnd + 1;
        this.listTypeParameterLength = 0;
        if (this.currentElement != null) {
            RecoveredType recoveredType = (RecoveredType)this.currentElement;
            recoveredType.pendingTypeParameters = null;
            this.lastCheckPoint = typeDecl.bodyStart;
        }
    }

    private void consumeIntertypeClassHeaderName(boolean b) {
        int length;
        TypeDeclaration typeDecl = declarationFactory.createIntertypeMemberClassDeclaration(this.compilationUnit.compilationResult);
        if (this.nestedMethod[this.nestedType] == 0) {
            if (this.nestedType != 0) {
                typeDecl.bits |= 0x400;
            }
        } else {
            typeDecl.bits |= 0x100;
            this.markEnclosingMemberWithLocalType();
            this.blockReal();
        }
        this.display();
        long pos = this.identifierPositionStack[this.identifierPtr];
        typeDecl.sourceEnd = (int)pos;
        typeDecl.sourceStart = (int)(pos >>> 32);
        typeDecl.name = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        if (b) {
            this.pushOnGenericsIdentifiersLengthStack(this.identifierLengthStack[this.identifierLengthPtr]);
        } else {
            this.consumeClassOrInterfaceName();
        }
        TypeReference onType = this.getTypeReference(0);
        declarationFactory.setOnType(typeDecl, onType);
        typeDecl.declarationSourceStart = this.intStack[this.intPtr--];
        --this.intPtr;
        typeDecl.modifiersSourceStart = this.intStack[this.intPtr--];
        typeDecl.modifiers = this.intStack[this.intPtr--];
        if (typeDecl.modifiersSourceStart >= 0) {
            typeDecl.declarationSourceStart = typeDecl.modifiersSourceStart;
        }
        if ((typeDecl.bits & 0x400) == 0 && (typeDecl.bits & 0x100) == 0 && this.compilationUnit != null && !CharOperation.equals(typeDecl.name, this.compilationUnit.getMainTypeName())) {
            typeDecl.bits |= 0x1000;
        }
        if ((length = this.expressionLengthStack[this.expressionLengthPtr--]) != 0) {
            typeDecl.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, typeDecl.annotations, 0, length);
        }
        typeDecl.bodyStart = typeDecl.sourceEnd + 1;
        this.pushOnAstStack(typeDecl);
        this.listLength = 0;
        if (this.currentElement != null) {
            this.lastCheckPoint = typeDecl.bodyStart;
            this.currentElement = this.currentElement.add(typeDecl, 0);
            this.lastIgnoredToken = -1;
        }
        typeDecl.javadoc = this.javadoc;
        this.javadoc = null;
        this.display();
    }

    protected ASTNode popPointcutDesignator(String terminator) {
        ASTNode tokens = this.popPseudoTokens(terminator);
        return declarationFactory.createPointcutDesignator(this, tokens);
    }

    protected ASTNode popPseudoTokens(String terminator) {
        this.consumePseudoToken(terminator);
        this.consumePseudoTokens();
        int length = this.astLengthStack[this.astLengthPtr--];
        this.astPtr -= length;
        ASTNode[] tokens = new ASTNode[length];
        System.arraycopy(this.astStack, this.astPtr + 1, tokens, 0, length);
        this.listLength = 0;
        return declarationFactory.createPseudoTokensFrom(tokens, this.compilationUnit.compilationResult());
    }

    private void swapAstStack() {
        ASTNode next;
        ASTNode top = this.astStack[this.astPtr];
        this.astStack[this.astPtr] = next = this.astStack[this.astPtr - 1];
        this.astStack[this.astPtr - 1] = top;
    }

    private void consumeInterTypeFieldHeaderIllegallyAttemptingToUseATypePattern(String badToken) {
        this.consumeInterTypeFieldHeader(false);
        MethodDeclaration errorNode = (MethodDeclaration)this.astStack[this.astPtr];
        this.problemReporter().parseErrorDeleteToken(errorNode.sourceStart - 2, errorNode.sourceStart, 2, badToken.toCharArray(), badToken);
    }

    private void consumeInterTypeConstructorHeaderNameIllegallyUsingTypePattern(String badToken) {
        this.consumeInterTypeConstructorHeaderName(false, false);
        MethodDeclaration errorNode = (MethodDeclaration)this.astStack[this.astPtr];
        this.problemReporter().parseErrorDeleteToken(errorNode.sourceStart - 2, errorNode.sourceStart, 2, badToken.toCharArray(), badToken);
    }

    private void consumeInterTypeMethodHeaderNameIllegallyUsingTypePattern(String badToken) {
        this.consumeInterTypeMethodHeaderName(false, false);
        MethodDeclaration errorNode = (MethodDeclaration)this.astStack[this.astPtr];
        this.problemReporter().parseErrorDeleteToken(errorNode.sourceStart - 2, errorNode.sourceStart, 2, badToken.toCharArray(), badToken);
    }

    private void consumeAroundHeaderNameMissingReturnType() {
        this.problemReporter().parseErrorInsertToComplete(this.scanner.startPosition, this.scanner.currentPosition, "return type", "around advice declaration");
        this.restartRecovery = true;
    }

    private void consumeBadHeader() {
        this.problemReporter().parseErrorReplaceTokens(this.scanner.startPosition, this.scanner.currentPosition, "valid member declaration");
        this.restartRecovery = true;
    }

    @Override
    protected void consumeSimpleAssertStatement() {
        super.consumeSimpleAssertStatement();
    }

    private void convertTypeParametersToSingleTypeReferences() {
        int typeParameterIndex = 0;
        while (typeParameterIndex < this.genericsLengthStack[this.genericsLengthPtr]) {
            TypeParameter tp = (TypeParameter)this.genericsStack[this.genericsPtr - typeParameterIndex];
            SingleTypeReference str = new SingleTypeReference(tp.name, tp.declarationSourceStart);
            this.genericsStack[this.genericsPtr - typeParameterIndex] = str;
            ++typeParameterIndex;
        }
    }

    public Parser() {
    }

    public Parser(ProblemReporter problemReporter, boolean optimizeStringLiterals) {
        super(problemReporter, optimizeStringLiterals);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean shouldTryToRecover() {
        ASTNode aSTNode;
        int index = 0;
        while (index < this.astStack.length && (aSTNode = this.astStack[index++]) != null) {
            void node;
            if (declarationFactory.shouldTryToRecover((ASTNode)node)) continue;
            return false;
        }
        return true;
    }

    protected void pushOnAspectIntStack(int pos) {
        int stackLength = this.aspectIntStack.length;
        if (++this.aspectIntPtr >= stackLength) {
            this.aspectIntStack = new int[stackLength + 255];
            System.arraycopy(this.aspectIntStack, 0, this.aspectIntStack, 0, stackLength);
        }
        this.aspectIntStack[this.aspectIntPtr] = pos;
    }

    public static interface IDeclarationFactory {
        public MessageSend createProceed(MessageSend var1);

        public TypeDeclaration createAspect(CompilationResult var1);

        public void setPrivileged(TypeDeclaration var1, boolean var2);

        public void setPerClauseFrom(TypeDeclaration var1, ASTNode var2, Parser var3);

        public void setDominatesPatternFrom(TypeDeclaration var1, ASTNode var2, Parser var3);

        public ASTNode createPseudoTokensFrom(ASTNode[] var1, CompilationResult var2);

        public MethodDeclaration createMethodDeclaration(CompilationResult var1);

        public ConstructorDeclaration createConstructorDeclaration(CompilationResult var1);

        public MethodDeclaration createPointcutDeclaration(CompilationResult var1);

        public MethodDeclaration createAroundAdviceDeclaration(CompilationResult var1);

        public MethodDeclaration createAfterAdviceDeclaration(CompilationResult var1);

        public MethodDeclaration createBeforeAdviceDeclaration(CompilationResult var1);

        public ASTNode createPointcutDesignator(Parser var1, ASTNode var2);

        public void setPointcutDesignatorOnAdvice(MethodDeclaration var1, ASTNode var2);

        public void setPointcutDesignatorOnPointcut(MethodDeclaration var1, ASTNode var2);

        public void setExtraArgument(MethodDeclaration var1, Argument var2);

        public boolean isAfterAdvice(MethodDeclaration var1);

        public void setAfterThrowingAdviceKind(MethodDeclaration var1);

        public void setAfterReturningAdviceKind(MethodDeclaration var1);

        public MethodDeclaration createDeclareDeclaration(CompilationResult var1, ASTNode var2, Parser var3);

        public MethodDeclaration createDeclareAnnotationDeclaration(CompilationResult var1, ASTNode var2, Annotation var3, Parser var4, char var5);

        public MethodDeclaration createInterTypeFieldDeclaration(CompilationResult var1, TypeReference var2);

        public MethodDeclaration createInterTypeMethodDeclaration(CompilationResult var1);

        public MethodDeclaration createInterTypeConstructorDeclaration(CompilationResult var1);

        public void setSelector(MethodDeclaration var1, char[] var2);

        public void setDeclaredModifiers(MethodDeclaration var1, int var2);

        public void setInitialization(MethodDeclaration var1, Expression var2);

        public void setOnType(MethodDeclaration var1, TypeReference var2);

        public ASTNode createPseudoToken(Parser var1, String var2, boolean var3);

        public ASTNode createIfPseudoToken(Parser var1, Expression var2);

        public void setLiteralKind(ASTNode var1, String var2);

        public boolean shouldTryToRecover(ASTNode var1);

        public TypeDeclaration createIntertypeMemberClassDeclaration(CompilationResult var1);

        public void setOnType(TypeDeclaration var1, TypeReference var2);
    }
}

