/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.builder;

import java.io.IOException;
import java.util.Enumeration;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ExternalAnnotationDecorator;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IModule;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.aspectj.org.eclipse.jdt.internal.core.builder.ClasspathJar;
import org.eclipse.core.runtime.IPath;

public class ClasspathJMod
extends ClasspathJar {
    public static char[] CLASSES = "classes".toCharArray();
    public static char[] CLASSES_FOLDER = "classes/".toCharArray();
    private static int MODULE_DESCRIPTOR_NAME_LENGTH = "module-info.class".length();

    ClasspathJMod(String zipFilename, long lastModified, AccessRuleSet accessRuleSet, IPath externalAnnotationPath) {
        super(zipFilename, lastModified, accessRuleSet, externalAnnotationPath, true);
    }

    @Override
    IModule initializeModule() {
        IBinaryModule mod = null;
        ZipFile file = null;
        try {
            try {
                file = new ZipFile(this.zipFilename);
                String fileName = String.valueOf(new String(CLASSES_FOLDER)) + "module-info.class";
                ClassFileReader classfile = ClassFileReader.read(file, fileName);
                if (classfile != null) {
                    mod = classfile.getModuleDeclaration();
                }
            }
            catch (IOException | ClassFormatException exception) {
                try {
                    if (file != null) {
                        file.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException iOException) {}
        }
        return mod;
    }

    @Override
    public NameEnvironmentAnswer findClass(String binaryFileName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName, boolean asBinaryOnly, Predicate<String> moduleNameFilter) {
        block12: {
            if (!this.isPackage(qualifiedPackageName, moduleName)) {
                return null;
            }
            if (moduleNameFilter != null && this.module != null && !moduleNameFilter.test(String.valueOf(this.module.name()))) {
                return null;
            }
            try {
                char[] modName;
                qualifiedBinaryFileName = new String(CharOperation.append(CLASSES_FOLDER, qualifiedBinaryFileName.toCharArray()));
                IBinaryType reader = ClassFileReader.read(this.zipFile, qualifiedBinaryFileName);
                if (reader == null) break block12;
                char[] cArray = modName = this.module == null ? null : this.module.name();
                if (reader instanceof ClassFileReader) {
                    ClassFileReader classReader = reader;
                    if (classReader.moduleName == null) {
                        classReader.moduleName = modName;
                    } else {
                        modName = classReader.moduleName;
                    }
                }
                String fileNameWithoutExtension = qualifiedBinaryFileName.substring(0, qualifiedBinaryFileName.length() - SuffixConstants.SUFFIX_CLASS.length);
                if (this.externalAnnotationPath != null) {
                    try {
                        if (this.annotationZipFile == null) {
                            this.annotationZipFile = ExternalAnnotationDecorator.getAnnotationZipFile(this.externalAnnotationPath, null);
                        }
                        reader = ExternalAnnotationDecorator.create(reader, this.externalAnnotationPath, fileNameWithoutExtension, this.annotationZipFile);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this.accessRuleSet == null) {
                    return new NameEnvironmentAnswer(reader, null, modName);
                }
                return new NameEnvironmentAnswer(reader, this.accessRuleSet.getViolatedRestriction(fileNameWithoutExtension.toCharArray()), modName);
            }
            catch (IOException | ClassFormatException exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    protected String readJarContent(SimpleSet packageSet) {
        String modInfo = null;
        Enumeration<? extends ZipEntry> e = this.zipFile.entries();
        while (e.hasMoreElements()) {
            char[] folder;
            ZipEntry entry = e.nextElement();
            char[] entryName = entry.getName().toCharArray();
            int index = CharOperation.indexOf('/', entryName);
            if (index == -1 || !CharOperation.equals(CLASSES, folder = CharOperation.subarray(entryName, 0, index))) continue;
            char[] fileName = CharOperation.subarray(entryName, index + 1, entryName.length);
            if (modInfo == null && fileName.length == MODULE_DESCRIPTOR_NAME_LENGTH && CharOperation.equals(fileName, "module-info.class".toCharArray())) {
                modInfo = new String(entryName);
            }
            ClasspathJMod.addToPackageSet(packageSet, new String(fileName), false);
        }
        return modInfo;
    }
}

