/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.discovery.core;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class CancellableInputStream
extends FilterInputStream {
    private IProgressMonitor monitor;

    protected CancellableInputStream(InputStream in, IProgressMonitor monitor) {
        super(in);
        this.monitor = monitor;
    }

    public int read() throws IOException {
        this.exceptionIfCancelled();
        return super.read();
    }

    private void exceptionIfCancelled() {
        if (this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public int read(byte[] b) throws IOException {
        this.exceptionIfCancelled();
        return super.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.exceptionIfCancelled();
        return super.read(b, off, len);
    }
}

