/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCatalog;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceNodeCatalogItem;
import org.eclipse.epp.internal.mpc.ui.wizards.ImportFavoritesPage;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceCatalogConfiguration;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplacePage;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceWizard;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.mpc.ui.IMarketplaceClientConfiguration;
import org.eclipse.epp.mpc.ui.IMarketplaceClientService;
import org.eclipse.epp.mpc.ui.MarketplaceClient;
import org.eclipse.epp.mpc.ui.Operation;
import org.eclipse.equinox.internal.p2.discovery.Catalog;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogConfiguration;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;

public class ImportFavoritesWizard
extends DiscoveryWizard {
    private final ImportFavoritesPage importFavoritesPage;
    private String initialFavoritesUrl;
    private final MarketplaceWizard parent;

    public ImportFavoritesWizard(MarketplaceCatalog catalog, MarketplaceCatalogConfiguration configuration, MarketplaceWizard parent) {
        super((Catalog)catalog, (CatalogConfiguration)configuration);
        this.setWindowTitle(Messages.ImportFavoritesWizard_title);
        this.importFavoritesPage = new ImportFavoritesPage(catalog);
        this.parent = parent;
    }

    public MarketplaceCatalogConfiguration getConfiguration() {
        return (MarketplaceCatalogConfiguration)super.getConfiguration();
    }

    public MarketplaceCatalog getCatalog() {
        return (MarketplaceCatalog)super.getCatalog();
    }

    public void addPages() {
        this.addPage((IWizardPage)this.importFavoritesPage);
    }

    public boolean performFinish() {
        boolean result;
        this.importFavoritesPage.performImport();
        boolean bl = result = this.importFavoritesPage.getErrorMessage() == null;
        if (result) {
            this.showFavoritesInMarketplace(this.importFavoritesPage.isInstallSelected());
        }
        return result;
    }

    private void showFavoritesInMarketplace(boolean install) {
        List<MarketplaceNodeCatalogItem> selection = this.importFavoritesPage.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!install) {
            selection = Collections.emptyList();
        }
        if (this.parent == null) {
            this.openFavoritesInMarketplace(selection);
        } else {
            this.selectForInstallation(selection);
        }
    }

    private void selectForInstallation(List<MarketplaceNodeCatalogItem> selection) {
        MarketplacePage catalogPage = this.parent.getCatalogPage();
        if (catalogPage.getActiveTab() != MarketplaceViewer.ContentType.FAVORITES) {
            catalogPage.setActiveTab(MarketplaceViewer.ContentType.FAVORITES);
        }
        for (MarketplaceNodeCatalogItem item : selection) {
            this.parent.getSelectionModel().select((CatalogItem)item, Operation.INSTALL);
        }
        this.parent.getContainer().showPage((IWizardPage)catalogPage);
    }

    private void openFavoritesInMarketplace(List<MarketplaceNodeCatalogItem> selection) {
        IMarketplaceClientService clientService = MarketplaceClient.getMarketplaceClientService();
        IMarketplaceClientConfiguration config = clientService.newConfiguration();
        MarketplaceCatalogConfiguration catalogConfiguration = this.getConfiguration();
        config.setCatalogDescriptors(catalogConfiguration.getCatalogDescriptors());
        config.setCatalogDescriptor(catalogConfiguration.getCatalogDescriptor());
        HashMap<String, Operation> initialOperations = new HashMap<String, Operation>();
        for (MarketplaceNodeCatalogItem item : selection) {
            initialOperations.put(item.getData().getId(), Operation.INSTALL);
        }
        config.setInitialOperations(initialOperations);
        Display.getCurrent().asyncExec(() -> clientService.openFavorites(config));
    }

    public ImportFavoritesPage getImportFavoritesPage() {
        return this.importFavoritesPage;
    }

    public void setInitialFavoritesUrl(String initialFavoritesUrl) {
        this.initialFavoritesUrl = initialFavoritesUrl;
    }

    public String getInitialFavoritesUrl() {
        return this.initialFavoritesUrl;
    }
}

