/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.addon.stategraph.layout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.elk.core.service.IDiagramLayoutConnector;
import org.eclipse.elk.core.service.LayoutMapping;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.elk.graph.properties.Property;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.gemoc.addon.stategraph.logic.DirectedGraph;
import org.eclipse.gemoc.addon.stategraph.logic.StateGraph;
import org.eclipse.gemoc.addon.stategraph.logic.StateVertex;
import org.eclipse.gemoc.addon.stategraph.views.StateGraphViewPart;
import org.eclipse.gemoc.addon.stategraph.views.VertexView;
import org.eclipse.ui.IWorkbenchPart;

public class StateGraphLayoutConnector
implements IDiagramLayoutConnector {
    private final Property<Map<StateVertex, VertexView>> VERTEX2SHAPE_MAP = new Property("vertex.to.shape.map", new HashMap());

    public LayoutMapping buildLayoutGraph(IWorkbenchPart workbenchPart, Object diagramPart) {
        StateGraphViewPart layoutRootPart = null;
        if (!(workbenchPart instanceof StateGraphViewPart)) {
            return null;
        }
        layoutRootPart = (StateGraphViewPart)workbenchPart;
        StateGraph stateGraph = layoutRootPart.getStateGraph();
        LayoutMapping mapping = new LayoutMapping(workbenchPart);
        mapping.setParentElement((Object)layoutRootPart);
        ElkNode topNode = ElkGraphUtil.createNode(null);
        mapping.getGraphMap().put((Object)topNode, (Object)layoutRootPart);
        mapping.setLayoutGraph(topNode);
        Set<StateVertex> movedVertice = layoutRootPart.getMovedVertice();
        ArrayList vertice = new ArrayList(stateGraph.getVertice());
        vertice.removeAll(movedVertice);
        for (StateVertex vertex : vertice) {
            ElkNode node = this.createNode(mapping, vertex, topNode);
            mapping.getGraphMap().put((Object)node, (Object)vertex);
        }
        List edges = stateGraph.getEdges().stream().filter(e -> !movedVertice.contains(e.getSource()) && !movedVertice.contains(e.getTarget())).collect(Collectors.toList());
        for (DirectedGraph.Edge edge : edges) {
            ElkEdge kEdge = this.createEdge(mapping, edge);
            mapping.getGraphMap().put((Object)kEdge, (Object)edge);
        }
        return mapping;
    }

    private ElkNode createNode(LayoutMapping mapping, StateVertex nodeStateVertex, ElkNode rootNode) {
        ElkNode childLayoutNode = ElkGraphUtil.createNode(null);
        rootNode.getChildren().add((Object)childLayoutNode);
        mapping.getGraphMap().put((Object)childLayoutNode, (Object)nodeStateVertex);
        return childLayoutNode;
    }

    private ElkEdge createEdge(LayoutMapping mapping, DirectedGraph.Edge<StateVertex> edge) {
        ElkEdge layoutEdge = ElkGraphUtil.createEdge(null);
        layoutEdge.getSources().add((Object)((ElkNode)mapping.getGraphMap().inverse().get((Object)edge.getSource())));
        layoutEdge.getTargets().add((Object)((ElkNode)mapping.getGraphMap().inverse().get((Object)edge.getTarget())));
        mapping.getGraphMap().put((Object)layoutEdge, edge);
        return layoutEdge;
    }

    public void applyLayout(LayoutMapping layoutMapping, IPropertyHolder propertyHolder) {
        for (Map.Entry entry : layoutMapping.getGraphMap().entrySet()) {
        }
    }
}

