/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.addon.stategraph.views;

import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.QuadCurve;
import org.eclipse.gemoc.addon.stategraph.views.EdgeView;

public class CurvedEdgeView
extends EdgeView {
    public CurvedEdgeView(final DoubleProperty sX, final DoubleProperty sY, final DoubleProperty eX, final DoubleProperty eY) {
        super(sX, sY, eX, eY);
        final DoubleBinding cX = new DoubleBinding(){
            {
                super.bind(new Observable[]{doubleProperty, doubleProperty2, CurvedEdgeView.this.a});
            }

            protected double computeValue() {
                double tX = (sX.get() + eX.get()) / 2.0;
                return tX + 20.0 * Math.cos(CurvedEdgeView.this.a.get() - 1.5707963267948966);
            }
        };
        final DoubleBinding cY = new DoubleBinding(){
            {
                super.bind(new Observable[]{doubleProperty, doubleProperty2, CurvedEdgeView.this.a});
            }

            protected double computeValue() {
                double tY = (sY.get() + eY.get()) / 2.0;
                return tY + 20.0 * Math.sin(CurvedEdgeView.this.a.get() - 1.5707963267948966);
            }
        };
        DoubleBinding aX = new DoubleBinding(){
            {
                super.bind(new Observable[]{doubleProperty, doubleProperty2, doubleBinding});
            }

            protected double computeValue() {
                return 0.25 * sX.get() + 0.5 * cX.get() + 0.25 * eX.get();
            }
        };
        DoubleBinding aY = new DoubleBinding(){
            {
                super.bind(new Observable[]{doubleProperty, doubleProperty2, doubleBinding});
            }

            protected double computeValue() {
                return 0.25 * sY.get() + 0.5 * cY.get() + 0.25 * eY.get();
            }
        };
        QuadCurve quadCurve = new QuadCurve();
        quadCurve.setStrokeWidth(1.5);
        quadCurve.setStroke((Paint)Color.BLUE);
        quadCurve.setFill((Paint)Color.TRANSPARENT);
        quadCurve.startXProperty().bind((ObservableValue)sX);
        quadCurve.startYProperty().bind((ObservableValue)sY);
        quadCurve.endXProperty().bind((ObservableValue)eX);
        quadCurve.endYProperty().bind((ObservableValue)eY);
        quadCurve.controlXProperty().bind((ObservableValue)cX);
        quadCurve.controlYProperty().bind((ObservableValue)cY);
        Polygon arrow = new Polygon();
        arrow.setFill((Paint)Color.BLUE);
        ChangeListener listener = (_0, _1, _2) -> {
            double angle = this.a.get() + Math.PI;
            double x = aX.get();
            double y = aY.get();
            double x0 = x + 5.0 * Math.cos(angle);
            double x1 = x + 5.0 * Math.cos(angle + 2.0943951023931953);
            double x2 = x + 5.0 * Math.cos(angle - 2.0943951023931953);
            double y0 = y + 5.0 * Math.sin(angle);
            double y1 = y + 5.0 * Math.sin(angle + 2.0943951023931953);
            double y2 = y + 5.0 * Math.sin(angle - 2.0943951023931953);
            arrow.getPoints().clear();
            arrow.getPoints().addAll((Object[])new Double[]{x0, y0, x1, y1, x2, y2});
        };
        aX.addListener(listener);
        aY.addListener(listener);
        this.a.addListener(listener);
        this.getChildren().addAll((Object[])new Node[]{quadCurve, arrow});
    }
}

