/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.moccml_mapping.qvto.helper;

import com.google.inject.Injector;
import fr.inria.aoste.timesquare.ccslkernel.library.xtext.CCSLLibraryStandaloneSetup;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;

public class EclQVToHelper {
    private int UID = 0;
    private HashMap<EObject, String> eoToID = new HashMap();

    public String getModelPath(EObject model) {
        if (model == null) {
            return "null";
        }
        String res = "";
        res = "platform:" + model.eResource().getURI().devicePath();
        return res;
    }

    public String getModelAlias(EObject model) {
        String res = "";
        res = model.eClass().getName();
        return res;
    }

    public Set<EObject> getLibObjects(String libPath) {
        HashSet<EObject> res = new HashSet<EObject>();
        CCSLLibraryStandaloneSetup ess = new CCSLLibraryStandaloneSetup();
        Injector injector = ess.createInjector();
        XtextResourceSet aSet = (XtextResourceSet)injector.getInstance(XtextResourceSet.class);
        aSet.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
        EcoreUtil.resolveAll((ResourceSet)aSet);
        CCSLLibraryStandaloneSetup.doSetup();
        URI uri = null;
        if (libPath.startsWith("platform:/plugin")) {
            uri = URI.createPlatformPluginURI((String)libPath.replace("platform:/plugin", ""), (boolean)false);
        } else if (libPath.startsWith("platform:/resource")) {
            uri = URI.createPlatformResourceURI((String)libPath.replace("platform:/resource", ""), (boolean)false);
        } else {
            throw new IllegalArgumentException("the path of the library must be platform based (platform:/resource or platform:/plugin)");
        }
        Resource libResource = aSet.getResource(uri, true);
        HashMap saveOptions = new HashMap();
        SaveOptions.Builder aBuilder = SaveOptions.newBuilder();
        SaveOptions anOption = aBuilder.getOptions();
        anOption.addTo(saveOptions);
        try {
            libResource.load(saveOptions);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        TreeIterator iterator = libResource.getAllContents();
        while (iterator.hasNext()) {
            EObject eo = (EObject)iterator.next();
            res.add(eo);
        }
        return res;
    }

    public Set<EObject> getVeryAllElementsFromResourceSetOf(EObject anEobject, EClass type) {
        HashSet<EObject> res = new HashSet<EObject>();
        try {
            EcoreUtil.resolveAll((EObject)anEobject);
            anEobject.eResource().load(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (Resource r : anEobject.eResource().getResourceSet().getResources()) {
            TreeIterator iterator = r.getAllContents();
            while (iterator.hasNext()) {
                EObject eo = (EObject)iterator.next();
                if (eo.eClass().equals(type)) {
                    res.add(eo);
                    continue;
                }
                boolean isToAdd = false;
                for (EClass ec : eo.eClass().getEAllSuperTypes()) {
                    if (!ec.equals(type)) continue;
                    isToAdd = true;
                }
                if (!isToAdd) continue;
                res.add(eo);
            }
        }
        return res;
    }

    public String getNameOrUID(EObject eo) {
        EAttribute eID;
        String res = "";
        res = this.eoToID.get(eo);
        if (res != null && res.length() > 0) {
            return res;
        }
        if (eo == null) {
            System.err.println("eo Object null");
            return "eoIsNull_" + this.UID++;
        }
        for (EAttribute ea : eo.eClass().getEAllAttributes()) {
            if (ea.getName().compareTo("name") != 0) continue;
            res = (String)eo.eGet((EStructuralFeature)ea);
            if (res != null) break;
            res = "";
            break;
        }
        if (res == null) {
            res = "";
        }
        if (res.length() == 0 && (eID = eo.eClass().getEIDAttribute()) != null) {
            res = String.valueOf(res) + "id_" + (String)eo.eGet((EStructuralFeature)eID);
        }
        if (res.length() == 0) {
            res = eo.getClass().getSimpleName();
        }
        res = String.valueOf(res) + "_" + this.UID++;
        res = res.replace(' ', '_');
        this.eoToID.put(eo, res);
        return res;
    }
}

