/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.dom.util;

import org.eclipse.jdt.core.dom.AST;

public class DOMASTUtil {
    private static boolean isNodeTypeSupportedinAST(AST ast, int nodeType) {
        return DOMASTUtil.isNodeTypeSupportedinAST(ast.apiLevel(), ast.isPreviewEnabledSet(), nodeType);
    }

    private static boolean isNodeTypeSupportedinAST(int apiLevel, boolean previewEnabled, int nodeType) {
        switch (nodeType) {
            case 100: 
            case 101: {
                return apiLevel >= 14;
            }
            case 102: {
                return apiLevel >= 15;
            }
            case 103: 
            case 104: {
                return apiLevel >= 16;
            }
        }
        return false;
    }

    public static boolean isFeatureSupportedinAST(AST ast, int featureName) {
        switch (featureName) {
            case 512: {
                return DOMASTUtil.isPreviewEnabled(ast.apiLevel(), ast.isPreviewEnabledSet());
            }
        }
        return false;
    }

    public static boolean isFeatureSupportedinAST(int apiLevel, boolean previewEnabled, int featureName) {
        switch (featureName) {
            case 512: {
                return DOMASTUtil.isPreviewEnabled(apiLevel, previewEnabled);
            }
        }
        return false;
    }

    private static boolean isPreviewEnabled(int apiLevel, boolean previewEnabled) {
        return apiLevel == 16 && previewEnabled;
    }

    public static boolean isSwitchExpressionSupported(AST ast) {
        return DOMASTUtil.isNodeTypeSupportedinAST(ast, 100);
    }

    public static boolean isYieldStatementSupported(AST ast) {
        return DOMASTUtil.isNodeTypeSupportedinAST(ast, 101);
    }

    public static boolean isTextBlockSupported(AST ast) {
        return DOMASTUtil.isNodeTypeSupportedinAST(ast, 102);
    }

    public static boolean isRecordDeclarationSupported(AST ast) {
        return DOMASTUtil.isNodeTypeSupportedinAST(ast, 103);
    }

    public static boolean isRecordDeclarationSupported(int apiLevel) {
        return DOMASTUtil.isNodeTypeSupportedinAST(apiLevel, true, 103);
    }

    public static boolean isPatternInstanceofExpressionSupported(AST ast) {
        return DOMASTUtil.isNodeTypeSupportedinAST(ast, 104);
    }

    public static boolean isSealedTypeSupported(AST ast) {
        return DOMASTUtil.isNodeTypeSupportedinAST(ast, 62);
    }

    public static void checkASTLevel(int level) {
        if (level >= 8 && level <= 16) {
            return;
        }
        switch (level) {
            case 2: 
            case 3: 
            case 4: {
                return;
            }
        }
        throw new IllegalArgumentException(Integer.toString(level));
    }
}

