/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.model.ApiMember;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMemberDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMethod;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.util.Util;

public class ApiMethod
extends ApiMember
implements IApiMethod {
    public static final int Polymorphic = 0x200000;
    private static final String INIT = "<init>";
    private static final String CLINIT = "<clinit>";
    private String[] fExceptions;
    private String fDefaultValue;
    private IMethodDescriptor fHandle;

    protected ApiMethod(IApiType enclosing, String name, String signature, String genericSig, int flags, String[] exceptions) {
        super(enclosing, name, signature, genericSig, 6, flags);
        this.fExceptions = exceptions;
    }

    @Override
    public boolean isConstructor() {
        return this.getName().equals(INIT);
    }

    @Override
    public boolean isDefaultMethod() {
        return ((IApiType)this.getParent()).isInterface() && (this.getModifiers() & 0x400) == 0 && (this.getModifiers() & 8) == 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IApiMethod) {
            return super.equals(obj) && ((IApiMethod)obj).getSignature().equals(this.getSignature());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.getSignature().hashCode();
    }

    @Override
    public String[] getExceptionNames() {
        return this.fExceptions;
    }

    @Override
    public boolean isClassInitializer() {
        return this.getName().equals(CLINIT);
    }

    @Override
    public String getDefaultValue() {
        return this.fDefaultValue;
    }

    public void setDefaultValue(String value) {
        this.fDefaultValue = value;
    }

    @Override
    public boolean isSynthetic() {
        return (this.getModifiers() & 0x1000) != 0;
    }

    @Override
    public boolean isPolymorphic() {
        return (this.getModifiers() & 0x200000) != 0;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Method : access(").append(this.getModifiers()).append(") ").append(this.getSignature()).append(' ').append(this.getName());
        if (this.getExceptionNames() != null) {
            buffer.append(" throws ");
            int i = 0;
            while (i < this.getExceptionNames().length) {
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append(this.getExceptionNames()[i]);
                ++i;
            }
        }
        buffer.append(';').append(Util.LINE_DELIMITER);
        if (this.getGenericSignature() != null) {
            buffer.append(" Generic signature : ").append(this.getGenericSignature()).append(Util.LINE_DELIMITER);
        }
        return String.valueOf(buffer);
    }

    @Override
    public IMemberDescriptor getHandle() {
        if (this.fHandle == null) {
            try {
                IApiType type = this.getEnclosingType();
                this.fHandle = ((IReferenceTypeDescriptor)type.getHandle()).getMethod(this.getName(), this.getSignature());
            }
            catch (CoreException coreException) {}
        }
        return this.fHandle;
    }
}

