/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.helper.task;

import java.text.MessageFormat;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.Messages;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class DeleteDRepresentationTask
extends AbstractCommandTask {
    protected DRepresentationDescriptor representationDescriptor;
    protected boolean deleteReferences;

    public DeleteDRepresentationTask(DRepresentationDescriptor representationDescriptor) {
        this.representationDescriptor = representationDescriptor;
    }

    @Override
    public void execute() {
        Resource resource;
        if (this.representationDescriptor != null && (resource = this.representationDescriptor.eResource()) != null) {
            DRepresentation representation = this.representationDescriptor.getRepresentation();
            ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)representation);
            if (this.deleteReferences) {
                Session session = representation instanceof DSemanticDecorator ? SessionManager.INSTANCE.getSession(((DSemanticDecorator)((Object)representation)).getTarget()) : SessionManager.INSTANCE.getSession(this.representationDescriptor);
                accessor.eDelete((EObject)representation, session != null ? session.getSemanticCrossReferencer() : null);
            } else {
                accessor.eRemove((EObject)representation);
            }
        }
    }

    public void setDeleteIncomingReferences(boolean value) {
        this.deleteReferences = value;
    }

    @Override
    public String getLabel() {
        if (this.representationDescriptor != null) {
            return MessageFormat.format(Messages.DeleteDRepresentationTask_label, this.representationDescriptor.getName());
        }
        return Messages.DeleteRepresentationCommand_label;
    }
}

