/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.codeexecution.model.CodeExecution;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LiveStateKind implements Enumerator
{
    IS_ALIVE(0, "isAlive", "isAlive"),
    IS_DEAD(1, "isDead", "isDead");

    public static final int IS_ALIVE_VALUE = 0;
    public static final int IS_DEAD_VALUE = 1;
    private static final LiveStateKind[] VALUES_ARRAY;
    public static final List<LiveStateKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LiveStateKind[]{IS_ALIVE, IS_DEAD};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LiveStateKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LiveStateKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LiveStateKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LiveStateKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LiveStateKind get(int value) {
        switch (value) {
            case 0: {
                return IS_ALIVE;
            }
            case 1: {
                return IS_DEAD;
            }
        }
        return null;
    }

    private LiveStateKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

