/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.manager.launcher.extensionpoint;

import fr.inria.aoste.timesquare.backend.manager.controller.Controller;
import fr.inria.aoste.timesquare.backend.manager.launcher.extensionpoint.OutputOption;
import fr.inria.aoste.timesquare.backend.manager.visible.ClockEntity;
import fr.inria.aoste.timesquare.instantrelation.CCSLRelationModel.OccurrenceRelation;
import fr.inria.aoste.timesquare.launcher.core.console.ConsoleSimulation;
import fr.inria.aoste.timesquare.launcher.core.inter.ISolverForBackend;
import fr.inria.aoste.timesquare.launcher.debug.model.proxy.InitOutputData;
import fr.inria.aoste.timesquare.launcher.extensionpoint.IOutputOption;
import fr.inria.aoste.timesquare.launcher.extensionpoint.OutputCommon;
import fr.inria.aoste.trace.AssertionState;
import fr.inria.aoste.trace.EventOccurrence;
import fr.inria.aoste.trace.LogicalStep;
import fr.inria.aoste.trace.ModelElementReference;
import fr.inria.aoste.trace.Reference;
import fr.inria.aoste.trace.TracePackage;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class OutputTrace
extends OutputCommon {
    private Controller _controller = null;
    private OutputOption options = null;
    String key = "behavior";

    public OutputTrace(String key, String name) {
        super(name);
        this.key = key;
    }

    public void aFinalStep(int step) {
        if (this._controller != null) {
            this._controller.end();
        }
    }

    protected void aNewStep(LogicalStep step, boolean timed) {
        if (step == null || this._controller == null) {
            return;
        }
        this._controller.aNewStep(step.getStepNumber(), timed, step);
        this.analyzeNewStep(step);
        this._controller.aPostNewStep(step.getStepNumber(), timed, step);
    }

    public void aStep(LogicalStep step, boolean timed) {
        if (step == null || this._controller == null) {
            return;
        }
        this._controller.aStep(step.getStepNumber(), timed, step);
        this.analyzeStep(step);
    }

    public OutputOption getOption() {
        return this.options;
    }

    public String getkey() {
        return this.key;
    }

    public void initAndOutputFile(InitOutputData data, ISolverForBackend solver) throws Throwable {
        ConsoleSimulation cs = this.options.getCs();
        this._controller.beforeExecution(data, cs, solver);
    }

    public void killTimer() {
    }

    public void setOption(IOutputOption o) throws Throwable {
        if (o == null || o.getIFile() == null || o.getListofClock() == null) {
            throw new Error("argument of setOption( IOutputOption o ) are null ");
        }
        this.options = (OutputOption)o;
        this._controller = this.options.getController();
    }

    public int terminate() {
        return 0;
    }

    private void analyzeNewStep(LogicalStep step) {
        if (step == null) {
            return;
        }
        EList list = step.getEventOccurrences();
        for (EventOccurrence cs : list) {
            Reference r = cs.getReferedElement();
            if (!(r instanceof ModelElementReference)) continue;
            ClockEntity clockEntity = new ClockEntity((ModelElementReference)r);
            this._controller.executeNewBehaviors(clockEntity, cs);
        }
        if (step.eIsSet((EStructuralFeature)TracePackage.eINSTANCE.getLogicalStep_AssertionStates())) {
            EList list2 = step.getAssertionStates();
            for (AssertionState cs : list2) {
                Reference r = cs.getReferedElement();
                if (!(r instanceof ModelElementReference)) continue;
                ClockEntity assertEntity = new ClockEntity((ModelElementReference)r);
                this._controller.executeNewBehaviors(assertEntity, cs);
            }
        }
    }

    private void analyzeStep(LogicalStep step) {
        if (step == null) {
            return;
        }
        EList list = step.getEventOccurrences();
        for (EventOccurrence cs : list) {
            Reference r = cs.getReferedElement();
            if (!(r instanceof ModelElementReference)) continue;
            ClockEntity clockEntity = new ClockEntity((ModelElementReference)r);
            this._controller.executeBehaviors(clockEntity, cs);
        }
    }

    protected void aNewRelation(List<EObject> lrelation) {
        if (this._controller != null && lrelation != null) {
            for (EObject relation : lrelation) {
                if (!(relation instanceof OccurrenceRelation)) continue;
                this._controller.executeBehaviorsRelation((OccurrenceRelation)relation);
            }
        }
    }
}

