/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.manager.visible.node;

import fr.inria.aoste.timesquare.backend.manager.visible.ClockEntity;
import fr.inria.aoste.timesquare.backend.manager.visible.RelationEntity;
import fr.inria.aoste.timesquare.trace.util.adapter.AdapterRegistry;
import fr.inria.aoste.trace.ModelElementReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class Node<T> {
    List<Node<T>> lnode = new ArrayList<Node<T>>();
    public boolean skip = false;
    String name;
    T value = null;
    String tooptips = "";

    public static <T> List<T> sortList(List<T> lst, Comparator<T> comp) {
        ArrayList<T> sort = new ArrayList<T>(lst);
        Collections.sort(sort, comp);
        return sort;
    }

    public static List<Node<ClockEntity>> buildListNodesClockEntity(List<ClockEntity> elements) {
        return Node.buildListNodesClockEntity(elements, 0);
    }

    public static List<Node<RelationEntity>> buildListNodesRelationEntity(List<RelationEntity> elements) {
        return Node.buildListNodesRelationEntity(elements, 0);
    }

    protected static List<Node<RelationEntity>> buildListNodesRelationEntity(List<RelationEntity> elements, int n) {
        ArrayList<Node<RelationEntity>> lst = new ArrayList<Node<RelationEntity>>();
        ArrayList<RelationEntity> tmp = new ArrayList<RelationEntity>();
        int i = 0;
        while (i < elements.size()) {
            RelationEntity re = elements.get(i);
            ModelElementReference mer = (ModelElementReference)re.getRelation().getCcslConstraint();
            if (mer != null && mer.getElementRef().size() > n) {
                RelationEntity re2;
                ModelElementReference mer2;
                EObject eo = (EObject)mer.getElementRef().get(n);
                EObject eo1 = null;
                if (i + 1 != elements.size() && (mer2 = (ModelElementReference)(re2 = elements.get(i + 1)).getRelation().getCcslConstraint()).getElementRef().size() > n) {
                    eo1 = (EObject)mer2.getElementRef().get(n);
                }
                if (eo1 != eo || eo1 == null) {
                    tmp.add(re);
                    List<Node<RelationEntity>> _lst = Node.buildListNodesRelationEntity(tmp, n + 1);
                    Node<Object> node = new Node<Object>(AdapterRegistry.getAdapter((EObject)eo).getReferenceName(eo), null);
                    boolean b = true;
                    for (Node node2 : lst) {
                        if (node2.getValue() == null) continue;
                        b = false;
                    }
                    node.skip = b;
                    node.getLnode().addAll(_lst);
                    lst.add(node);
                    tmp.clear();
                } else {
                    tmp.add(re);
                }
            } else {
                Node<RelationEntity> node = new Node<RelationEntity>(re.getRelation().getSubInfo(), re);
                lst.add(node);
            }
            ++i;
        }
        return lst;
    }

    protected static List<Node<ClockEntity>> buildListNodesClockEntity(List<ClockEntity> elements, int n) {
        ArrayList<Node<ClockEntity>> lst = new ArrayList<Node<ClockEntity>>();
        ArrayList<ClockEntity> tmp = new ArrayList<ClockEntity>();
        ClockEntity link = null;
        int i = 0;
        while (i < elements.size()) {
            ClockEntity re = elements.get(i);
            ModelElementReference mer = re.getModelElementReference();
            if (mer != null && mer.getElementRef().size() > n) {
                ClockEntity re2;
                ModelElementReference mer2;
                EObject eo = (EObject)mer.getElementRef().get(n);
                EObject eo1 = null;
                if (i + 1 != elements.size() && (mer2 = (re2 = elements.get(i + 1)).getModelElementReference()).getElementRef().size() > n) {
                    eo1 = (EObject)mer2.getElementRef().get(n);
                }
                if (mer.getElementRef().size() == n + 1) {
                    link = re;
                }
                if (eo1 != eo || eo1 == null) {
                    tmp.add(re);
                    List<Node<ClockEntity>> _lst = Node.buildListNodesClockEntity(tmp, n + 1);
                    String s = AdapterRegistry.getAdapter((EObject)eo).getReferenceName(eo);
                    Node<ClockEntity> node = null;
                    node = _lst.size() == 0 ? new Node<ClockEntity>(s, re) : new Node<ClockEntity>(s, link);
                    if (n != 0) {
                        node.skip = true;
                    }
                    node.getLnode().addAll(_lst);
                    lst.add(node);
                    tmp.clear();
                    link = null;
                } else {
                    tmp.add(re);
                }
            }
            ++i;
        }
        return lst;
    }

    public Node() {
    }

    public Node(String name, T value) {
        this.name = name;
        this.value = value;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public String getTooptips() {
        return this.tooptips;
    }

    public List<Node<T>> getLnode() {
        return this.lnode;
    }

    public String getName() {
        return this.name;
    }

    public T getValue() {
        return this.value;
    }

    public boolean haveValue() {
        return this.value != null;
    }

    public void optimise() {
        if (this.lnode != null) {
            Node.optimise(this.lnode);
            if (this.lnode.size() == 1) {
                Node<T> nd = this.lnode.get(0);
                if (nd.skip && nd.value == null && nd.name != null) {
                    this.lnode.remove(nd);
                    this.lnode.addAll(nd.lnode);
                    for (Node<T> n : nd.lnode) {
                        n.name = String.valueOf(nd.name) + "::" + n.name;
                    }
                    Node.optimise(this.lnode);
                }
            }
        }
    }

    public static <T> void optimise(List<Node<T>> lst) {
        Collections.sort(lst, new ComparatorNode());
        for (Node<T> node : lst) {
            node.optimise();
        }
    }

    public static final class ComparatorNode<T>
    implements Comparator<Node<T>> {
        @Override
        public int compare(Node<T> o1, Node<T> o2) {
            if (o1.value == null & o2.value != null) {
                return 1;
            }
            if (o1.value != null & o2.value == null) {
                return -1;
            }
            return o1.name.compareTo(o2.name);
        }
    }
}

