/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.solver.extension.filterby;

import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.IntegerElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.PrimitiveElement;
import fr.inria.aoste.timesquare.ccslkernel.runtime.SerializedConstraintState;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractSemanticHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractUpdateHelper;
import fr.inria.aoste.timesquare.ccslkernel.solver.TimeModel.BasicType.SolverSequenceElement;
import fr.inria.aoste.timesquare.ccslkernel.solver.TimeModel.SolverClock;
import fr.inria.aoste.timesquare.ccslkernel.solver.expression.AbstractWrappedExpression;

public class BlackboxFilterby
extends AbstractWrappedExpression {
    private SolverClock filteredClock;
    private SolverSequenceElement sequence;
    private int currentDelay;

    public BlackboxFilterby(SolverClock filteredClock, SolverSequenceElement sequence) {
        this.filteredClock = filteredClock;
        this.sequence = sequence;
    }

    public void setFilteredClock(SolverClock filteredClock) {
        this.filteredClock = filteredClock;
    }

    public void start(AbstractSemanticHelper helper) throws SimulationException {
        if (this.sequence.isEmpty()) {
            this.terminate(helper.getUpdateHelper());
            return;
        }
        PrimitiveElement head = this.sequence.nextHead();
        if (head instanceof IntegerElement) {
            this.currentDelay = ((IntegerElement)head).getValue();
        }
    }

    public void semantic(AbstractSemanticHelper semanticHelper) throws SimulationException {
        if (this.currentDelay == 1) {
            semanticHelper.semanticBDDAnd(semanticHelper.createEqual((RuntimeClock)this.filteredClock, (RuntimeClock)this.getImplicitClock()));
        } else {
            semanticHelper.inhibitClock((RuntimeClock)this.getImplicitClock());
        }
        semanticHelper.registerClockUse((RuntimeClock[])new SolverClock[]{this.filteredClock, this.getImplicitClock()});
    }

    public void update(AbstractUpdateHelper helper) throws SimulationException {
        if (helper.clockHasFired((RuntimeClock)this.filteredClock)) {
            if (this.currentDelay == 1) {
                if (this.sequence.isEmpty()) {
                    this.terminate(helper);
                } else {
                    PrimitiveElement head = this.sequence.nextHead();
                    if (head instanceof IntegerElement) {
                        this.currentDelay = ((IntegerElement)head).getValue();
                    }
                }
            } else {
                --this.currentDelay;
            }
        }
    }

    public void deathSemantic(AbstractSemanticHelper semanticHelper) throws SimulationException {
        semanticHelper.registerDeathImplication((RuntimeClock)this.filteredClock, (RuntimeClock)this.getImplicitClock());
    }

    public SerializedConstraintState dumpState() {
        SerializedConstraintState state = super.dumpState();
        state.dump((Object)this.currentDelay);
        state.dump((Object)this.sequence);
        return state;
    }

    public void restoreState(SerializedConstraintState state) {
        super.restoreState(state);
        this.currentDelay = (Integer)state.restore(0);
        this.sequence = (SolverSequenceElement)state.restore(1);
    }
}

