/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.launcher.core;

import fr.inria.aoste.timesquare.launcher.core.PropertySimulation;
import fr.inria.aoste.timesquare.launcher.core.inter.IBuildSolver;
import fr.inria.aoste.timesquare.launcher.core.inter.ICCSLProxy;
import fr.inria.aoste.timesquare.launcher.core.inter.ISolver;
import fr.inria.aoste.timesquare.utils.extensionpoint.ExtensionPointManager;
import fr.inria.aoste.timesquare.utils.extensionpoint.IExtensionManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IConfigurationElement;

public class PESolverManager
implements IExtensionManager {
    private static PESolverManager _default = null;
    private HashMap<String, List<IBuildSolver>> hashmapSolver = new HashMap();
    HashMap<IFile, Cache> table = new HashMap();
    private Throwable throwable = null;
    private List<Attribut> listAttribut = new ArrayList<Attribut>();

    public static synchronized PESolverManager getDefault() {
        if (_default == null) {
            _default = new PESolverManager();
        }
        return _default;
    }

    private PESolverManager() {
        ExtensionPointManager.findAllExtensions((IExtensionManager)this);
        this.postinit();
    }

    public final String getExtensionPointName() {
        return "fr.inria.aoste.timesquare.launcher.core.solver";
    }

    public final String getPluginName() {
        return "fr.inria.aoste.timesquare.launcher.core";
    }

    public void clearCache(int level) {
        this.table.clear();
        for (Attribut atb : this.listAttribut) {
            try {
                atb.solverbuild.clearCache(level);
            }
            catch (Throwable e) {
                System.err.println(e);
            }
        }
    }

    private synchronized Cache getCache(ICCSLProxy iccslproxy) {
        IFile file = iccslproxy.get_SourceIFile();
        if (file == null) {
            return null;
        }
        Cache c = this.table.get(file);
        if (c == null || c.stamp != file.getModificationStamp()) {
            c = new Cache(file);
            this.table.put(file, new Cache(file));
        }
        return c;
    }

    public ISolver createSolver(ICCSLProxy iccslproxy) {
        Cache cache;
        block4: {
            try {
                cache = this.getCache(iccslproxy);
                if (cache != null) break block4;
                return null;
            }
            catch (Throwable e) {
                this.throwable = e;
                e.printStackTrace();
                return null;
            }
        }
        if (cache.solver != null) {
            return cache.solver;
        }
        IBuildSolver solverBuilder = this.getSolverBuilder(iccslproxy);
        ISolver isol = solverBuilder.buildSolver(iccslproxy);
        this.throwable = solverBuilder.getException();
        cache.solver = isol;
        return isol;
    }

    public PropertySimulation[] getSupportPropertySimulation(ICCSLProxy iccslproxy) {
        this.throwable = null;
        try {
            IBuildSolver solver = this.getSolverBuilder(iccslproxy);
            return solver.getSupportPropertySimulation();
        }
        catch (Error e) {
            this.throwable = e;
            return new PropertySimulation[0];
        }
    }

    private IBuildSolver getSolverBuilder(ICCSLProxy iccslproxy) throws Error {
        IFile sourceFile = iccslproxy.get_SourceIFile();
        if (sourceFile == null) {
            throw new Error("No Source file in iccslproxy");
        }
        String extension = sourceFile.getFileExtension();
        List<IBuildSolver> ls = this.hashmapSolver.get(extension);
        if (ls == null) {
            throw new Error("No IBuildSolver List registered for extension " + extension);
        }
        if (ls.size() != 0) {
            return ls.get(0);
        }
        throw new Error("No IBuildSolver registered for extension " + extension);
    }

    public int getDefaultStep(ICCSLProxy iccslproxy) {
        this.throwable = null;
        try {
            IBuildSolver solver = this.getSolverBuilder(iccslproxy);
            return solver.getDefaultValue();
        }
        catch (Error e) {
            this.throwable = e;
            return 100;
        }
    }

    public boolean isExtensionSuppported(String ext) {
        List<IBuildSolver> ls = this.hashmapSolver.get(ext);
        if (ls == null) {
            return false;
        }
        return ls.size() != 0;
    }

    public String[] getListExtension() {
        return this.hashmapSolver.keySet().toArray(new String[this.hashmapSolver.size()]);
    }

    public final Throwable getThrowable() {
        return this.throwable;
    }

    public synchronized boolean validate(ICCSLProxy iccslproxy) {
        try {
            IBuildSolver solver = this.getSolverBuilder(iccslproxy);
            boolean sel = solver.validateSolver(iccslproxy);
            this.throwable = solver.getException();
            return sel;
        }
        catch (Error e) {
            this.throwable = e;
            return false;
        }
    }

    public void initExtension(IConfigurationElement ice) throws Throwable {
        Attribut at = new Attribut();
        at.name = ice.getAttribute("name");
        Class c = ExtensionPointManager.getPointExtensionClass((IConfigurationElement)ice, (String)"class", IBuildSolver.CLASS);
        at.solverbuild = (IBuildSolver)c.newInstance();
        String ext = ice.getAttribute("extensionfile");
        String[] st = ext.split(",");
        ArrayList<String> listextension = new ArrayList<String>();
        String[] stringArray = st;
        int n = st.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            listextension.add(s.trim());
            ++n2;
        }
        at.listextension = listextension;
        this.listAttribut.add(at);
        System.out.println("Read " + at.name + "  " + c.getName() + " <" + ext + ">");
    }

    private void postinit() {
        for (Attribut a : this.listAttribut) {
            for (String ext : a.listextension) {
                List<IBuildSolver> ls = this.hashmapSolver.get(ext);
                if (ls == null) {
                    ls = new ArrayList<IBuildSolver>();
                    this.hashmapSolver.put(ext, ls);
                }
                ls.add(a.solverbuild);
            }
        }
    }

    public static class Attribut {
        List<String> listextension = null;
        String name = null;
        IBuildSolver solverbuild = null;
    }

    public static class Cache {
        long stamp = 0L;
        IFile file = null;
        ISolver solver;

        public Cache(IFile file) {
            this.file = file;
            this.stamp = file.getModificationStamp();
        }

        public final IFile getFile() {
            return this.file;
        }
    }
}

