/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.listener;

import fr.inria.aoste.timesquare.vcd.IVcdDiagram;
import fr.inria.aoste.timesquare.vcd.VcdZoom;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;

public class WheelListener
implements MouseWheelListener {
    private IVcdDiagram _vcdDiagram;

    public WheelListener(IVcdDiagram vcdDiagram) {
        this._vcdDiagram = vcdDiagram;
    }

    public void mouseScrolled(MouseEvent e) {
        if (this._vcdDiagram.isSimulation()) {
            return;
        }
        if (!this._vcdDiagram.isCtrlKey()) {
            return;
        }
        VcdZoom vcdzoom = this._vcdDiagram.getVcdzoom();
        if (vcdzoom == null) {
            return;
        }
        if (vcdzoom.isLock()) {
            return;
        }
        int counter = vcdzoom.getZoomCounter();
        this._vcdDiagram.setZoomValue(1.0);
        int sel = this._vcdDiagram.getCanvas().getHorizontalBar().getSelection() - 5;
        if (e.count > 0 && counter < 4) {
            this._vcdDiagram.setZoomValue(2.0);
            this._vcdDiagram.setTcZoom(this._vcdDiagram.getTraceZoomValue() * 2.0);
            vcdzoom.setZoomCounter(++counter);
            vcdzoom.applyScrollZoom();
            this._vcdDiagram.getScaleCanvas().getHorizontalBar().setSelection(sel * 2 + 5);
            this._vcdDiagram.getCanvas().getHorizontalBar().setSelection(sel * 2 + 5);
            this._vcdDiagram.getScaleCanvas().scrollToX(sel * 2 + 5);
            this._vcdDiagram.getCanvas().scrollToX(sel * 2 + 5);
        } else if (e.count < 0 && counter > -5) {
            this._vcdDiagram.setZoomValue(0.5);
            this._vcdDiagram.setTcZoom(this._vcdDiagram.getTraceZoomValue() * 0.5);
            vcdzoom.setZoomCounter(--counter);
            vcdzoom.applyScrollZoom();
            this._vcdDiagram.getCanvas().getHorizontalBar().setSelection(sel / 2 + 5);
            this._vcdDiagram.getScaleCanvas().scrollToX(sel / 2 + 5);
            this._vcdDiagram.getScaleCanvas().scrollToX(sel / 2 + 5);
            this._vcdDiagram.getCanvas().scrollToX(sel / 2 + 5);
        }
    }
}

