/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.k3.al.annotationprocessor;

import com.google.common.base.Objects;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.RegisterGlobalsContext;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.CompilationStrategy;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend.lib.macro.expression.Expression;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class SingletonProcessor extends AbstractClassProcessor {
  @Override
  public void doRegisterGlobals(final ClassDeclaration annotatedClass, final RegisterGlobalsContext context) {
  }
  
  @Override
  public void doTransform(final MutableClassDeclaration annotatedClass, @Extension final TransformationContext context) {
    annotatedClass.setFinal(true);
    int _size = IterableExtensions.size(annotatedClass.getDeclaredConstructors());
    boolean _greaterThan = (_size > 1);
    if (_greaterThan) {
      context.addError(annotatedClass, "More then one constructor is defined");
    }
    final MutableConstructorDeclaration constructor = IterableExtensions.head(annotatedClass.getDeclaredConstructors());
    int _size_1 = IterableExtensions.size(constructor.getParameters());
    boolean _greaterThan_1 = (_size_1 > 0);
    if (_greaterThan_1) {
      context.addError(constructor, "Constructor has arguments");
    }
    Expression _body = constructor.getBody();
    boolean _tripleEquals = (_body == null);
    if (_tripleEquals) {
      constructor.setVisibility(Visibility.PRIVATE);
      final CompilationStrategy _function = (CompilationStrategy.CompilationContext it) -> {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// singleton");
        return _builder;
      };
      constructor.setBody(_function);
    } else {
      Visibility _visibility = constructor.getVisibility();
      boolean _notEquals = (!Objects.equal(_visibility, Visibility.PRIVATE));
      if (_notEquals) {
        context.addError(constructor, "Constructor is not private");
      }
    }
    final Procedure1<MutableFieldDeclaration> _function_1 = (MutableFieldDeclaration it) -> {
      it.setVisibility(Visibility.PRIVATE);
      it.setStatic(true);
      it.setFinal(true);
      it.setType(context.newTypeReference(annotatedClass));
      final CompilationStrategy _function_2 = (CompilationStrategy.CompilationContext it_1) -> {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new ");
        String _simpleName = annotatedClass.getSimpleName();
        _builder.append(_simpleName);
        _builder.append("()");
        return _builder;
      };
      it.setInitializer(_function_2);
    };
    annotatedClass.addField("INSTANCE", _function_1);
    final Procedure1<MutableMethodDeclaration> _function_2 = (MutableMethodDeclaration it) -> {
      it.setVisibility(Visibility.PUBLIC);
      it.setStatic(true);
      it.setReturnType(context.newTypeReference(annotatedClass));
      final CompilationStrategy _function_3 = (CompilationStrategy.CompilationContext it_1) -> {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("return INSTANCE;");
        return _builder;
      };
      it.setBody(_function_3);
    };
    annotatedClass.addMethod("getInstance", _function_2);
  }
}
