/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.lightccsl.core.stepper;

import fr.kairos.common.IFactory;
import fr.kairos.lightccsl.core.stepper.ClockCollector;
import fr.kairos.lightccsl.core.stepper.ClockStatus;
import fr.kairos.lightccsl.core.stepper.IClock;
import fr.kairos.lightccsl.core.stepper.IClockBuilder;
import fr.kairos.lightccsl.core.stepper.IClockManager;
import fr.kairos.lightccsl.core.stepper.INameToIntegerMapper;
import fr.kairos.lightccsl.core.stepper.ISolutionSet;
import fr.kairos.lightccsl.core.stepper.IStep;
import fr.kairos.lightccsl.core.stepper.IStepper;
import fr.kairos.lightccsl.core.stepper.StepIterableFilter;
import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;

public class GenericStepper
implements IStepper,
IClockManager,
INameToIntegerMapper {
    private int current = 0;
    private ClockCollector collector;
    private IFactory<ISolutionSet> solutionBuilder;

    public GenericStepper(IFactory<ISolutionSet> solutionBuilder, IClockBuilder externalClockBuilder) {
        this.collector = new ClockCollector(externalClockBuilder);
        this.solutionBuilder = solutionBuilder;
    }

    @Override
    public IClock clock(String clock) {
        return this.collector.nameToClock(clock);
    }

    @Override
    public int getIdFromName(String name) {
        return this.collector.getIdFromName(name);
    }

    @Override
    public String getNameFromId(int id) {
        return this.collector.getNameFromId(id);
    }

    @Override
    public int size() {
        return this.collector.size();
    }

    private void tick(Scanner sc, IStep step) throws IOException {
        step.tick();
        boolean[] ticks = new boolean[this.size()];
        int nbMust = 0;
        for (int clockId : new StepIterableFilter(ClockStatus.Must, step)) {
            this.idToClock(clockId).tick(this.current);
            ticks[clockId] = true;
            ++nbMust;
        }
        for (int clockId : new StepIterableFilter(ClockStatus.May, step)) {
            if (sc != null && sc.hasNextInt()) {
                if (sc.nextInt() == 1) {
                    this.idToClock(clockId).tick(this.current);
                    ticks[clockId] = true;
                    continue;
                }
                this.idToClock(clockId).ghost(this.current);
                continue;
            }
            if (nbMust == 0) {
                this.idToClock(clockId).tick(this.current);
                ticks[clockId] = true;
                continue;
            }
            this.idToClock(clockId).ghost(this.current);
            break;
        }
        for (int clockId : new StepIterableFilter(ClockStatus.Undetermined, step)) {
            ClockStatus stat = step.status(clockId, ticks);
            if (stat != ClockStatus.Must) continue;
            this.idToClock(clockId).tick(this.current);
            ticks[clockId] = true;
        }
        ++this.current;
    }

    private IClock idToClock(int id) {
        return this.collector.idToClock(id);
    }

    void printTrace(int nbStep) {
        System.out.print("clock      | ");
        int i = 0;
        while (i < nbStep) {
            System.out.printf("%3d", i);
            ++i;
        }
        System.out.println();
        int id = 0;
        for (IClock c : this.collector) {
            System.out.printf("%10s | ", this.collector.getNameFromId(id));
            System.out.println(c.toString());
            ++id;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<? extends IStep> printAllSolutions(ISolutionSet boolSpec) throws Exception {
        List<? extends IStep> solutions = boolSpec.allSolutions();
        boolean unsat = true;
        int nb = 1;
        for (IStep iStep : solutions) {
            unsat = false;
            System.out.printf("%2d:", nb++);
            int i = 0;
            block7: for (IClock clock : this.collector) {
                switch (iStep.status(i, new boolean[0])) {
                    case Cannot: {
                        System.out.print(" !");
                        break;
                    }
                    case Must: {
                        System.out.print("  ");
                        break;
                    }
                    case May: {
                        System.out.print(" ?");
                        break;
                    }
                    case Undetermined: {
                        ++i;
                        continue block7;
                    }
                }
                System.out.print(this.collector.getNameFromId(i));
                ++i;
            }
            System.out.println();
        }
        if (unsat) {
            System.out.println("UNSAT");
        }
        return solutions;
    }

    void step(boolean debug) throws Exception {
        ISolutionSet solutions = this.solutionBuilder.build();
        IStep sol = solutions.pickOneSolution();
        if (debug) {
            System.out.println(String.valueOf(this.current) + ": ");
            this.printAllSolutions(solutions);
        }
        this.tick(null, sol);
    }

    @Override
    public void stepAndPrint(int nbStep, boolean debug) throws Exception {
        int i = 0;
        while (i < nbStep) {
            this.step(debug);
            ++i;
        }
        this.printTrace(nbStep);
    }

    @Override
    public int interactiveStep() throws Exception {
        int nbStep = 0;
        Scanner sc = new Scanner(System.in);
        sc.useDelimiter("\\s*");
        while (true) {
            ISolutionSet solver = this.solutionBuilder.build();
            System.out.println(" 0: stop");
            List<? extends IStep> solutions = this.printAllSolutions(solver);
            System.out.println(String.valueOf(solutions.size()) + " solutions. pick one ?");
            try {
                String line = sc.nextLine();
                Scanner sLine = new Scanner(line);
                int v = sLine.nextInt();
                if (v < 1 || v > solutions.size()) break;
                IStep solution = solutions.get(v - 1);
                ++nbStep;
                this.tick(sLine, solution);
            }
            catch (NoSuchElementException nse) {
                System.err.println("No Such Element => exit");
                break;
            }
        }
        sc.close();
        this.printTrace(nbStep);
        return nbStep;
    }

    @Override
    public Iterable<String> getClockNames() {
        return this.collector.getClockNames();
    }
}

