/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.timesquare.ccsl.sat;

import fr.kairos.lightccsl.core.stepper.IClock;
import fr.kairos.lightccsl.core.stepper.IClockManager;
import fr.kairos.timesquare.ccsl.ISimpleSpecification;
import fr.kairos.timesquare.ccsl.sat.IBooleanSpecification;
import fr.kairos.timesquare.ccsl.simple.IUnfoldHelper;

public class SemanticBuilder
implements ISimpleSpecification {
    private IBooleanSpecification boolSpec;
    private IClockManager clockManager;

    public SemanticBuilder(IBooleanSpecification boolSpec, IClockManager clockManager) {
        this.boolSpec = boolSpec;
        this.clockManager = clockManager;
    }

    @Override
    public void addClock(String name) {
        this.boolSpec.id(name);
    }

    @Override
    public void subclock(String left, String right) {
        this.boolSpec.implies(left, right);
    }

    @Override
    public void exclusion(String left, String right) {
        this.boolSpec.forbids(left, right);
    }

    @Override
    public void precedence(String left, String right) {
        if (this.history(left) == this.history(right)) {
            this.boolSpec.not(right);
        }
    }

    @Override
    public void precedence(String left, String right, int init, int max) {
        int delta = this.history(left) - this.history(right) + init;
        if (delta == 0) {
            this.boolSpec.not(right);
        }
        if (max != -1 && delta == max) {
            this.boolSpec.not(left);
        }
    }

    @Override
    public void causality(String left, String right) {
        int delta = this.history(left) - this.history(right);
        if (delta == 0) {
            this.boolSpec.implies(right, left);
        }
    }

    @Override
    public void causality(String left, String right, int init, int max) {
        int delta = this.history(left) - this.history(right) + init;
        if (delta == 0) {
            this.boolSpec.implies(right, left);
        }
        if (max != -1 && delta == max) {
            this.boolSpec.implies(left, right);
        }
    }

    @Override
    public void inf(String defClock, String ... clocks) {
        new IUnfoldHelper(){

            @Override
            public void binary(String def, String clock1, String clock2) {
                SemanticBuilder.this.boolSpec.id(def);
                int chi = SemanticBuilder.this.history(clock1) - SemanticBuilder.this.history(clock2);
                if (chi > 0) {
                    SemanticBuilder.this.boolSpec.implies(clock1, def);
                    SemanticBuilder.this.boolSpec.implies(def, clock1);
                } else if (chi < 0) {
                    SemanticBuilder.this.boolSpec.implies(clock2, def);
                    SemanticBuilder.this.boolSpec.implies(def, clock2);
                } else {
                    SemanticBuilder.this.boolSpec.implies(clock1, def);
                    SemanticBuilder.this.boolSpec.implies(clock2, def);
                    SemanticBuilder.this.boolSpec.implies(def, clock1, clock2);
                }
            }
        }.unfold(defClock, clocks);
    }

    @Override
    public void sup(String defClock, String ... clocks) {
        new IUnfoldHelper(){

            @Override
            public void binary(String def, String clock1, String clock2) {
                int chi = SemanticBuilder.this.history(clock1) - SemanticBuilder.this.history(clock2);
                if (chi > 0) {
                    SemanticBuilder.this.boolSpec.implies(clock2, def);
                    SemanticBuilder.this.boolSpec.implies(def, clock2);
                } else if (chi < 0) {
                    SemanticBuilder.this.boolSpec.implies(clock1, def);
                    SemanticBuilder.this.boolSpec.implies(def, clock1);
                } else {
                    SemanticBuilder.this.boolSpec.implies(def, clock1);
                    SemanticBuilder.this.boolSpec.implies(def, clock2);
                    SemanticBuilder.this.boolSpec.clause(def, clock1, clock2);
                }
            }
        }.unfold(defClock, clocks);
    }

    @Override
    public void union(String defClock, String ... clocks) {
        this.boolSpec.or(defClock, clocks);
    }

    @Override
    public void intersection(String defClock, String ... clocks) {
        this.boolSpec.and(defClock, clocks);
    }

    @Override
    public void minus(String defClock, String ... clocks) {
        this.boolSpec.implies(defClock, clocks[0]);
        int i = 1;
        while (i < clocks.length) {
            this.boolSpec.forbids(defClock, clocks[i]);
            ++i;
        }
        String c0 = clocks[0];
        clocks[0] = defClock;
        this.boolSpec.implies(c0, clocks);
        clocks[0] = c0;
    }

    @Override
    public void periodic(String p, String ref, int period, int from, int upto) {
        this.boolSpec.implies(p, ref);
        int h = this.history(ref);
        if (h < from) {
            this.boolSpec.not(p);
            return;
        }
        if (upto != -1 && h > upto) {
            this.boolSpec.not(p);
            return;
        }
        if ((h = (h - from) % period) == 0) {
            this.boolSpec.implies(ref, p);
        } else {
            this.boolSpec.not(p);
        }
    }

    @Override
    public void delayFor(String defClock, String ref, int from, int upTo, String base) {
        if (base == null || from == 0) {
            this.delay(defClock, ref, from, upTo);
        } else {
            this.delay(defClock, ref, from, upTo, base);
        }
    }

    private void delay(String d, String ref, int delay, int upTo) {
        this.boolSpec.implies(d, ref);
        int h = this.history(ref);
        if (h < delay) {
            this.boolSpec.not(d);
            return;
        }
        if (upTo != -1 && h > upTo) {
            this.boolSpec.not(d);
            return;
        }
        this.boolSpec.implies(ref, d);
    }

    private void delay(String d, String ref, int delay, int upTo, String base) {
        int step;
        assert (base != null && delay != 0);
        IClock baseClock = this.clock(base);
        if (baseClock.getHistory() < delay) {
            this.boolSpec.not(d);
            return;
        }
        this.boolSpec.implies(d, base);
        int lastBase = baseClock.previous(delay - 1);
        int lastBaseBefore = baseClock.previous(delay);
        IClock refClock = this.clock(ref);
        int back = 0;
        while ((step = refClock.previous(back++)) >= lastBaseBefore) {
            if (step > lastBase) continue;
            this.boolSpec.implies(base, d);
            return;
        }
        this.boolSpec.not(d);
        this.boolSpec.implies(d, ref);
    }

    private IClock clock(String clock) {
        return this.clockManager.clock(clock);
    }

    private int history(String clock) {
        IClock c = this.clockManager.clock(clock);
        if (c == null) {
            return 0;
        }
        return c.getHistory();
    }
}

