/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.search.matching;

import java.util.Arrays;
import java.util.HashMap;
import org.aspectj.ajdt.internal.compiler.lookup.OwningClassSupportForMethodBindings;
import org.aspectj.org.eclipse.jdt.core.Flags;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IMethod;
import org.aspectj.org.eclipse.jdt.core.IType;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.Signature;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.search.MethodDeclarationMatch;
import org.aspectj.org.eclipse.jdt.core.search.MethodReferenceMatch;
import org.aspectj.org.eclipse.jdt.core.search.SearchMatch;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ReferenceExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.aspectj.org.eclipse.jdt.internal.core.BinaryMethod;
import org.aspectj.org.eclipse.jdt.internal.core.ClassFile;
import org.aspectj.org.eclipse.jdt.internal.core.search.BasicSearchEngine;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.DeclarationOfReferencedMethodsPattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.MatchingNodeSet;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.MethodPattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.PatternLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.SuperTypeNamesCollector;
import org.aspectj.runtime.internal.AroundClosure;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class MethodLocator
extends PatternLocator {
    protected MethodPattern pattern;
    protected boolean isDeclarationOfReferencedMethodsPattern;
    public char[][][] allSuperDeclaringTypeNames;
    private char[][][] samePkgSuperDeclaringTypeNames;
    private MatchLocator matchLocator;
    private HashMap methodDeclarationsWithInvalidParam = new HashMap();

    public MethodLocator(MethodPattern pattern) {
        super(pattern);
        this.pattern = pattern;
        this.isDeclarationOfReferencedMethodsPattern = this.pattern instanceof DeclarationOfReferencedMethodsPattern;
    }

    @Override
    protected void clear() {
        this.methodDeclarationsWithInvalidParam = new HashMap();
    }

    @Override
    protected int fineGrain() {
        return this.pattern.fineGrain;
    }

    private ReferenceBinding getMatchingSuper(ReferenceBinding binding) {
        if (binding == null) {
            return null;
        }
        ReferenceBinding superBinding = binding.superclass();
        int level = this.resolveLevelForType(this.pattern.declaringSimpleName, this.pattern.declaringQualification, superBinding);
        if (level != 0) {
            return superBinding;
        }
        if (!binding.isInterface() && !CharOperation.equals(binding.compoundName, TypeConstants.JAVA_LANG_OBJECT) && (superBinding = this.getMatchingSuper(superBinding)) != null) {
            return superBinding;
        }
        ReferenceBinding[] interfaces = binding.superInterfaces();
        if (interfaces == null) {
            return null;
        }
        int i = 0;
        while (i < interfaces.length) {
            level = this.resolveLevelForType(this.pattern.declaringSimpleName, this.pattern.declaringQualification, interfaces[i]);
            if (level != 0) {
                return interfaces[i];
            }
            superBinding = this.getMatchingSuper(interfaces[i]);
            if (superBinding != null) {
                return superBinding;
            }
            ++i;
        }
        return null;
    }

    private MethodBinding getMethodBinding(ReferenceBinding type, char[] methodName, TypeBinding[] argumentTypes) {
        MethodBinding[] methods = type.getMethods(methodName);
        MethodBinding method = null;
        int i = 0;
        int length = methods.length;
        while (i < length) {
            block4: {
                method = methods[i];
                TypeBinding[] parameters = method.parameters;
                if (argumentTypes.length == parameters.length) {
                    int j = 0;
                    int l = parameters.length;
                    while (j < l) {
                        if (!TypeBinding.notEquals(parameters[j].erasure(), argumentTypes[j].erasure())) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    return method;
                }
            }
            ++i;
        }
        return null;
    }

    @Override
    public void initializePolymorphicSearch(MatchLocator locator) {
        long start = 0L;
        if (BasicSearchEngine.VERBOSE) {
            start = System.currentTimeMillis();
        }
        try {
            SuperTypeNamesCollector namesCollector = new SuperTypeNamesCollector(this.pattern, this.pattern.declaringSimpleName, this.pattern.declaringQualification, locator, this.pattern.declaringType, locator.progressMonitor);
            this.allSuperDeclaringTypeNames = namesCollector.collect();
            this.samePkgSuperDeclaringTypeNames = namesCollector.getSamePackageSuperTypeNames();
            this.matchLocator = locator;
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        if (BasicSearchEngine.VERBOSE) {
            System.out.println("Time to initialize polymorphic search: " + (System.currentTimeMillis() - start));
        }
    }

    private boolean isTypeInSuperDeclaringTypeNames(char[][] typeName) {
        if (this.allSuperDeclaringTypeNames == null) {
            return false;
        }
        int length = this.allSuperDeclaringTypeNames.length;
        int i = 0;
        while (i < length) {
            if (CharOperation.equals(this.allSuperDeclaringTypeNames[i], typeName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isVirtualInvoke(MethodBinding method, MessageSend messageSend) {
        MethodBinding methodBinding;
        return !method.isStatic() && !method.isPrivate() && !messageSend.isSuperAccess() && (!method.isDefault() || this.pattern.focus == null || CharOperation.equals(this.pattern.declaringPackageName, ((ReferenceBinding)MethodLocator.declaringClass_aroundBody1$advice(this, methodBinding = method, OwningClassSupportForMethodBindings.aspectOf(), methodBinding, null)).qualifiedPackageName()));
    }

    protected ReferenceBinding checkMethodRef(MethodBinding method, ReferenceExpression referenceExpression) {
        TypeBinding binding;
        Expression lhs;
        MethodBinding methodBinding;
        boolean result;
        boolean bl = result = !method.isStatic() && !method.isPrivate() && referenceExpression.isMethodReference() && (!method.isDefault() || this.pattern.focus == null || CharOperation.equals(this.pattern.declaringPackageName, ((ReferenceBinding)MethodLocator.declaringClass_aroundBody3$advice(this, methodBinding = method, OwningClassSupportForMethodBindings.aspectOf(), methodBinding, null)).qualifiedPackageName()));
        if (result && (lhs = referenceExpression.lhs) instanceof NameReference && (binding = ((NameReference)lhs).resolvedType) instanceof ReferenceBinding) {
            return (ReferenceBinding)binding;
        }
        return null;
    }

    @Override
    public int match(ASTNode node, MatchingNodeSet nodeSet) {
        int declarationsLevel = 0;
        if (this.pattern.findReferences && node instanceof ImportReference) {
            ImportReference importRef = (ImportReference)node;
            int length = importRef.tokens.length - 1;
            if (importRef.isStatic() && (importRef.bits & 0x20000) == 0 && this.matchesName(this.pattern.selector, importRef.tokens[length])) {
                char[][] compoundName = new char[length][];
                System.arraycopy(importRef.tokens, 0, compoundName, 0, length);
                char[] declaringType = CharOperation.concat(this.pattern.declaringQualification, this.pattern.declaringSimpleName, '.');
                if (this.matchesName(declaringType, CharOperation.concatWith(compoundName, '.'))) {
                    declarationsLevel = this.pattern.mustResolve ? 2 : 3;
                }
            }
        }
        return nodeSet.addMatch(node, declarationsLevel);
    }

    @Override
    public int match(LambdaExpression node, MatchingNodeSet nodeSet) {
        if (!this.pattern.findDeclarations) {
            return 0;
        }
        if (this.pattern.parameterSimpleNames != null && this.pattern.parameterSimpleNames.length != node.arguments().length) {
            return 0;
        }
        nodeSet.mustResolve = true;
        return nodeSet.addMatch(node, 2);
    }

    @Override
    public int match(MethodDeclaration node, MatchingNodeSet nodeSet) {
        if (!this.pattern.findDeclarations) {
            return 0;
        }
        if (!this.matchesName(this.pattern.selector, node.selector)) {
            return 0;
        }
        boolean resolve = this.pattern.mustResolve;
        if (this.pattern.parameterSimpleNames != null) {
            int argsLength;
            int length = this.pattern.parameterSimpleNames.length;
            Argument[] args = node.arguments;
            int n = argsLength = args == null ? 0 : args.length;
            if (length != argsLength) {
                return 0;
            }
            int i = 0;
            while (i < argsLength) {
                if (args != null && !this.matchesTypeReference(this.pattern.parameterSimpleNames[i], args[i].type)) {
                    if (this.mayBeGeneric) {
                        if (!this.pattern.mustResolve) {
                            nodeSet.mustResolve = true;
                            resolve = true;
                        }
                        this.methodDeclarationsWithInvalidParam.put(node, null);
                    } else {
                        return 0;
                    }
                }
                ++i;
            }
        }
        if (this.pattern.hasMethodArguments() && (node.typeParameters == null || node.typeParameters.length != this.pattern.methodArguments.length)) {
            return 0;
        }
        return nodeSet.addMatch(node, resolve ? 2 : 3);
    }

    @Override
    public int match(MemberValuePair node, MatchingNodeSet nodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        if (!this.matchesName(this.pattern.selector, node.name)) {
            return 0;
        }
        return nodeSet.addMatch(node, this.pattern.mustResolve ? 2 : 3);
    }

    @Override
    public int match(MessageSend node, MatchingNodeSet nodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        if (!this.matchesName(this.pattern.selector, node.selector)) {
            return 0;
        }
        if (!(this.pattern.parameterSimpleNames == null || this.pattern.varargs && (node.bits & 0x8000) == 0)) {
            int argsLength;
            int length = this.pattern.parameterSimpleNames.length;
            Expression[] args = node.arguments;
            int n = argsLength = args == null ? 0 : args.length;
            if (length != argsLength) {
                return 0;
            }
        }
        return nodeSet.addMatch(node, this.pattern.mustResolve ? 2 : 3);
    }

    @Override
    public int match(ReferenceExpression node, MatchingNodeSet nodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        if (!this.matchesName(this.pattern.selector, node.selector)) {
            return 0;
        }
        if (node.selector != null && Arrays.equals(node.selector, ConstantPool.Init)) {
            return 0;
        }
        nodeSet.mustResolve = true;
        return nodeSet.addMatch(node, this.pattern.mustResolve ? 2 : 3);
    }

    @Override
    public int match(Annotation node, MatchingNodeSet nodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        MemberValuePair[] pairs = node.memberValuePairs();
        if (pairs == null || pairs.length == 0) {
            return 0;
        }
        int length = pairs.length;
        MemberValuePair pair = null;
        int i = 0;
        while (i < length) {
            pair = node.memberValuePairs()[i];
            if (this.matchesName(this.pattern.selector, pair.name)) {
                ASTNode possibleNode = node instanceof SingleMemberAnnotation ? node : pair;
                return nodeSet.addMatch(possibleNode, this.pattern.mustResolve ? 2 : 3);
            }
            ++i;
        }
        return 0;
    }

    @Override
    protected int matchContainer() {
        if (this.pattern.findReferences) {
            return 15;
        }
        return 2;
    }

    @Override
    protected void matchLevelAndReportImportRef(ImportReference importRef, Binding binding, MatchLocator locator) throws CoreException {
        if (importRef.isStatic() && binding instanceof MethodBinding) {
            super.matchLevelAndReportImportRef(importRef, binding, locator);
        }
    }

    protected int matchMethod(MethodBinding method, boolean skipImpossibleArg) {
        int parameterCount;
        int newLevel;
        if (!this.matchesName(this.pattern.selector, method.selector)) {
            return 0;
        }
        int level = 3;
        if (this.pattern.declaringSimpleName == null && level > (newLevel = this.resolveLevelForType(this.pattern.returnSimpleName, this.pattern.returnQualification, method.returnType))) {
            if (newLevel == 0) {
                return 0;
            }
            level = newLevel;
        }
        int n = parameterCount = this.pattern.parameterSimpleNames == null ? -1 : this.pattern.parameterSimpleNames.length;
        if (parameterCount > -1) {
            if (method.parameters == null) {
                return 1;
            }
            if (parameterCount != method.parameters.length) {
                return 0;
            }
            if (!method.isValidBinding() && ((ProblemMethodBinding)method).problemId() == 3) {
                return 1;
            }
            boolean foundTypeVariable = false;
            MethodBinding focusMethodBinding = null;
            boolean checkedFocus = false;
            boolean isBinary = this.pattern != null && this.pattern.focus instanceof BinaryMethod;
            int i = 0;
            while (i < parameterCount) {
                TypeBinding argType = method.parameters[i];
                int newLevel2 = 0;
                boolean foundLevel = false;
                if (argType.isMemberType() || this.pattern.parameterQualifications[i] != null) {
                    TypeBinding[] parameters;
                    if (!checkedFocus) {
                        focusMethodBinding = this.matchLocator.getMethodBinding(this.pattern);
                        checkedFocus = true;
                    }
                    if (focusMethodBinding != null && (parameters = focusMethodBinding.parameters).length >= parameterCount) {
                        newLevel2 = (isBinary ? argType.erasure().isEquivalentTo(parameters[i].erasure()) : argType.isEquivalentTo(parameters[i])) ? 3 : 0;
                        foundLevel = true;
                    }
                } else {
                    newLevel2 = this.resolveLevelForType(this.pattern.parameterSimpleNames[i], this.pattern.parameterQualifications[i], argType);
                }
                if (level > newLevel2) {
                    if (newLevel2 == 0) {
                        if (skipImpossibleArg) {
                            if (!foundLevel) {
                                newLevel2 = level;
                            }
                        } else if (argType.isTypeVariable()) {
                            newLevel2 = level;
                            foundTypeVariable = true;
                        } else {
                            return 0;
                        }
                    }
                    level = newLevel2;
                }
                ++i;
            }
            if (foundTypeVariable) {
                if (!method.isStatic() && !method.isPrivate()) {
                    MethodBinding methodBinding;
                    if (!checkedFocus) {
                        focusMethodBinding = this.matchLocator.getMethodBinding(this.pattern);
                    }
                    if (focusMethodBinding != null && this.matchOverriddenMethod((ReferenceBinding)MethodLocator.declaringClass_aroundBody5$advice(this, methodBinding = focusMethodBinding, OwningClassSupportForMethodBindings.aspectOf(), methodBinding, null), focusMethodBinding, method)) {
                        return 3;
                    }
                }
                return 0;
            }
        }
        return level;
    }

    private boolean matchOverriddenMethod(ReferenceBinding type, MethodBinding method, MethodBinding matchMethod) {
        ReferenceBinding[] interfaces;
        if (type == null || this.pattern.selector == null) {
            return false;
        }
        if (!type.isInterface() && !CharOperation.equals(type.compoundName, TypeConstants.JAVA_LANG_OBJECT)) {
            ReferenceBinding superClass = type.superclass();
            if (superClass.isParameterizedType()) {
                MethodBinding[] methods = superClass.getMethods(this.pattern.selector);
                int length = methods.length;
                int i = 0;
                while (i < length) {
                    if (methods[i].areParametersEqual(method) && (matchMethod == null ? this.methodParametersEqualsPattern(methods[i].original()) : methods[i].original().areParametersEqual(matchMethod))) {
                        return true;
                    }
                    ++i;
                }
            }
            if (this.matchOverriddenMethod(superClass, method, matchMethod)) {
                return true;
            }
        }
        if ((interfaces = type.superInterfaces()) == null) {
            return false;
        }
        int iLength = interfaces.length;
        int i = 0;
        while (i < iLength) {
            if (interfaces[i].isParameterizedType()) {
                MethodBinding[] methods = interfaces[i].getMethods(this.pattern.selector);
                int length = methods.length;
                int j = 0;
                while (j < length) {
                    if (methods[j].areParametersEqual(method) && (matchMethod == null ? this.methodParametersEqualsPattern(methods[j].original()) : methods[j].original().areParametersEqual(matchMethod))) {
                        return true;
                    }
                    ++j;
                }
            }
            if (this.matchOverriddenMethod(interfaces[i], method, matchMethod)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    protected void matchReportReference(ASTNode reference, IJavaElement element, Binding elementBinding, int accuracy, MatchLocator locator) throws CoreException {
        this.matchReportReference(reference, element, null, null, elementBinding, accuracy, locator);
    }

    @Override
    protected void matchReportReference(ASTNode reference, IJavaElement element, IJavaElement localElement, IJavaElement[] otherElements, Binding elementBinding, int accuracy, MatchLocator locator) throws CoreException {
        MethodBinding methodBinding;
        MethodBinding methodBinding2 = reference instanceof MessageSend ? ((MessageSend)reference).binding : (methodBinding = elementBinding instanceof MethodBinding ? (MethodBinding)elementBinding : null);
        if (this.isDeclarationOfReferencedMethodsPattern) {
            if (methodBinding == null) {
                return;
            }
            if (accuracy != 0) {
                return;
            }
            DeclarationOfReferencedMethodsPattern declPattern = (DeclarationOfReferencedMethodsPattern)this.pattern;
            while (element != null && !declPattern.enclosingElement.equals(element)) {
                element = element.getParent();
            }
            if (element != null) {
                this.reportDeclaration(methodBinding, locator, declPattern.knownMethods);
            }
        } else {
            MethodReferenceMatch methodReferenceMatch = locator.newMethodReferenceMatch(element, elementBinding, accuracy, -1, -1, false, false, reference);
            methodReferenceMatch.setLocalElement(localElement);
            this.match = methodReferenceMatch;
            if (this.pattern.findReferences && reference instanceof MessageSend) {
                boolean isPrivate;
                MethodBinding methodBinding3;
                IJavaElement focus = this.pattern.focus;
                if (focus != null && focus.getElementType() == 9 && methodBinding != null && (ReferenceBinding)MethodLocator.declaringClass_aroundBody7$advice(this, methodBinding3 = methodBinding, OwningClassSupportForMethodBindings.aspectOf(), methodBinding3, null) != null && (isPrivate = Flags.isPrivate(((IMethod)focus).getFlags()))) {
                    MethodBinding methodBinding4 = methodBinding;
                    if (!CharOperation.equals(((ReferenceBinding)MethodLocator.declaringClass_aroundBody9$advice((MethodLocator)this, (MethodBinding)methodBinding4, (OwningClassSupportForMethodBindings)OwningClassSupportForMethodBindings.aspectOf(), (MethodBinding)methodBinding4, null)).sourceName, focus.getParent().getElementName().toCharArray())) {
                        return;
                    }
                }
                this.matchReportReference((MessageSend)reference, locator, accuracy, ((MessageSend)reference).binding);
            } else {
                if (reference instanceof SingleMemberAnnotation) {
                    reference = ((SingleMemberAnnotation)reference).memberValuePairs()[0];
                    this.match.setImplicit(true);
                }
                int offset = reference instanceof ReferenceExpression ? ((ReferenceExpression)reference).nameSourceStart : reference.sourceStart;
                int length = reference.sourceEnd - offset + 1;
                this.match.setOffset(offset);
                this.match.setLength(length);
                locator.report(this.match);
            }
        }
    }

    void matchReportReference(MessageSend messageSend, MatchLocator locator, int accuracy, MethodBinding methodBinding) throws CoreException {
        boolean report;
        boolean isParameterized = false;
        if (methodBinding instanceof ParameterizedGenericMethodBinding) {
            MethodBinding methodBinding2;
            isParameterized = true;
            ParameterizedGenericMethodBinding parameterizedMethodBinding = (ParameterizedGenericMethodBinding)methodBinding;
            this.match.setRaw(parameterizedMethodBinding.isRaw);
            TypeBinding[] typeArguments = parameterizedMethodBinding.typeArguments;
            this.updateMatch(typeArguments, locator, this.pattern.methodArguments, this.pattern.hasMethodParameters());
            MethodBinding methodBinding3 = methodBinding;
            if (((ReferenceBinding)MethodLocator.declaringClass_aroundBody11$advice(this, methodBinding3, OwningClassSupportForMethodBindings.aspectOf(), methodBinding3, null)).isParameterizedType() || ((ReferenceBinding)MethodLocator.declaringClass_aroundBody13$advice(this, methodBinding2 = methodBinding, OwningClassSupportForMethodBindings.aspectOf(), methodBinding2, null)).isRawType()) {
                MethodBinding methodBinding4 = methodBinding;
                ParameterizedTypeBinding parameterizedBinding = (ParameterizedTypeBinding)((ReferenceBinding)MethodLocator.declaringClass_aroundBody15$advice(this, methodBinding4, OwningClassSupportForMethodBindings.aspectOf(), methodBinding4, null));
                if (!(!this.pattern.hasTypeArguments() && this.pattern.hasMethodArguments() || parameterizedBinding.isParameterizedWithOwnVariables())) {
                    this.updateMatch(parameterizedBinding, this.pattern.getTypeArguments(), this.pattern.hasTypeParameters(), 0, locator);
                }
            } else if (this.pattern.hasTypeArguments()) {
                this.match.setRule(16);
            }
            if (this.match.getRule() != 0 && messageSend.resolvedType == null) {
                this.match.setRule(16);
            }
        } else if (methodBinding instanceof ParameterizedMethodBinding) {
            MethodBinding methodBinding5;
            isParameterized = true;
            MethodBinding methodBinding6 = methodBinding;
            if (((ReferenceBinding)MethodLocator.declaringClass_aroundBody17$advice(this, methodBinding6, OwningClassSupportForMethodBindings.aspectOf(), methodBinding6, null)).isParameterizedType() || ((ReferenceBinding)MethodLocator.declaringClass_aroundBody19$advice(this, methodBinding5 = methodBinding, OwningClassSupportForMethodBindings.aspectOf(), methodBinding5, null)).isRawType()) {
                MethodBinding methodBinding7 = methodBinding;
                ParameterizedTypeBinding parameterizedBinding = (ParameterizedTypeBinding)((ReferenceBinding)MethodLocator.declaringClass_aroundBody21$advice(this, methodBinding7, OwningClassSupportForMethodBindings.aspectOf(), methodBinding7, null));
                if (!parameterizedBinding.isParameterizedWithOwnVariables()) {
                    ReferenceBinding refBinding;
                    if ((accuracy & 0xC00) != 0 && (refBinding = this.getMatchingSuper((ReferenceBinding)messageSend.actualReceiverType)) instanceof ParameterizedTypeBinding) {
                        parameterizedBinding = (ParameterizedTypeBinding)refBinding;
                    }
                    if ((accuracy & 0x200) == 0) {
                        this.updateMatch(parameterizedBinding, this.pattern.getTypeArguments(), this.pattern.hasTypeParameters(), 0, locator);
                    }
                }
            } else if (this.pattern.hasTypeArguments()) {
                this.match.setRule(16);
            }
            if (this.match.getRule() != 0 && messageSend.resolvedType == null) {
                this.match.setRule(16);
            }
        } else if (this.pattern.hasMethodArguments()) {
            this.match.setRule(16);
        }
        if (this.match.getRule() == 0) {
            return;
        }
        boolean bl = report = this.isErasureMatch && this.match.isErasure() || this.isEquivalentMatch && this.match.isEquivalent() || this.match.isExact();
        if (!report) {
            return;
        }
        int offset = (int)(messageSend.nameSourcePosition >>> 32);
        this.match.setOffset(offset);
        this.match.setLength(messageSend.sourceEnd - offset + 1);
        if (isParameterized && this.pattern.hasMethodArguments()) {
            locator.reportAccurateParameterizedMethodReference(this.match, messageSend, messageSend.typeArguments);
        } else {
            locator.report(this.match);
        }
    }

    private boolean methodParametersEqualsPattern(MethodBinding method) {
        TypeBinding[] methodParameters = method.parameters;
        int length = methodParameters.length;
        if (length != this.pattern.parameterSimpleNames.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            char[] paramQualifiedName = MethodLocator.qualifiedPattern(this.pattern.parameterSimpleNames[i], this.pattern.parameterQualifications[i]);
            if (!CharOperation.match(paramQualifiedName, methodParameters[i].readableName(), this.isCaseSensitive)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public SearchMatch newDeclarationMatch(ASTNode reference, IJavaElement element, Binding elementBinding, int accuracy, int length, MatchLocator locator) {
        if (elementBinding != null) {
            MethodBinding methodBinding = (MethodBinding)elementBinding;
            if (this.methodDeclarationsWithInvalidParam.containsKey(reference)) {
                Boolean report = (Boolean)this.methodDeclarationsWithInvalidParam.get(reference);
                if (report != null) {
                    if (report.booleanValue()) {
                        return super.newDeclarationMatch(reference, element, elementBinding, accuracy, length, locator);
                    }
                    return null;
                }
                MethodBinding methodBinding2 = methodBinding;
                if (this.matchOverriddenMethod((ReferenceBinding)MethodLocator.declaringClass_aroundBody23$advice(this, methodBinding2, OwningClassSupportForMethodBindings.aspectOf(), methodBinding2, null), methodBinding, null)) {
                    this.methodDeclarationsWithInvalidParam.put(reference, Boolean.TRUE);
                    return super.newDeclarationMatch(reference, element, elementBinding, accuracy, length, locator);
                }
                MethodBinding methodBinding3 = methodBinding;
                if (this.isTypeInSuperDeclaringTypeNames(((ReferenceBinding)MethodLocator.declaringClass_aroundBody25$advice((MethodLocator)this, (MethodBinding)methodBinding3, (OwningClassSupportForMethodBindings)OwningClassSupportForMethodBindings.aspectOf(), (MethodBinding)methodBinding3, null)).compoundName)) {
                    MethodBinding methodBinding4;
                    MethodBinding patternBinding = locator.getMethodBinding(this.pattern);
                    if (patternBinding != null && !this.matchOverriddenMethod((ReferenceBinding)MethodLocator.declaringClass_aroundBody27$advice(this, methodBinding4 = patternBinding, OwningClassSupportForMethodBindings.aspectOf(), methodBinding4, null), patternBinding, methodBinding)) {
                        this.methodDeclarationsWithInvalidParam.put(reference, Boolean.FALSE);
                        return null;
                    }
                    this.methodDeclarationsWithInvalidParam.put(reference, Boolean.TRUE);
                    return super.newDeclarationMatch(reference, element, elementBinding, accuracy, length, locator);
                }
                this.methodDeclarationsWithInvalidParam.put(reference, Boolean.FALSE);
                return null;
            }
        }
        return super.newDeclarationMatch(reference, element, elementBinding, accuracy, length, locator);
    }

    @Override
    protected int referenceType() {
        return 9;
    }

    protected void reportDeclaration(MethodBinding methodBinding, MatchLocator locator, SimpleSet knownMethods) throws CoreException {
        TypeDeclaration typeDecl;
        AbstractMethodDeclaration methodDecl;
        ClassScope scope;
        MethodBinding methodBinding2 = methodBinding;
        ReferenceBinding declaringClass = (ReferenceBinding)MethodLocator.declaringClass_aroundBody29$advice(this, methodBinding2, OwningClassSupportForMethodBindings.aspectOf(), methodBinding2, null);
        IType type = locator.lookupType(declaringClass);
        if (type == null) {
            return;
        }
        if (type.isBinary()) {
            IMethod method = null;
            TypeBinding[] parameters = methodBinding.original().parameters;
            int parameterLength = parameters.length;
            char[][] parameterTypes = new char[parameterLength][];
            int i = 0;
            while (i < parameterLength) {
                char[] typeName = parameters[i].qualifiedSourceName();
                int j = 0;
                int dim = parameters[i].dimensions();
                while (j < dim) {
                    typeName = CharOperation.concat(typeName, new char[]{'[', ']'});
                    ++j;
                }
                parameterTypes[i] = typeName;
                ++i;
            }
            method = locator.createBinaryMethodHandle(type, methodBinding.selector, parameterTypes);
            if (method == null || knownMethods.addIfNotIncluded(method) == null) {
                return;
            }
            IResource resource = type.getResource();
            if (resource == null) {
                resource = type.getJavaProject().getProject();
            }
            IBinaryType info = locator.getBinaryInfo((ClassFile)type.getClassFile(), resource);
            locator.reportBinaryMemberDeclaration(resource, method, methodBinding, info, 0);
            return;
        }
        IResource resource = type.getResource();
        if (declaringClass instanceof ParameterizedTypeBinding) {
            declaringClass = ((ParameterizedTypeBinding)declaringClass).genericType();
        }
        if ((scope = ((SourceTypeBinding)declaringClass).scope) != null && (methodDecl = (typeDecl = scope.referenceContext).declarationOf(methodBinding.original())) != null) {
            String methodName = new String(methodBinding.selector);
            Argument[] arguments = methodDecl.arguments;
            int length = arguments == null ? 0 : arguments.length;
            String[] parameterTypes = new String[length];
            int i = 0;
            while (i < length) {
                char[][] typeName = arguments[i].type.getParameterizedTypeName();
                parameterTypes[i] = Signature.createTypeSignature(CharOperation.concatWith(typeName, '.'), false);
                ++i;
            }
            IMethod method = type.getMethod(methodName, parameterTypes);
            if (method == null || knownMethods.addIfNotIncluded(method) == null) {
                return;
            }
            int offset = methodDecl.sourceStart;
            this.match = new MethodDeclarationMatch(method, 0, offset, methodDecl.sourceEnd - offset + 1, locator.getParticipant(), resource);
            locator.report(this.match);
        }
    }

    @Override
    public int resolveLevel(ASTNode possibleMatchingNode) {
        if (this.pattern.findReferences) {
            if (possibleMatchingNode instanceof MessageSend) {
                return this.resolveLevel((MessageSend)possibleMatchingNode);
            }
            if (possibleMatchingNode instanceof SingleMemberAnnotation) {
                SingleMemberAnnotation annotation = (SingleMemberAnnotation)possibleMatchingNode;
                return this.resolveLevel(annotation.memberValuePairs()[0].binding);
            }
            if (possibleMatchingNode instanceof MemberValuePair) {
                MemberValuePair memberValuePair = (MemberValuePair)possibleMatchingNode;
                return this.resolveLevel(memberValuePair.binding);
            }
            if (possibleMatchingNode instanceof ReferenceExpression) {
                return this.resolveLevel((ReferenceExpression)possibleMatchingNode);
            }
        }
        if (this.pattern.findDeclarations) {
            if (possibleMatchingNode instanceof MethodDeclaration) {
                return this.resolveLevel(((MethodDeclaration)possibleMatchingNode).binding);
            }
            if (possibleMatchingNode instanceof LambdaExpression) {
                return this.resolveLevel(((LambdaExpression)possibleMatchingNode).descriptor);
            }
        }
        return 0;
    }

    @Override
    public int resolveLevel(Binding binding) {
        int n;
        MethodBinding methodBinding;
        boolean subType;
        if (binding == null) {
            return 1;
        }
        if (!(binding instanceof MethodBinding)) {
            return 0;
        }
        MethodBinding method = (MethodBinding)binding;
        boolean skipVerif = this.pattern.findDeclarations && this.mayBeGeneric;
        int methodLevel = this.matchMethod(method, skipVerif);
        if (methodLevel == 0) {
            if (method != method.original()) {
                methodLevel = this.matchMethod(method.original(), skipVerif);
            }
            if (methodLevel == 0) {
                return 0;
            }
            method = method.original();
        }
        if (this.pattern.declaringSimpleName == null && this.pattern.declaringQualification == null) {
            return methodLevel;
        }
        boolean bl = subType = !method.isStatic() && !method.isPrivate();
        if (subType && this.pattern.declaringQualification != null && (ReferenceBinding)MethodLocator.declaringClass_aroundBody31$advice(this, methodBinding = method, OwningClassSupportForMethodBindings.aspectOf(), methodBinding, null) != null) {
            MethodBinding methodBinding2 = method;
            if (((ReferenceBinding)MethodLocator.declaringClass_aroundBody33$advice((MethodLocator)this, (MethodBinding)methodBinding2, (OwningClassSupportForMethodBindings)OwningClassSupportForMethodBindings.aspectOf(), (MethodBinding)methodBinding2, null)).fPackage != null) {
                MethodBinding methodBinding3 = method;
                boolean bl2 = subType = CharOperation.compareWith(this.pattern.declaringQualification, ((ReferenceBinding)MethodLocator.declaringClass_aroundBody35$advice((MethodLocator)this, (MethodBinding)methodBinding3, (OwningClassSupportForMethodBindings)OwningClassSupportForMethodBindings.aspectOf(), (MethodBinding)methodBinding3, null)).fPackage.shortReadableName()) == 0;
            }
        }
        if (subType) {
            MethodBinding methodBinding4 = method;
            MethodBinding methodBinding5 = method;
            n = this.resolveLevelAsSubtype(this.pattern.declaringSimpleName, this.pattern.declaringQualification, (ReferenceBinding)MethodLocator.declaringClass_aroundBody37$advice(this, methodBinding4, OwningClassSupportForMethodBindings.aspectOf(), methodBinding4, null), method.selector, null, ((ReferenceBinding)MethodLocator.declaringClass_aroundBody39$advice(this, methodBinding5, OwningClassSupportForMethodBindings.aspectOf(), methodBinding5, null)).qualifiedPackageName(), method.isDefault());
        } else {
            MethodBinding methodBinding6 = method;
            n = this.resolveLevelForType(this.pattern.declaringSimpleName, this.pattern.declaringQualification, (ReferenceBinding)MethodLocator.declaringClass_aroundBody41$advice(this, methodBinding6, OwningClassSupportForMethodBindings.aspectOf(), methodBinding6, null));
        }
        int declaringLevel = n;
        return (methodLevel & 0xF) > (declaringLevel & 0xF) ? declaringLevel : methodLevel;
    }

    protected int resolveLevel(MessageSend messageSend) {
        int declaringLevel;
        MethodBinding method = messageSend.binding;
        if (method == null) {
            return 1;
        }
        if (messageSend.resolvedType == null) {
            int argLength;
            int n = argLength = messageSend.arguments == null ? 0 : messageSend.arguments.length;
            if (this.pattern.parameterSimpleNames == null || argLength == this.pattern.parameterSimpleNames.length) {
                return 1;
            }
            return 0;
        }
        int methodLevel = this.matchMethod(method, false);
        if (methodLevel == 0) {
            if (method != method.original()) {
                methodLevel = this.matchMethod(method.original(), false);
            }
            if (methodLevel == 0) {
                return 0;
            }
            method = method.original();
        }
        if (this.pattern.declaringSimpleName == null && this.pattern.declaringQualification == null) {
            return methodLevel;
        }
        if (this.isVirtualInvoke(method, messageSend) && messageSend.actualReceiverType instanceof ReferenceBinding) {
            ReferenceBinding methodReceiverType = (ReferenceBinding)messageSend.actualReceiverType;
            declaringLevel = this.resolveLevelAsSubtype(this.pattern.declaringSimpleName, this.pattern.declaringQualification, methodReceiverType, method.selector, method.parameters, methodReceiverType.qualifiedPackageName(), method.isDefault());
            if (declaringLevel == 0) {
                MethodBinding methodBinding = method;
                if ((ReferenceBinding)MethodLocator.declaringClass_aroundBody43$advice(this, methodBinding, OwningClassSupportForMethodBindings.aspectOf(), methodBinding, null) == null || this.allSuperDeclaringTypeNames == null) {
                    declaringLevel = 1;
                } else {
                    char[][][] superTypeNames;
                    char[][][] cArray = superTypeNames = method.isDefault() && this.pattern.focus == null ? this.samePkgSuperDeclaringTypeNames : this.allSuperDeclaringTypeNames;
                    if (superTypeNames != null && this.resolveLevelAsSuperInvocation(methodReceiverType, method.parameters, superTypeNames, true)) {
                        declaringLevel = methodLevel | 0x200;
                    }
                }
            }
            if ((declaringLevel & 0xFFFFFFF0) != 0) {
                return declaringLevel;
            }
        } else {
            MethodBinding methodBinding = method;
            declaringLevel = this.resolveLevelForType(this.pattern.declaringSimpleName, this.pattern.declaringQualification, (ReferenceBinding)MethodLocator.declaringClass_aroundBody45$advice(this, methodBinding, OwningClassSupportForMethodBindings.aspectOf(), methodBinding, null));
        }
        return (methodLevel & 0xF) > (declaringLevel & 0xF) ? declaringLevel : methodLevel;
    }

    protected int resolveLevel(ReferenceExpression referenceExpression) {
        int declaringLevel;
        MethodBinding method = referenceExpression.getMethodBinding();
        if (method == null || !method.isValidBinding()) {
            return 1;
        }
        int methodLevel = this.matchMethod(method, false);
        if (methodLevel == 0) {
            if (method != method.original()) {
                methodLevel = this.matchMethod(method.original(), false);
            }
            if (methodLevel == 0) {
                return 0;
            }
            method = method.original();
        }
        if (this.pattern.declaringSimpleName == null && this.pattern.declaringQualification == null) {
            return methodLevel;
        }
        ReferenceBinding ref = this.checkMethodRef(method, referenceExpression);
        if (ref != null) {
            declaringLevel = this.resolveLevelAsSubtype(this.pattern.declaringSimpleName, this.pattern.declaringQualification, ref, method.selector, method.parameters, ref.qualifiedPackageName(), method.isDefault());
            if (declaringLevel == 0) {
                MethodBinding methodBinding = method;
                if ((ReferenceBinding)MethodLocator.declaringClass_aroundBody47$advice(this, methodBinding, OwningClassSupportForMethodBindings.aspectOf(), methodBinding, null) == null || this.allSuperDeclaringTypeNames == null) {
                    declaringLevel = 1;
                } else {
                    char[][][] superTypeNames;
                    char[][][] cArray = superTypeNames = method.isDefault() && this.pattern.focus == null ? this.samePkgSuperDeclaringTypeNames : this.allSuperDeclaringTypeNames;
                    if (superTypeNames != null && this.resolveLevelAsSuperInvocation(ref, method.parameters, superTypeNames, true)) {
                        declaringLevel = methodLevel | 0x200;
                    }
                }
            }
            if ((declaringLevel & 0xFFFFFFF0) != 0) {
                return declaringLevel;
            }
        } else {
            MethodBinding methodBinding = method;
            declaringLevel = this.resolveLevelForType(this.pattern.declaringSimpleName, this.pattern.declaringQualification, (ReferenceBinding)MethodLocator.declaringClass_aroundBody49$advice(this, methodBinding, OwningClassSupportForMethodBindings.aspectOf(), methodBinding, null));
        }
        return (methodLevel & 0xF) > (declaringLevel & 0xF) ? declaringLevel : methodLevel;
    }

    protected int resolveLevelAsSubtype(char[] simplePattern, char[] qualifiedPattern, ReferenceBinding type, char[] methodName, TypeBinding[] argumentTypes, char[] packageName, boolean isDefault) {
        if (type == null) {
            return 1;
        }
        int level = this.resolveLevelForType(simplePattern, qualifiedPattern, type);
        if (level != 0) {
            MethodBinding method;
            if (isDefault && !CharOperation.equals(packageName, type.qualifiedPackageName())) {
                return 0;
            }
            MethodBinding methodBinding = method = argumentTypes == null ? null : this.getMethodBinding(type, methodName, argumentTypes);
            if (!((method == null || method.isAbstract()) && type.isAbstract() || type.isInterface())) {
                level |= 0x800;
            }
            return level;
        }
        if (!type.isInterface() && !CharOperation.equals(type.compoundName, TypeConstants.JAVA_LANG_OBJECT) && (level = this.resolveLevelAsSubtype(simplePattern, qualifiedPattern, type.superclass(), methodName, argumentTypes, packageName, isDefault)) != 0) {
            MethodBinding method;
            if (argumentTypes != null && (method = this.getMethodBinding(type, methodName, argumentTypes)) != null) {
                if ((level & 0x800) != 0) {
                    return 0;
                }
                if (!method.isAbstract() && !type.isInterface()) {
                    level |= 0x800;
                }
            }
            return level | 0x400;
        }
        ReferenceBinding[] interfaces = type.superInterfaces();
        if (interfaces == null) {
            return 1;
        }
        int i = 0;
        while (i < interfaces.length) {
            level = this.resolveLevelAsSubtype(simplePattern, qualifiedPattern, interfaces[i], methodName, null, packageName, isDefault);
            if (level != 0) {
                if (!type.isAbstract() && !type.isInterface()) {
                    level |= 0x800;
                }
                return level | 0x400;
            }
            ++i;
        }
        return 0;
    }

    private boolean resolveLevelAsSuperInvocation(ReferenceBinding type, TypeBinding[] argumentTypes, char[][][] superTypeNames, boolean methodAlreadyVerified) {
        char[][] compoundName = type.compoundName;
        int i = 0;
        int max = superTypeNames.length;
        while (i < max) {
            if (CharOperation.equals(superTypeNames[i], compoundName)) {
                if (methodAlreadyVerified) {
                    return true;
                }
                MethodBinding[] methods = type.getMethods(this.pattern.selector);
                int j = 0;
                int length = methods.length;
                while (j < length) {
                    MethodBinding method = methods[j];
                    TypeBinding[] parameters = method.parameters;
                    if (argumentTypes.length == parameters.length) {
                        boolean found = true;
                        int k = 0;
                        int l = parameters.length;
                        while (k < l) {
                            if (TypeBinding.notEquals(parameters[k].erasure(), argumentTypes[k].erasure())) {
                                found = false;
                                break;
                            }
                            ++k;
                        }
                        if (found) {
                            return true;
                        }
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        if (type.isInterface()) {
            ReferenceBinding[] interfaces = type.superInterfaces();
            if (interfaces == null) {
                return false;
            }
            int i2 = 0;
            while (i2 < interfaces.length) {
                if (this.resolveLevelAsSuperInvocation(interfaces[i2], argumentTypes, superTypeNames, false)) {
                    return true;
                }
                ++i2;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return "Locator for " + this.pattern.toString();
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody0(MethodLocator methodLocator, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody1$advice(MethodLocator ajc$this, MethodBinding target, OwningClassSupportForMethodBindings ajc$aspectInstance, MethodBinding aBinding, AroundClosure ajc$aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(aBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody2(MethodLocator methodLocator, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody3$advice(MethodLocator ajc$this, MethodBinding target, OwningClassSupportForMethodBindings ajc$aspectInstance, MethodBinding aBinding, AroundClosure ajc$aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(aBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody4(MethodLocator methodLocator, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody5$advice(MethodLocator ajc$this, MethodBinding target, OwningClassSupportForMethodBindings ajc$aspectInstance, MethodBinding aBinding, AroundClosure ajc$aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(aBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody6(MethodLocator methodLocator, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody7$advice(MethodLocator ajc$this, MethodBinding target, OwningClassSupportForMethodBindings ajc$aspectInstance, MethodBinding aBinding, AroundClosure ajc$aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(aBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody8(MethodLocator methodLocator, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody9$advice(MethodLocator ajc$this, MethodBinding target, OwningClassSupportForMethodBindings ajc$aspectInstance, MethodBinding aBinding, AroundClosure ajc$aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(aBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody10(MethodLocator methodLocator, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody11$advice(MethodLocator ajc$this, MethodBinding target, OwningClassSupportForMethodBindings ajc$aspectInstance, MethodBinding aBinding, AroundClosure ajc$aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(aBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody12(MethodLocator methodLocator, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody13$advice(MethodLocator ajc$this, MethodBinding target, OwningClassSupportForMethodBindings ajc$aspectInstance, MethodBinding aBinding, AroundClosure ajc$aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(aBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody14(MethodLocator methodLocator, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody15$advice(MethodLocator ajc$this, MethodBinding target, OwningClassSupportForMethodBindings ajc$aspectInstance, MethodBinding aBinding, AroundClosure ajc$aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(aBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody16(MethodLocator methodLocator, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody17$advice(MethodLocator ajc$this, MethodBinding target, OwningClassSupportForMethodBindings ajc$aspectInstance, MethodBinding aBinding, AroundClosure ajc$aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(aBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody18(MethodLocator methodLocator, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody19$advice(MethodLocator ajc$this, MethodBinding target, OwningClassSupportForMethodBindings ajc$aspectInstance, MethodBinding aBinding, AroundClosure ajc$aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(aBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody20(MethodLocator methodLocator, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody21$advice(MethodLocator ajc$this, MethodBinding target, OwningClassSupportForMethodBindings ajc$aspectInstance, MethodBinding aBinding, AroundClosure ajc$aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(aBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody22(MethodLocator methodLocator, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody23$advice(MethodLocator ajc$this, MethodBinding target, OwningClassSupportForMethodBindings ajc$aspectInstance, MethodBinding aBinding, AroundClosure ajc$aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(aBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody24(MethodLocator methodLocator, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody25$advice(MethodLocator ajc$this, MethodBinding target, OwningClassSupportForMethodBindings ajc$aspectInstance, MethodBinding aBinding, AroundClosure ajc$aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(aBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody26(MethodLocator methodLocator, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody27$advice(MethodLocator ajc$this, MethodBinding target, OwningClassSupportForMethodBindings ajc$aspectInstance, MethodBinding aBinding, AroundClosure ajc$aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(aBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody28(MethodLocator methodLocator, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody29$advice(MethodLocator ajc$this, MethodBinding target, OwningClassSupportForMethodBindings ajc$aspectInstance, MethodBinding aBinding, AroundClosure ajc$aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(aBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody30(MethodLocator methodLocator, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody31$advice(MethodLocator ajc$this, MethodBinding target, OwningClassSupportForMethodBindings ajc$aspectInstance, MethodBinding aBinding, AroundClosure ajc$aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(aBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody32(MethodLocator methodLocator, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody33$advice(MethodLocator ajc$this, MethodBinding target, OwningClassSupportForMethodBindings ajc$aspectInstance, MethodBinding aBinding, AroundClosure ajc$aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(aBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody34(MethodLocator methodLocator, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody35$advice(MethodLocator ajc$this, MethodBinding target, OwningClassSupportForMethodBindings ajc$aspectInstance, MethodBinding aBinding, AroundClosure ajc$aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(aBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody36(MethodLocator methodLocator, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody37$advice(MethodLocator ajc$this, MethodBinding target, OwningClassSupportForMethodBindings ajc$aspectInstance, MethodBinding aBinding, AroundClosure ajc$aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(aBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody38(MethodLocator methodLocator, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody39$advice(MethodLocator ajc$this, MethodBinding target, OwningClassSupportForMethodBindings ajc$aspectInstance, MethodBinding aBinding, AroundClosure ajc$aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(aBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody40(MethodLocator methodLocator, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody41$advice(MethodLocator ajc$this, MethodBinding target, OwningClassSupportForMethodBindings ajc$aspectInstance, MethodBinding aBinding, AroundClosure ajc$aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(aBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody42(MethodLocator methodLocator, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody43$advice(MethodLocator ajc$this, MethodBinding target, OwningClassSupportForMethodBindings ajc$aspectInstance, MethodBinding aBinding, AroundClosure ajc$aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(aBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody44(MethodLocator methodLocator, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody45$advice(MethodLocator ajc$this, MethodBinding target, OwningClassSupportForMethodBindings ajc$aspectInstance, MethodBinding aBinding, AroundClosure ajc$aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(aBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody46(MethodLocator methodLocator, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody47$advice(MethodLocator ajc$this, MethodBinding target, OwningClassSupportForMethodBindings ajc$aspectInstance, MethodBinding aBinding, AroundClosure ajc$aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(aBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody48(MethodLocator methodLocator, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody49$advice(MethodLocator ajc$this, MethodBinding target, OwningClassSupportForMethodBindings ajc$aspectInstance, MethodBinding aBinding, AroundClosure ajc$aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(aBinding);
    }
}

