/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.aspectj.asm.IProgramElement;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.ReflectionUtils;
import org.eclipse.ajdt.core.javaelements.IntertypeElement;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.ajdt.internal.ui.refactoring.RippleMethodFinder2;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.jdt.core.search.FieldDeclarationMatch;
import org.eclipse.jdt.core.search.FieldReferenceMatch;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.MethodDeclarationMatch;
import org.eclipse.jdt.core.search.MethodReferenceMatch;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CollectingSearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.CuCollectingSearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.ReferencesInBinaryContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class ITDRenameRefactoringProcessor
extends JavaRenameProcessor {
    public static final String REFACTORING_ID = "org.eclipse.ajdt.ui.renameITD";
    private IntertypeElement itd;
    private Set<IMember> elementsToRename;
    private IProgramElement.Kind itdKind;
    private IMember mockElement;
    private String qualifier;
    private TextChangeManager changeManager;
    private boolean updateReferences;
    private SearchResultGroup[] references;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_5;

    public ITDRenameRefactoringProcessor(IntertypeElement itd, RefactoringStatus status) {
        this.itd = itd;
        this.changeManager = new TextChangeManager(true);
        this.updateReferences = true;
        try {
            this.itdKind = itd.getAJKind();
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            status.merge(RefactoringStatus.createFatalErrorStatus((String)"Problem accessing the AspectJ model", (RefactoringStatusContext)this.createErrorContext()));
        }
    }

    public ITDRenameRefactoringProcessor(JavaRefactoringArguments arguments, RefactoringStatus status) {
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
        this.changeManager = new TextChangeManager(true);
        try {
            this.itdKind = this.itd.getAJKind();
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
            status.merge(RefactoringStatus.createFatalErrorStatus((String)"Problem accessing the AspectJ model", (RefactoringStatusContext)this.createErrorContext()));
        }
    }

    private RefactoringStatus initialize(JavaRefactoringArguments extended) {
        IJavaElement element;
        String handle = extended.getAttribute("input");
        if (handle != null) {
            element = JavaRefactoringDescriptorUtil.handleToElement((String)extended.getProject(), (String)handle, (boolean)false);
            if (element == null || !element.exists() || !(element instanceof IntertypeElement)) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus((Object)element, (String)this.getProcessorName(), (String)"org.eclipse.jdt.ui.rename.field");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"input"));
        }
        this.itd = (IntertypeElement)element;
        String name = extended.getAttribute("name");
        if (name == null || "".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"name"));
        }
        this.setNewElementName(name);
        String references = extended.getAttribute("references");
        if (references == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"references"));
        }
        this.updateReferences = Boolean.valueOf(references);
        return new RefactoringStatus();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        this.checkCanceled(pm);
        this.mockElement = this.itd.createMockDeclaration();
        if (this.mockElement == null) {
            return RefactoringStatus.createFatalErrorStatus((String)"AspectJ model not available for this ITD, do a full project build and try again.", (RefactoringStatusContext)this.createErrorContext());
        }
        this.qualifier = this.itd.getElementName().substring(0, this.itd.getElementName().length() - this.mockElement.getElementName().length());
        if (this.qualifier == null || this.qualifier.length() == 0) {
            return RefactoringStatus.createFatalErrorStatus((String)"Invalid ITD qualifier", (RefactoringStatusContext)this.createErrorContext());
        }
        RefactoringStatus result = Checks.checkAvailability((IJavaElement)this.itd);
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(Checks.checkIfCuBroken((IMember)this.itd));
        this.checkCanceled(pm);
        return result;
    }

    private RefactoringStatusContext createErrorContext() {
        return JavaStatusContext.create((IMember)this.itd);
    }

    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        try {
            pm.beginTask("", 18);
            pm.setTaskName(RefactoringCoreMessages.RenameFieldRefactoring_checking);
            RefactoringStatus result = new RefactoringStatus();
            result.merge(Checks.checkIfCuBroken((IMember)this.itd));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            this.checkCanceled(pm);
            result.merge(this.checkNewElementName(this.getNewElementName()));
            pm.worked(1);
            if (this.itdKind == IProgramElement.Kind.INTER_TYPE_FIELD) {
                result.merge(this.checkEnclosingHierarchy((IField)this.mockElement));
                result.merge(this.checkNestedHierarchy(this.mockElement.getDeclaringType()));
            }
            this.checkCanceled(pm);
            pm.worked(1);
            pm.worked(1);
            if (this.updateReferences) {
                pm.setTaskName(RefactoringCoreMessages.RenameFieldRefactoring_searching);
                this.references = this.getOccurrences((IProgressMonitor)new SubProgressMonitor(pm, 3), result);
                pm.setTaskName(RefactoringCoreMessages.RenameFieldRefactoring_checking);
            } else {
                this.references = new SearchResultGroup[0];
                pm.worked(3);
            }
            this.checkCanceled(pm);
            if (this.updateReferences) {
                result.merge(this.analyzeAffectedCompilationUnits());
                result.merge(this.checkRelatedElements());
            } else {
                Checks.checkCompileErrorsInAffectedFile((RefactoringStatus)result, (IResource)this.itd.getResource());
            }
            this.checkCanceled(pm);
            result.merge(this.createChanges((IProgressMonitor)new SubProgressMonitor(pm, 10)));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private RefactoringStatus createChanges(IProgressMonitor pm) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.RenameFieldRefactoring_checking, 10);
        RefactoringStatus result = new RefactoringStatus();
        this.changeManager.clear();
        this.addOccurrenceUpdates((IProgressMonitor)new SubProgressMonitor(pm, 1));
        if (result.hasFatalError()) {
            return result;
        }
        pm.done();
        return result;
    }

    private void addDeclarationUpdate(IMember member) throws CoreException {
        ISourceRange nameRange = member.getNameRange();
        ReplaceEdit textEdit = new ReplaceEdit(nameRange.getOffset(), nameRange.getLength(), this.extractRawITDName(this.getNewElementName()));
        ICompilationUnit cu = member.getCompilationUnit();
        String groupName = this.itdKind == IProgramElement.Kind.INTER_TYPE_FIELD ? RefactoringCoreMessages.RenameFieldRefactoring_Update_field_declaration : RefactoringCoreMessages.RenameMethodRefactoring_update_declaration;
        this.addTextEdit(this.changeManager.get(cu), groupName, (TextEdit)textEdit);
    }

    private void addTextEdit(TextChange change, String groupName, TextEdit textEdit) {
        TextChangeCompatibility.addTextEdit((TextChange)change, (String)groupName, (TextEdit)textEdit);
    }

    private SearchResultGroup[] getOccurrences(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        String binaryRefsDescription = Messages.format((String)RefactoringCoreMessages.ReferencesInBinaryContext_ref_in_binaries_description, (Object)BasicElementLabels.getJavaElementName((String)this.getCurrentElementName()));
        ReferencesInBinaryContext binaryRefs = new ReferencesInBinaryContext(binaryRefsDescription);
        this.initializeElementsToRename((IProgressMonitor)new SubProgressMonitor(pm, 1), binaryRefs);
        pm.setTaskName(RefactoringCoreMessages.RenameMethodRefactoring_taskName_searchingForReferences);
        SearchResultGroup[] result = RefactoringSearchEngine.search((SearchPattern)this.createSearchPattern(), (IJavaSearchScope)this.createRefactoringScope(), (CollectingSearchRequestor)new CuCollectingSearchRequestor(binaryRefs), (IProgressMonitor)pm, (RefactoringStatus)status);
        binaryRefs.addErrorIfNecessary(status);
        return result;
    }

    private RefactoringStatus checkRelatedElements() throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        if (this.itdKind == IProgramElement.Kind.INTER_TYPE_FIELD) {
            return result;
        }
        for (IMember member : this.elementsToRename) {
            if (!(member instanceof IMethod)) {
                result.merge(RefactoringStatus.createErrorStatus((String)"Related element is not a method.", (RefactoringStatusContext)JavaStatusContext.create((IMember)member)));
            }
            IMethod method = (IMethod)member;
            result.merge(Checks.checkIfConstructorName((IMethod)method, (String)this.getNewElementName(), (String)method.getDeclaringType().getElementName()));
            Object[] msgData = new String[]{BasicElementLabels.getJavaElementName((String)method.getElementName()), BasicElementLabels.getJavaElementName((String)method.getDeclaringType().getFullyQualifiedName('.'))};
            if (!method.exists()) {
                result.addFatalError(Messages.format((String)RefactoringCoreMessages.RenameMethodRefactoring_not_in_model, (Object[])msgData));
                continue;
            }
            if (method.isBinary()) {
                result.addFatalError(Messages.format((String)RefactoringCoreMessages.RenameMethodRefactoring_no_binary, (Object[])msgData));
            }
            if (method.isReadOnly()) {
                result.addFatalError(Messages.format((String)RefactoringCoreMessages.RenameMethodRefactoring_no_read_only, (Object[])msgData));
            }
            if (!JdtFlags.isNative((IMember)method)) continue;
            result.addError(Messages.format((String)RefactoringCoreMessages.RenameMethodRefactoring_no_native_1, (Object[])msgData));
        }
        return result;
    }

    private IJavaSearchScope createRefactoringScope() throws CoreException {
        return RefactoringScopeFactory.create((IJavaElement)this.itd, (boolean)true, (boolean)false);
    }

    private SearchPattern createSearchPattern() {
        HashSet<IMember> members = new HashSet<IMember>(this.elementsToRename);
        IMember[] ms = (IMember[])members.toArray(new IMethod[members.size()]);
        return RefactoringSearchEngine.createOrPattern((IJavaElement[])ms, (int)3);
    }

    private void addOccurrenceUpdates(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", this.references.length);
        String editName = this.itdKind == IProgramElement.Kind.INTER_TYPE_FIELD ? RefactoringCoreMessages.RenameFieldRefactoring_Update_field_reference : RefactoringCoreMessages.RenameMethodRefactoring_update_occurrence;
        int i = 0;
        while (i < this.references.length) {
            ICompilationUnit cu = this.references[i].getCompilationUnit();
            if (cu != null) {
                SearchMatch[] matches = this.references[i].getSearchResults();
                int j = 0;
                while (j < matches.length) {
                    if (matches[j] instanceof MethodReferenceMatch) {
                        this.addTextEdit(this.changeManager.get(cu), editName, this.createTextChange(matches[j]));
                    } else if (matches[j] instanceof MethodDeclarationMatch) {
                        this.addDeclarationUpdate((IMember)matches[j].getElement());
                    } else if (matches[j] instanceof FieldReferenceMatch) {
                        this.addTextEdit(this.changeManager.get(cu), editName, this.createTextChange(matches[j]));
                    } else if (matches[j] instanceof FieldDeclarationMatch) {
                        this.addDeclarationUpdate((IMember)matches[j].getElement());
                    }
                    pm.worked(1);
                    ++j;
                }
            }
            ++i;
        }
    }

    private TextEdit createTextChange(SearchMatch match) {
        String rawITDName = this.extractRawITDName(this.itd.getElementName());
        return new ReplaceEdit(match.getOffset(), rawITDName.length(), this.extractRawITDName(this.getNewElementName()));
    }

    private RefactoringStatus analyzeAffectedCompilationUnits() throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        this.references = Checks.excludeCompilationUnits((SearchResultGroup[])this.references, (RefactoringStatus)result);
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(Checks.checkCompileErrorsInAffectedFiles((SearchResultGroup[])this.references));
        return result;
    }

    private RefactoringStatus checkNestedHierarchy(IType type) throws CoreException {
        IType[] nestedTypes = type.getTypes();
        if (nestedTypes == null) {
            return null;
        }
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < nestedTypes.length) {
            IField otherField = nestedTypes[i].getField(this.getNewElementName());
            if (otherField.exists()) {
                String msg = Messages.format((String)RefactoringCoreMessages.RenameFieldRefactoring_hiding, (Object[])new String[]{BasicElementLabels.getJavaElementName((String)this.itd.getElementName()), BasicElementLabels.getJavaElementName((String)this.getNewElementName()), BasicElementLabels.getJavaElementName((String)nestedTypes[i].getFullyQualifiedName('.'))});
                result.addWarning(msg, JavaStatusContext.create((IMember)otherField));
            }
            result.merge(this.checkNestedHierarchy(nestedTypes[i]));
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkEnclosingHierarchy(IField field) {
        IType current = field.getDeclaringType();
        if (Checks.isTopLevel((IType)current)) {
            return null;
        }
        RefactoringStatus result = new RefactoringStatus();
        while (current != null) {
            IField otherField = current.getField(this.getNewElementName());
            if (otherField.exists()) {
                String msg = Messages.format((String)RefactoringCoreMessages.RenameFieldRefactoring_hiding2, (Object[])new String[]{BasicElementLabels.getJavaElementName((String)this.getNewElementName()), BasicElementLabels.getJavaElementName((String)current.getFullyQualifiedName('.')), BasicElementLabels.getJavaElementName((String)otherField.getElementName())});
                result.addWarning(msg, JavaStatusContext.create((IMember)otherField));
            }
            current = current.getDeclaringType();
        }
        return result;
    }

    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        RefactoringStatus status = new RefactoringStatus();
        status.merge(this.checkITDQualifier(newName));
        if (status.getSeverity() != 0) {
            return status;
        }
        if (Checks.isAlreadyNamed((IJavaElement)this.itd, (String)newName)) {
            status.addFatalError(RefactoringCoreMessages.RenameMethodRefactoring_same_name, this.createErrorContext());
        }
        String rawName = this.extractRawITDName(newName);
        status.merge(Checks.checkName((String)rawName, (IStatus)JavaConventionsUtil.validateMethodName((String)rawName, (IJavaElement)this.itd)));
        if (status.isOK() && !Checks.startsWithLowerCase((String)rawName)) {
            status = RefactoringStatus.createWarningStatus((String)RefactoringCoreMessages.Checks_method_names_lowercase);
        }
        if (this.itdKind == IProgramElement.Kind.INTER_TYPE_FIELD && this.mockElement.getDeclaringType().getField(rawName).exists()) {
            status.addError(RefactoringCoreMessages.RenameFieldRefactoring_field_already_defined, JavaStatusContext.create((IMember)this.mockElement.getDeclaringType().getField(rawName)));
        }
        return status;
    }

    private String extractRawITDName(String newName) {
        String[] split = newName.split("\\.");
        return split.length > 1 ? split[split.length - 1] : newName;
    }

    private RefactoringStatus checkITDQualifier(String newName) {
        if (!newName.startsWith(this.qualifier)) {
            return RefactoringStatus.createFatalErrorStatus((String)"ITD qualifier may not be changed during rename.", (RefactoringStatusContext)this.createErrorContext());
        }
        return new RefactoringStatus();
    }

    protected RenameModifications computeRenameModifications() throws CoreException {
        RenameModifications result = new RenameModifications();
        RenameArguments args = new RenameArguments(this.getNewElementName(), this.getUpdateReferences());
        for (IMember element : this.elementsToRename) {
            if (element instanceof IMethod) {
                result.rename((IMethod)element, args);
                continue;
            }
            if (!(element instanceof IField)) continue;
            result.rename((IField)element, args);
        }
        return result;
    }

    private void initializeElementsToRename(IProgressMonitor pm, ReferencesInBinaryContext binaryRefs) throws CoreException {
        if (this.elementsToRename == null && this.itdKind == IProgramElement.Kind.INTER_TYPE_METHOD) {
            IMethod[] rippleMethods = RippleMethodFinder2.getRelatedMethods((IMethod)this.itd, binaryRefs, pm, null);
            this.elementsToRename = new HashSet<IMethod>(Arrays.asList(rippleMethods));
            this.elementsToRename.add((IMember)this.itd);
        } else {
            this.elementsToRename = Collections.singleton(this.itd);
        }
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.itd);
    }

    protected IFile[] getChangedFiles() throws CoreException {
        return ResourceUtil.getFiles((ICompilationUnit[])this.changeManager.getAllCompilationUnits());
    }

    public int getSaveMode() {
        return 4;
    }

    private void checkCanceled(IProgressMonitor pm) {
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        try {
            TextChange[] changes = this.changeManager.getAllChanges();
            ArrayList<TextChange> list = new ArrayList<TextChange>(changes.length);
            list.addAll(Arrays.asList(changes));
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange((JavaRefactoringDescriptor)this.createDescriptor(), "Rename Intertype Declaration", list.toArray(new Change[list.size()]));
            return dynamicValidationRefactoringChange;
        }
        finally {
            pm.done();
        }
    }

    private RenameJavaElementDescriptor createDescriptor() {
        String project = null;
        IJavaProject javaProject = this.itd.getJavaProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        int flags = 2;
        try {
            if (!Flags.isPrivate((int)this.itd.getFlags())) {
                flags |= 4;
            }
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_5);
        }
        String description = Messages.format((String)"Rename intertype declaration ''{0}''", (Object)BasicElementLabels.getJavaElementName((String)this.itd.getElementName()));
        String header = Messages.format((String)"Rename intertype declaration ''{0}'' to ''{1}''", (Object[])new String[]{JavaElementLabels.getTextLabel((Object)this.itd, (long)JavaElementLabels.ALL_FULLY_QUALIFIED), BasicElementLabels.getJavaElementName((String)this.getNewElementName())});
        String comment = new JDTRefactoringDescriptorComment(project, (Object)this, header).asString();
        RenameJavaElementDescriptor descriptor = RefactoringSignatureDescriptorFactory.createRenameJavaElementDescriptor((String)"org.eclipse.jdt.ui.rename.method");
        ReflectionUtils.setPrivateField(RefactoringDescriptor.class, (String)"fRefactoringId", (Object)descriptor, (Object)REFACTORING_ID);
        descriptor.setProject(project);
        descriptor.setDescription(description);
        descriptor.setComment(comment);
        descriptor.setFlags(flags);
        descriptor.setJavaElement((IJavaElement)this.itd);
        descriptor.setNewName(this.getNewElementName());
        descriptor.setUpdateReferences(this.updateReferences);
        return descriptor;
    }

    public Object[] getElements() {
        return new Object[]{this.itd};
    }

    public String getIdentifier() {
        return "org.eclipse.ajdt.ui.refactoring.rename.itd";
    }

    public String getProcessorName() {
        return "Rename an Intertype Declaration";
    }

    public boolean isApplicable() throws CoreException {
        return this.itdKind == IProgramElement.Kind.INTER_TYPE_FIELD || this.itdKind == IProgramElement.Kind.INTER_TYPE_METHOD;
    }

    public String getCurrentElementName() {
        return this.itd.getElementName();
    }

    public Object getNewElement() throws CoreException {
        return new Object[]{IntertypeElement.create((char)this.itd.getJemDelimeter(), (JavaElement)((JavaElement)this.itd.getParent()), (String)this.getNewElementName(), (String[])this.itd.getParameterTypes())};
    }

    public final void setUpdateReferences(boolean update) {
        this.updateReferences = update;
    }

    public boolean getUpdateReferences() {
        return this.updateReferences;
    }

    static {
        ITDRenameRefactoringProcessor.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ITDRenameRefactoringProcessor.java", ITDRenameRefactoringProcessor.class);
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.ITDRenameRefactoringProcessor", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 125);
        ajc$tjp_1 = factory.makeESJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.eclipse.ajdt.internal.ui.refactoring.ITDRenameRefactoringProcessor", "org.eclipse.ajdt.core.javaelements.IntertypeElement:org.eclipse.ltk.core.refactoring.RefactoringStatus", "itd:status", ""), 119);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.ITDRenameRefactoringProcessor", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 137);
        ajc$tjp_3 = factory.makeESJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.eclipse.ajdt.internal.ui.refactoring.ITDRenameRefactoringProcessor", "org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments:org.eclipse.ltk.core.refactoring.RefactoringStatus", "arguments:status", ""), 130);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.ITDRenameRefactoringProcessor", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 549);
        ajc$tjp_5 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "createDescriptor", "org.eclipse.ajdt.internal.ui.refactoring.ITDRenameRefactoringProcessor", "", "", "", "org.eclipse.jdt.core.refactoring.descriptors.RenameJavaElementDescriptor"), 540);
    }
}

