/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.efs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.efs.EgitFileSystem;
import org.eclipse.jgit.lib.Repository;

public enum HiddenResources {
    INSTANCE;

    private static final String PROJECT_NAME = ".org.eclipse.egit.core.cmp";
    private static final String SRC_FOLDER_PREFIX = "src";
    private static final String PROJECT_FILE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>.org.eclipse.egit.core.cmp</name>\n\t<comment></comment>\n\t<projects>\n\t</projects>\n\t<buildSpec>\n\t</buildSpec>\n\t<natures>\n\t</natures>\n</projectDescription>";
    private boolean initialized;
    private final Object lock = new Object();

    public IFile createFile(URI uri, String name, Charset encoding, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        IProject project = this.getHiddenProject((IProgressMonitor)progress.newChild(1));
        this.initialize((IProgressMonitor)progress.newChild(1));
        IResource[] children = project.members();
        progress.setWorkRemaining(children.length + 2);
        IResource[] iResourceArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IResource rsc = iResourceArray[n2];
            if (rsc.getType() == 2) {
                try {
                    return this.linkFile((IFolder)rsc, uri, name, encoding, (IProgressMonitor)progress.newChild(1));
                }
                catch (CoreException coreException) {
                }
            } else {
                progress.worked(1);
            }
            ++n2;
        }
        IFolder newFolder = this.createFolder(project, children.length, (IProgressMonitor)progress.newChild(1));
        return this.linkFile(newFolder, uri, name, encoding, (IProgressMonitor)progress.newChild(1));
    }

    public void initialize(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        try {
            IProject project = this.getHiddenProject((IProgressMonitor)progress.newChild(1));
            this.initialize(project, (IProgressMonitor)progress.newChild(1));
        }
        catch (CoreException e) {
            Activator.logWarning("Cannot clean up internal hidden project", e);
        }
    }

    private synchronized void initialize(IProject project, IProgressMonitor monitor) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        IWorkspaceRunnable clean = m -> {
            IResource[] resources = project.members();
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)m, (int)resources.length);
            IResource[] iResourceArray = project.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource rsc = iResourceArray[n2];
                if (rsc.getType() == 2) {
                    IResource[] children = ((IFolder)rsc).members();
                    SubMonitor sub = SubMonitor.convert((IProgressMonitor)progress.newChild(1), (int)children.length);
                    IResource[] iResourceArray2 = children;
                    int n3 = children.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IResource f = iResourceArray2[n4];
                        if (f.isLinked()) {
                            try {
                                f.delete(true, (IProgressMonitor)sub.newChild(1));
                            }
                            catch (CoreException e) {
                                Activator.logWarning(MessageFormat.format("Cannot clean up internal hidden resource {}", f), e);
                            }
                        }
                        if (sub.isCanceled()) {
                            return;
                        }
                        ++n4;
                    }
                    children = ((IFolder)rsc).members();
                    if (children.length == 0) {
                        try {
                            rsc.delete(true, null);
                        }
                        catch (CoreException e) {
                            Activator.logWarning(MessageFormat.format("Cannot clean up internal hidden folder {}", rsc), e);
                        }
                    }
                } else {
                    progress.worked(1);
                }
                if (progress.isCanceled()) {
                    return;
                }
                ++n2;
            }
        };
        try {
            project.getWorkspace().run(clean, null, 1, monitor);
        }
        catch (CoreException e) {
            Activator.logWarning(MessageFormat.format("Cannot clean up internal hidden project {}", project), e);
        }
    }

    public boolean isHiddenProject(IResource resource) {
        if (resource.getType() != 4) {
            return false;
        }
        return PROJECT_NAME.equals(resource.getName());
    }

    public Repository getRepository(URI uri) {
        if (!"egit-internal".equals(uri.getScheme())) {
            return null;
        }
        try {
            return EgitFileSystem.UriComponents.parse(uri).getRepository();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public String getGitPath(URI uri) {
        if (!"egit-internal".equals(uri.getScheme())) {
            return null;
        }
        try {
            return EgitFileSystem.UriComponents.parse(uri).getGitPath();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public String getGitPath(URI uri, Repository repository) {
        if (!"egit-internal".equals(uri.getScheme())) {
            return null;
        }
        try {
            EgitFileSystem.UriComponents parsed = EgitFileSystem.UriComponents.parse(uri);
            if (parsed.getRepoDir().equals(repository.getDirectory())) {
                return parsed.getGitPath();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    private IProject getHiddenProject(IProgressMonitor monitor) throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        if (!project.isAccessible()) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            if (!project.exists()) {
                this.createProject(project, (IProgressMonitor)progress.newChild(1));
            }
            progress.setWorkRemaining(1);
            this.openProject(project, (IProgressMonitor)progress.newChild(1));
        }
        return project;
    }

    private void createProject(IProject project, IProgressMonitor monitor) throws CoreException {
        IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
        IPath stateLocation = Activator.getDefault().getStateLocation();
        desc.setLocation(stateLocation.append(PROJECT_NAME));
        project.create(desc, 4096, monitor);
    }

    private void openProject(IProject project, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            project.open((IProgressMonitor)progress.newChild(1));
        }
        catch (CoreException e) {
            progress.setWorkRemaining(3);
            if (e.getStatus().getCode() == 567) {
                project.delete(false, true, (IProgressMonitor)progress.newChild(1));
                this.createProject(project, (IProgressMonitor)progress.newChild(1));
            } else {
                IPath stateLocation = Activator.getDefault().getStateLocation();
                IPath projectPath = stateLocation.append(PROJECT_NAME);
                File directory = projectPath.toFile();
                try {
                    if (!directory.mkdirs() && !directory.isDirectory()) {
                        throw new FileNotFoundException();
                    }
                    Files.write(projectPath.append(".project").toFile().toPath(), PROJECT_FILE.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    progress.worked(2);
                }
                catch (IOException ioe) {
                    project.delete(true, true, (IProgressMonitor)progress.newChild(1));
                    this.createProject(project, (IProgressMonitor)progress.newChild(1));
                }
            }
            project.open((IProgressMonitor)progress.newChild(1));
        }
    }

    private IFolder createFolder(IProject project, int n, IProgressMonitor monitor) throws CoreException {
        IFolder folder = project.getFolder(SRC_FOLDER_PREFIX + n);
        folder.create(0, true, monitor);
        return folder;
    }

    private IFile linkFile(IFolder folder, URI uri, String name, Charset encoding, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IFile file = folder.getFile(name);
        this.linkFile(file, uri, (IProgressMonitor)progress.newChild(1));
        if (encoding != null) {
            file.setCharset(encoding.name(), (IProgressMonitor)progress.newChild(1));
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void linkFile(IFile file, URI uri, IProgressMonitor monitor) throws CoreException {
        Object object = this.lock;
        synchronized (object) {
            boolean linkingDisabled = Platform.getPreferencesService().getBoolean("org.eclipse.core.resources", "description.disableLinking", false, null);
            IEclipsePreferences prefs = null;
            IEclipsePreferences.IPreferenceChangeListener listener = null;
            AtomicBoolean prefChanged = new AtomicBoolean();
            if (linkingDisabled) {
                prefs = InstanceScope.INSTANCE.getNode("org.eclipse.core.resources");
                prefs.putBoolean("description.disableLinking", false);
                listener = event -> {
                    if ("description.disableLinking".equals(event.getKey())) {
                        prefChanged.set(true);
                    }
                };
                prefs.addPreferenceChangeListener(listener);
            }
            try {
                file.createLink(uri, 0, monitor);
            }
            catch (Throwable throwable) {
                if (prefs != null) {
                    prefs.removePreferenceChangeListener(listener);
                    if (!prefChanged.get()) {
                        prefs.putBoolean("description.disableLinking", linkingDisabled);
                    }
                }
                throw throwable;
            }
            if (prefs != null) {
                prefs.removePreferenceChangeListener(listener);
                if (!prefChanged.get()) {
                    prefs.putBoolean("description.disableLinking", linkingDisabled);
                }
            }
        }
    }
}

