/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import org.eclipse.emf.diffmerge.generic.api.IMatch;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.scopes.IEditableTreeDataScope;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.util.UIUtil;
import org.eclipse.emf.diffmerge.ui.viewers.DefaultUserProperties;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.FeaturesViewer;
import org.eclipse.emf.diffmerge.ui.viewers.HeaderViewer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class EnhancedFeaturesViewer
extends HeaderViewer<FeaturesViewer> {
    protected final IPropertyChangeListener _inputPropertyChangeListener = this.createInputPropertyChangeListener();

    public EnhancedFeaturesViewer(Composite parent_p) {
        this.createControls(parent_p);
    }

    @Override
    protected Label createImageLabel(Composite parent_p) {
        return null;
    }

    @Override
    protected FeaturesViewer createInnerViewer(Composite parent_p) {
        return new FeaturesViewer(parent_p);
    }

    protected IPropertyChangeListener createInputPropertyChangeListener() {
        return new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                if (DefaultUserProperties.P_TECHNICAL_LABELS.matches(event_p)) {
                    EnhancedFeaturesViewer.this.updateTextLabel();
                }
            }
        };
    }

    @Override
    protected Label createTextLabel(Composite parent_p) {
        Label result = super.createTextLabel(parent_p);
        result.setFont(UIUtil.getBold(result.getFont()));
        result.setText(this.getDefaultText());
        return result;
    }

    protected String getContextualText(FeaturesViewer.FeaturesInput input_p) {
        String formattedTypeText;
        Object element = this.getDrivingElement(input_p);
        boolean useTechnicalLabels = input_p.getContext().isUserPropertyTrue(DefaultUserProperties.P_TECHNICAL_LABELS);
        if (element instanceof EObject) {
            if (useTechnicalLabels) {
                EClass type = ((EObject)element).eClass();
                formattedTypeText = String.valueOf(type.getEPackage().getName()) + '.' + type.getName();
            } else {
                formattedTypeText = UIUtil.getFormattedTypeText((EObject)element);
            }
        } else {
            EMFDiffNode node = input_p.getContext();
            IEditableTreeDataScope drivingScope = node.getActualComparison().getScope(node.getDrivingRole());
            Object type = drivingScope.mGetType(element);
            ILabelProvider labelProvider = this.getLabelProvider();
            formattedTypeText = labelProvider.getText(type);
        }
        String result = String.format(Messages.EnhancedFeaturesViewer_DetailsWithSelection, formattedTypeText);
        return result;
    }

    protected String getDefaultText() {
        return Messages.ComparisonViewer_Details;
    }

    protected Object getDrivingElement(FeaturesViewer.FeaturesInput input_p) {
        Role drivingRole;
        IMatch<?> match = input_p.getMatch();
        Object element = match.get(drivingRole = input_p.getContext().getDrivingRole());
        if (element == null) {
            element = match.get(drivingRole.opposite());
        }
        return element;
    }

    @Override
    public FeaturesViewer.FeaturesInput getInput() {
        return (FeaturesViewer.FeaturesInput)super.getInput();
    }

    @Override
    protected void inputChanged(Object input_p, Object oldInput_p) {
        super.inputChanged(input_p, oldInput_p);
        if (oldInput_p instanceof FeaturesViewer.FeaturesInput) {
            ((FeaturesViewer.FeaturesInput)oldInput_p).getContext().removeUserPropertyChangeListener(DefaultUserProperties.P_TECHNICAL_LABELS, this._inputPropertyChangeListener);
        }
        if (input_p instanceof FeaturesViewer.FeaturesInput) {
            ((FeaturesViewer.FeaturesInput)input_p).getContext().addUserPropertyChangeListener(DefaultUserProperties.P_TECHNICAL_LABELS, this._inputPropertyChangeListener);
        }
        this.updateTextLabel();
    }

    protected void updateTextLabel() {
        Label textLabel = this.getTextLabel();
        if (textLabel != null && !textLabel.isDisposed()) {
            FeaturesViewer.FeaturesInput input = this.getInput();
            String newText = input != null ? this.getContextualText(input) : this.getDefaultText();
            textLabel.setText(newText);
        }
    }
}

