/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.dsl.debug.ide.sirius.ui.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.ExceptionHandler;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.AbstractTransactionalCommandStack;
import org.eclipse.gemoc.dsl.debug.StackFrame;
import org.eclipse.gemoc.dsl.debug.ide.DSLBreakpoint;
import org.eclipse.gemoc.dsl.debug.ide.adapter.IDSLCurrentInstructionListener;
import org.eclipse.gemoc.dsl.debug.ide.sirius.ui.DebugSiriusIdeUiPlugin;
import org.eclipse.gemoc.trace.commons.model.trace.MSEOccurrence;
import org.eclipse.gemoc.trace.commons.model.trace.ParallelStep;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.dialect.command.RefreshRepresentationsCommand;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;

public abstract class AbstractDSLDebuggerServices {
    public static final BreakpointListener LISTENER = new BreakpointListener();
    private static final Map<URI, Set<DSLBreakpoint>> BREAKPOINTS = new HashMap<URI, Set<DSLBreakpoint>>();
    private static final Map<StackFrame, Set<URI>> CURRENT_INSTRUCTIONS_PER_FRAME = new HashMap<StackFrame, Set<URI>>();

    public AbstractDSLDebuggerServices() {
        for (StringCouple couple : this.getRepresentationRefreshList()) {
            if (couple.getSecond() != null) {
                LISTENER.addRepresentationToRefresh(this.getModelIdentifier(), couple.getFirst(), couple.getSecond());
                continue;
            }
            LISTENER.addRepresentationToRefresh(this.getModelIdentifier(), couple.getFirst());
        }
    }

    protected abstract List<StringCouple> getRepresentationRefreshList();

    public boolean hasBreakpoint(EObject instruction) {
        Set<DSLBreakpoint> brkps = this.getBreakpoints(instruction);
        return brkps != null && brkps.size() != 0;
    }

    public boolean hasEnabledBreakpoint(EObject instruction) {
        boolean res = false;
        Set<DSLBreakpoint> brkps = this.getBreakpoints(instruction);
        if (brkps != null && brkps.size() != 0) {
            for (DSLBreakpoint breakpoint : brkps) {
                try {
                    if (!breakpoint.isEnabled()) continue;
                    res = true;
                    break;
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
        return res;
    }

    public boolean hasDisabledBreakpoint(EObject instruction) {
        boolean res = false;
        Set<DSLBreakpoint> brkps = this.getBreakpoints(instruction);
        if (brkps != null && brkps.size() != 0) {
            res = true;
            for (DSLBreakpoint breakpoint : brkps) {
                try {
                    if (!breakpoint.isEnabled()) continue;
                    res = false;
                    break;
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
        return res;
    }

    protected Set<DSLBreakpoint> getBreakpoints(EObject instruction) {
        HashSet<DSLBreakpoint> res = new HashSet<DSLBreakpoint>();
        Set<DSLBreakpoint> brkps = BREAKPOINTS.get(EcoreUtil.getURI((EObject)instruction));
        if (brkps != null) {
            for (DSLBreakpoint breakpoint : brkps) {
                if (!breakpoint.getModelIdentifier().equals(this.getModelIdentifier())) continue;
                res.add(breakpoint);
            }
        }
        return res;
    }

    public boolean isCurrentInstruction(EObject instruction) {
        Set<URI> instructions = CURRENT_INSTRUCTIONS_PER_FRAME.get(LISTENER.getCurrentFrame());
        return instructions != null && instructions.contains(EcoreUtil.getURI((EObject)instruction));
    }

    public abstract String getModelIdentifier();

    public static final class BreakpointListener
    implements IBreakpointListener,
    IDSLCurrentInstructionListener {
        private static final Set<String> ANY_LAYER = new HashSet<String>();
        private final Map<String, Map<String, Set<String>>> representationToRefresh = new HashMap<String, Map<String, Set<String>>>();
        private StackFrame currentFrame;

        public BreakpointListener() {
            this.install();
        }

        public void install() {
            DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
            IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
            int n = iBreakpointArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint breakpoint = iBreakpointArray[n2];
                if (breakpoint instanceof DSLBreakpoint) {
                    this.addBreakpoint((DSLBreakpoint)breakpoint);
                }
                ++n2;
            }
        }

        public void uninstall() {
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        }

        public void breakpointAdded(IBreakpoint breakpoint) {
            if (breakpoint instanceof DSLBreakpoint) {
                this.addBreakpoint((DSLBreakpoint)breakpoint);
                DSLBreakpoint dslBreakpoint = (DSLBreakpoint)breakpoint;
                HashSet<URI> instructionURIs = new HashSet<URI>();
                instructionURIs.add(dslBreakpoint.getURI());
                this.notifySirius(instructionURIs, dslBreakpoint.getModelIdentifier());
            }
        }

        public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
            if (breakpoint instanceof DSLBreakpoint) {
                this.removeBreakpoint((DSLBreakpoint)breakpoint);
                DSLBreakpoint dslBreakpoint = (DSLBreakpoint)breakpoint;
                HashSet<URI> instructionURIs = new HashSet<URI>();
                instructionURIs.add(dslBreakpoint.getURI());
                this.notifySirius(instructionURIs, dslBreakpoint.getModelIdentifier());
            }
        }

        public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
            try {
                if (breakpoint instanceof DSLBreakpoint && delta.getAttribute("org.eclipse.debug.core.enabled") != null && breakpoint.isEnabled() != ((Boolean)delta.getAttribute("org.eclipse.debug.core.enabled")).booleanValue()) {
                    DSLBreakpoint dslBreakpoint = (DSLBreakpoint)breakpoint;
                    HashSet<URI> instructionURIs = new HashSet<URI>();
                    instructionURIs.add(dslBreakpoint.getURI());
                    this.notifySirius(instructionURIs, dslBreakpoint.getModelIdentifier());
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }

        protected void addBreakpoint(DSLBreakpoint breakpoint) {
            Set<DSLBreakpoint> brkps = BREAKPOINTS.get(breakpoint.getURI());
            if (brkps == null) {
                brkps = new HashSet<DSLBreakpoint>();
                BREAKPOINTS.put(breakpoint.getURI(), brkps);
            }
            brkps.add(breakpoint);
        }

        protected void removeBreakpoint(DSLBreakpoint breakpoint) {
            Set<DSLBreakpoint> brkps = BREAKPOINTS.get(breakpoint.getURI());
            if (brkps != null) {
                brkps.remove(breakpoint);
            }
        }

        public void notifySirius(Set<URI> instructionUris, String debugModelID) {
            Map<String, Set<String>> toRefresh = this.representationToRefresh.get(debugModelID);
            if (toRefresh != null) {
                for (IEditingSession session : SessionUIManager.INSTANCE.getUISessions()) {
                    TransactionalEditingDomain transactionalEditingDomain = session.getSession().getTransactionalEditingDomain();
                    boolean instructionPresent = BreakpointListener.isOneInstructionPresent(instructionUris, transactionalEditingDomain.getResourceSet());
                    if (!instructionPresent) continue;
                    List<DRepresentation> representations = this.getRepresentationsToRefresh(toRefresh, session);
                    this.refreshRepresentations(transactionalEditingDomain, representations);
                }
            }
        }

        public void refreshRepresentations(TransactionalEditingDomain transactionalEditingDomain, final List<DRepresentation> representations) {
            if (representations.size() != 0) {
                RefreshRepresentationsCommand refresh = new RefreshRepresentationsCommand(transactionalEditingDomain, (IProgressMonitor)new NullProgressMonitor(), representations);
                CommandStack commandStack = transactionalEditingDomain.getCommandStack();
                if (commandStack instanceof AbstractTransactionalCommandStack) {
                    final AbstractTransactionalCommandStack transactionnalCommandStack = (AbstractTransactionalCommandStack)commandStack;
                    transactionnalCommandStack.setExceptionHandler(new ExceptionHandler(){

                        public void handleException(Exception e) {
                            String repString = representations.stream().map(r -> r.getName()).collect(Collectors.joining(", "));
                            DebugSiriusIdeUiPlugin.getPlugin().getLog().log((IStatus)new Status(2, "org.eclipse.gemoc.dsl.debug.ide.sirius.ui", "Failed to refresh Sirius representation(s)[" + repString + "], we hope to be able to do it later", (Throwable)e));
                            transactionnalCommandStack.setExceptionHandler(null);
                        }
                    });
                }
                commandStack.execute((Command)refresh);
            }
        }

        private List<DRepresentation> getRepresentationsToRefresh(Map<String, Set<String>> toRefresh, IEditingSession session) {
            ArrayList<DRepresentation> representations = new ArrayList<DRepresentation>();
            for (DialectEditor editor : session.getEditors()) {
                DRepresentation representation = editor.getRepresentation();
                if (representation == null) {
                    System.out.println("Dammit");
                    continue;
                }
                RepresentationDescription description = DialectManager.INSTANCE.getDescription(representation);
                if (description == null) continue;
                String representationId = description.getName();
                Set<String> layerIDs = toRefresh.get(representationId);
                if (layerIDs == ANY_LAYER) {
                    representations.add(representation);
                    continue;
                }
                if (layerIDs == null || !(representation instanceof DDiagram) || !this.isActiveLayer((DDiagram)representation, layerIDs)) continue;
                representations.add(representation);
            }
            return representations;
        }

        private static boolean isOneInstructionPresent(Set<URI> instructionUris, ResourceSet resourceSet) {
            boolean instructionPresent = false;
            for (URI instructionUri : instructionUris) {
                if (resourceSet.getEObject(instructionUri, false) == null) continue;
                instructionPresent = true;
                break;
            }
            return instructionPresent;
        }

        private boolean isActiveLayer(DDiagram diagram, Set<String> layerIDs) {
            boolean res = false;
            for (Layer layer : diagram.getActivatedLayers()) {
                if (!layerIDs.contains(layer.getName())) continue;
                res = true;
                break;
            }
            return res;
        }

        public void addRepresentationToRefresh(String debugModelID, String representationID) {
            Map<String, Set<String>> toRefresh = this.representationToRefresh.get(debugModelID);
            if (toRefresh == null) {
                toRefresh = new HashMap<String, Set<String>>();
                this.representationToRefresh.put(debugModelID, toRefresh);
            }
            toRefresh.put(representationID, ANY_LAYER);
        }

        public void addRepresentationToRefresh(String debugModelID, String representationID, String layerID) {
            Set<String> layerIDs;
            Map<String, Set<String>> toRefresh = this.representationToRefresh.get(debugModelID);
            if (toRefresh == null) {
                toRefresh = new HashMap<String, Set<String>>();
                this.representationToRefresh.put(debugModelID, toRefresh);
            }
            if ((layerIDs = toRefresh.get(representationID)) != ANY_LAYER) {
                if (layerIDs == null) {
                    layerIDs = new HashSet<String>();
                    toRefresh.put(representationID, layerIDs);
                }
                layerIDs.add(layerID);
            }
        }

        public void currentInstructionChanged(String debugModelID, StackFrame frame) {
            EObject currentInstruction = frame.getCurrentInstruction();
            HashSet<URI> instructionURIs = new HashSet<URI>();
            if (currentInstruction instanceof ParallelStep) {
                this.addMseOccurenceAndCallerToInstructionsURIs(instructionURIs, ((ParallelStep)currentInstruction).getMseoccurrence());
                for (Step step : ((ParallelStep)currentInstruction).getSubSteps()) {
                    this.addMseOccurenceAndCallerToInstructionsURIs(instructionURIs, step.getMseoccurrence());
                }
            } else if (currentInstruction instanceof Step) {
                if (!(currentInstruction.eContainer() instanceof ParallelStep)) {
                    this.addMseOccurenceAndCallerToInstructionsURIs(instructionURIs, ((Step)currentInstruction).getMseoccurrence());
                }
            } else {
                instructionURIs.add(EcoreUtil.getURI((EObject)currentInstruction));
            }
            Set<URI> lastInstructions = CURRENT_INSTRUCTIONS_PER_FRAME.remove(frame);
            if (lastInstructions != null) {
                this.notifySirius(lastInstructions, debugModelID);
            }
            CURRENT_INSTRUCTIONS_PER_FRAME.put(frame, instructionURIs);
            this.notifySirius(instructionURIs, debugModelID);
        }

        private void addMseOccurenceAndCallerToInstructionsURIs(Set<URI> instructionURIs, MSEOccurrence mseOccurrence) {
            if (mseOccurrence != null) {
                instructionURIs.add(EcoreUtil.getURI((EObject)mseOccurrence.getMse()));
                if (mseOccurrence.getMse().getCaller() != null) {
                    instructionURIs.add(EcoreUtil.getURI((EObject)mseOccurrence.getMse().getCaller()));
                }
            }
        }

        public void terminated(String debugModelID, StackFrame frame) {
            Set<URI> lastInstructions = CURRENT_INSTRUCTIONS_PER_FRAME.remove(frame);
            if (lastInstructions != null) {
                this.notifySirius(lastInstructions, debugModelID);
            }
        }

        public StackFrame getCurrentFrame() {
            return this.currentFrame;
        }

        public void setCurrentFrame(String debugModelID, StackFrame frame) {
            if (this.currentFrame != frame) {
                this.currentFrame = frame;
                Set<URI> instructionUris = CURRENT_INSTRUCTIONS_PER_FRAME.get(this.getCurrentFrame());
                if (instructionUris != null) {
                    this.notifySirius(instructionUris, debugModelID);
                }
            }
        }

        public boolean isRepresentationToRefresh(String debugModelID, String representationId, String layerID) {
            Set<String> layerIDs;
            Map<String, Set<String>> representations = this.representationToRefresh.get(debugModelID);
            boolean res = representations != null ? (layerIDs = representations.get(representationId)) == ANY_LAYER || layerIDs != null && layerIDs.contains(layerID) : false;
            return res;
        }
    }

    public static final class StringCouple {
        private final String first;
        private final String second;

        public StringCouple(String first, String second) {
            this.first = first;
            this.second = second;
        }

        public String getFirst() {
            return this.first;
        }

        public String getSecond() {
            return this.second;
        }
    }
}

