/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.dsl.debug;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum State implements Enumerator
{
    RUNNING(0, "RUNNING", "RUNNING"),
    STEPPING_INTO(1, "STEPPING_INTO", "STEPPING_INTO"),
    STEPPING_OVER(2, "STEPPING_OVER", "STEPPING_OVER"),
    STEPPING_RETURN(3, "STEPPING_RETURN", "STEPPING_RETURN"),
    SUSPENDING(4, "SUSPENDING", "SUSPENDING"),
    SUSPENDED(5, "SUSPENDED", "SUSPENDED"),
    TERMINATING(6, "TERMINATING", "TERMINATING"),
    TERMINATED(7, "TERMINATED", "TERMINATED");

    public static final String copyright = "Copyright (c) 2015 Obeo.\n All rights reserved. This program and the accompanying materials\n are made available under the terms of the Eclipse Public License v1.0\n which accompanies this distribution, and is available at\n http://www.eclipse.org/legal/epl-v10.html\n \n Contributors:\n    Obeo - initial API and implementation";
    public static final int RUNNING_VALUE = 0;
    public static final int STEPPING_INTO_VALUE = 1;
    public static final int STEPPING_OVER_VALUE = 2;
    public static final int STEPPING_RETURN_VALUE = 3;
    public static final int SUSPENDING_VALUE = 4;
    public static final int SUSPENDED_VALUE = 5;
    public static final int TERMINATING_VALUE = 6;
    public static final int TERMINATED_VALUE = 7;
    private static final State[] VALUES_ARRAY;
    public static final List<State> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new State[]{RUNNING, STEPPING_INTO, STEPPING_OVER, STEPPING_RETURN, SUSPENDING, SUSPENDED, TERMINATING, TERMINATED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static State get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            State result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static State getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            State result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static State get(int value) {
        switch (value) {
            case 0: {
                return RUNNING;
            }
            case 1: {
                return STEPPING_INTO;
            }
            case 2: {
                return STEPPING_OVER;
            }
            case 3: {
                return STEPPING_RETURN;
            }
            case 4: {
                return SUSPENDING;
            }
            case 5: {
                return SUSPENDED;
            }
            case 6: {
                return TERMINATING;
            }
            case 7: {
                return TERMINATED;
            }
        }
        return null;
    }

    private State(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

