/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.launcher;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.api.MessagingSystem;
import org.eclipse.gemoc.commons.eclipse.ui.ViewHelper;
import org.eclipse.gemoc.dsl.debug.ide.adapter.IDSLCurrentInstructionListener;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.Activator;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.AbstractConcurrentExecutionEngine;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.AbstractConcurrentModelExecutionContext;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.IConcurrentRunConfiguration;
import org.eclipse.gemoc.executionframework.engine.commons.EngineContextException;
import org.eclipse.gemoc.executionframework.engine.ui.launcher.AbstractGemocLauncher;
import org.eclipse.gemoc.executionframework.extensions.sirius.services.AbstractGemocAnimatorServices;
import org.eclipse.gemoc.executionframework.extensions.sirius.services.AbstractGemocDebuggerServices;
import org.eclipse.gemoc.executionframework.extensions.sirius.services.IModelAnimator;
import org.eclipse.gemoc.xdsmlframework.api.core.EngineStatus;
import org.eclipse.gemoc.xdsmlframework.api.core.ExecutionMode;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionPlatform;
import org.eclipse.gemoc.xdsmlframework.api.core.IRunConfiguration;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.IEngineAddon;
import org.eclipse.gemoc.xdsmlframework.api.extensions.languages.LanguageDefinitionExtension;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractConcurrentLauncher<R extends IConcurrentRunConfiguration, C extends AbstractConcurrentModelExecutionContext<R, ? extends IExecutionPlatform, ? extends LanguageDefinitionExtension>>
extends AbstractGemocLauncher<C> {
    public static final String TYPE_ID = "org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.launcher";
    private AbstractConcurrentExecutionEngine<C, R> _executionEngine;

    protected abstract AbstractConcurrentExecutionEngine<C, R> createEngine(R var1, ExecutionMode var2) throws EngineContextException, CoreException;

    protected abstract R createRunConfiguration(ILaunchConfiguration var1) throws CoreException;

    protected abstract Set<String> getAdditionalViewsIDs();

    public void launch(final ILaunchConfiguration configuration, final String mode, final ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    ViewHelper.retrieveView((String)"org.eclipse.gemoc.executionframework.ui.views.engine.EnginesStatusView");
                    ViewHelper.showView((String)"org.eclipse.gemoc.executionframework.engine.io.views.steps.LogicalStepsView");
                    for (String s : AbstractConcurrentLauncher.this.getAdditionalViewsIDs()) {
                        ViewHelper.showView((String)s);
                    }
                }
            });
            ExecutionMode executionMode = null;
            executionMode = "debug".equals(mode) ? ExecutionMode.Animation : ExecutionMode.Run;
            R runConfiguration = this.createRunConfiguration(configuration);
            if (this.isEngineAlreadyRunning(runConfiguration.getExecutedModelURI())) {
                return;
            }
            this._executionEngine = this.createEngine(runConfiguration, executionMode);
            this.debug("About to initialize and run " + this._executionEngine.getName());
            this.openViewsRecommandedByAddons((IRunConfiguration)runConfiguration);
            Job job = new Job(this.getDebugJobName(configuration, this.getFirstInstruction(configuration))){

                protected IStatus run(IProgressMonitor monitor) {
                    if ("debug".equals(mode)) {
                        IModelAnimator animator = AbstractGemocAnimatorServices.getAnimator();
                        ((AbstractConcurrentModelExecutionContext)AbstractConcurrentLauncher.this._executionEngine.getExecutionContext()).getExecutionPlatform().addEngineAddon((IEngineAddon)animator);
                        try {
                            AbstractConcurrentLauncher.super.launch(configuration, mode, launch, monitor);
                            return new Status(0, AbstractConcurrentLauncher.this.getPluginID(), "Execution was launched successfully");
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                            return new Status(4, AbstractConcurrentLauncher.this.getPluginID(), "Could not start debugger.");
                        }
                    }
                    AbstractConcurrentLauncher.this._executionEngine.start();
                    AbstractConcurrentLauncher.this.debug("Execution finished.");
                    return new Status(0, AbstractConcurrentLauncher.this.getPluginID(), "Execution was launched successfully");
                }
            };
            this.debug("Initialization done, starting engine...");
            job.schedule();
        }
        catch (Exception e) {
            String message = "Error occured when starting execution engine: " + e.getMessage() + " (see inner exception).";
            Activator.error(message, e);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui", message, (Throwable)e));
        }
    }

    private boolean isEngineAlreadyRunning(URI launchedModelURI) throws CoreException {
        Collection engines = org.eclipse.gemoc.executionframework.engine.Activator.getDefault().gemocRunningEngineRegistry.getRunningEngines().values();
        for (IExecutionEngine engine : engines) {
            IExecutionEngine observable = engine;
            if (observable.getRunningStatus() == EngineStatus.RunStatus.Stopped || !observable.getExecutionContext().getResourceModel().getURI().equals(launchedModelURI)) continue;
            String message = "An engine is already running on this model, please stop it first";
            this.warn(message);
            return true;
        }
        return false;
    }

    protected void debug(String message) {
        this.getMessagingSystem().debug(message, this.getPluginID());
    }

    protected void info(String message) {
        this.getMessagingSystem().info(message, this.getPluginID());
    }

    protected void warn(final String message) {
        this.getMessagingSystem().warn(message, this.getPluginID());
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"GEMOC Engine Launcher", (String)message);
            }
        });
    }

    protected void error(final String message) {
        this.getMessagingSystem().error(message, this.getPluginID());
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"GEMOC Engine Launcher", (String)message);
            }
        });
    }

    private MessagingSystem getMessagingSystem() {
        return Activator.getDefault().getMessaggingSystem();
    }

    protected String getLaunchConfigurationTypeID() {
        return TYPE_ID;
    }

    protected EObject getFirstInstruction(ISelection selection) {
        return EcorePackage.eINSTANCE;
    }

    protected EObject getFirstInstruction(IEditorPart editor) {
        return EcorePackage.eINSTANCE;
    }

    protected EObject getFirstInstruction(ILaunchConfiguration configuration) {
        return EcorePackage.eINSTANCE;
    }

    protected String getDebugTargetName(ILaunchConfiguration configuration, EObject firstInstruction) {
        return "Gemoc debug target";
    }

    protected List<IDSLCurrentInstructionListener> getCurrentInstructionListeners() {
        List result = super.getCurrentInstructionListeners();
        result.add(AbstractGemocDebuggerServices.LISTENER);
        return result;
    }

    protected String getDebugJobName(ILaunchConfiguration configuration, EObject firstInstruction) {
        return "Gemoc Concurrent debug job";
    }

    protected String getPluginID() {
        return "org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui";
    }

    public String getModelIdentifier() {
        if (this._executionEngine instanceof AbstractConcurrentExecutionEngine) {
            return "org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.debugModel";
        }
        return "org.eclipse.gemoc.executionframework.engine.ui.debugModel";
    }

    protected ILaunchConfiguration[] createLaunchConfiguration(IResource file, EObject firstInstruction, String mode) throws CoreException {
        ILaunchConfigurationWorkingCopy configuration;
        String selectedLanguage;
        ILaunchConfiguration[] launchConfigs = super.createLaunchConfiguration(file, firstInstruction, mode);
        if (launchConfigs.length == 1 && launchConfigs[0] instanceof ILaunchConfigurationWorkingCopy && (selectedLanguage = (configuration = (ILaunchConfigurationWorkingCopy)launchConfigs[0]).getAttribute("GEMOC_LAUNCH_SELECTED_LANGUAGE", "")).equals("")) {
            configuration.setAttribute("GEMOC_LAUNCH_SELECTED_DECIDER", "Step by step user decider");
            ILaunchGroup group = DebugUITools.getLaunchGroup((ILaunchConfiguration)configuration, (String)mode);
            if (group != null) {
                ILaunchConfiguration savedLaunchConfig = configuration.doSave();
                DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IStructuredSelection)new StructuredSelection((Object)savedLaunchConfig), (String)group.getIdentifier(), null);
            }
        }
        return launchConfigs;
    }

    public IExecutionEngine<C> getExecutionEngine() {
        return this._executionEngine;
    }
}

