/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.commands;

import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockConstraintSystem;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gemoc.commons.eclipse.resource.merging.ActionContext;
import org.eclipse.gemoc.commons.eclipse.resource.merging.IBeforeSavingAction;
import org.eclipse.gemoc.commons.eclipse.resource.merging.ResourcesMergerScript;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class MergeExtendedCCSLCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection structeredSelection = (IStructuredSelection)selection;
            for (Object o : structeredSelection.toList()) {
                if (!(o instanceof IFile)) continue;
                IFile inputFile = (IFile)o;
                this.merge(inputFile);
            }
        }
        return null;
    }

    private void merge(IFile inputFile) throws ExecutionException {
        IPath outputFilePath = inputFile.getProjectRelativePath().removeFileExtension().addFileExtension("xmi");
        IFile outputFile = inputFile.getProject().getFile(outputFilePath);
        try {
            ResourcesMergerScript.allResourcesFrom((IFile)inputFile).mergeInto(outputFile).beforeSavingPerform(this.removeImports()).go();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ExecutionException("Impossible to perform resource merging", (Throwable)e);
        }
    }

    private IBeforeSavingAction removeImports() {
        return new IBeforeSavingAction(){

            public void run(ActionContext context) {
                for (EObject o : context.getResource().getContents()) {
                    if (!(o instanceof ClockConstraintSystem)) continue;
                    ClockConstraintSystem system = (ClockConstraintSystem)o;
                    system.getImports().clear();
                }
            }
        };
    }
}

