/**
 * Copyright (c) 2017 Inria.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package org.eclipse.gemoc.xdsmlframework.test.lib;

import java.util.List;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.matchers.WidgetMatcherFactory;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.hamcrest.Matcher;

/**
 * Class containing helper methods for testing a workspace in a GEMOC Language workbench
 */
@SuppressWarnings("all")
public class SWTBotHelper {
  /**
   * relaunch the  waitForJobs several times in case some other background task
   * also wait for idle time to triggers new jobs
   */
  public static void printShellList(final SWTWorkbenchBot bot) {
    final List<SWTBotShell> shells = IterableExtensions.<SWTBotShell>toList(((Iterable<SWTBotShell>)Conversions.doWrapArray(bot.shells())));
    int _size = shells.size();
    String _plus = ("SWTBot Known shells(" + Integer.valueOf(_size));
    String _plus_1 = (_plus + "):");
    InputOutput.<String>println(_plus_1);
    for (final SWTBotShell shell : shells) {
      InputOutput.<String>println(("\t" + shell));
    }
  }
  
  public static void printTreeList(final SWTWorkbenchBot bot) {
    int _size = ((List<SWTBotTreeItem>)Conversions.doWrapArray(bot.tree().getAllItems())).size();
    String _plus = ("SWTBot tree(" + Integer.valueOf(_size));
    String _plus_1 = (_plus + "):");
    InputOutput.<String>println(_plus_1);
    SWTBotTreeItem[] _allItems = bot.tree().getAllItems();
    for (final SWTBotTreeItem item : _allItems) {
      InputOutput.<String>println(("\t" + item));
    }
  }
  
  public static void printViewList(final SWTWorkbenchBot bot) {
    final List<SWTBotView> views = bot.views();
    int _size = views.size();
    String _plus = ("SWTBot View(" + Integer.valueOf(_size));
    String _plus_1 = (_plus + "):");
    InputOutput.<String>println(_plus_1);
    for (final SWTBotView item : views) {
      UIThreadRunnable.syncExec(new VoidResult() {
        @Override
        public void run() {
          String _title = item.getTitle();
          String _plus = ("\t" + _title);
          String _plus_1 = (_plus + " ");
          Widget _widget = item.getWidget();
          String _plus_2 = (_plus_1 + _widget);
          InputOutput.<String>println(_plus_2);
          final Function1<SWTBotToolbarButton, ToolItem> _function = (SWTBotToolbarButton swtBut) -> {
            return swtBut.widget;
          };
          SWTBotHelper.printWidgetList("\t\t", "View ToolBarButton", IterableExtensions.<ToolItem>toList(ListExtensions.<SWTBotToolbarButton, ToolItem>map(item.getToolbarButtons(), _function)));
        }
      });
    }
  }
  
  public static void printSWTBotStatus(final SWTWorkbenchBot bot) {
    InputOutput.<String>println("### SWTBot context analysis ###");
    SWTBotHelper.printShellList(bot);
    SWTBotHelper.printViewList(bot);
    SWTBotHelper.printTreeList(bot);
    UIThreadRunnable.syncExec(new VoidResult() {
      @Override
      public void run() {
        try {
          final Matcher<Button> matcherButton = WidgetMatcherFactory.<Button>allOf(WidgetMatcherFactory.<Button>widgetOfType(Button.class));
          final List<? extends Button> buttons = IterableExtensions.toList(bot.<Button>widgets(matcherButton));
          SWTBotHelper.printWidgetList("", "Button", buttons);
        } catch (final Throwable _t) {
          if (_t instanceof Exception) {
            InputOutput.<String>println("SWTBot Button(0) [no Button in the UI after 20000ms]");
          } else {
            throw Exceptions.sneakyThrow(_t);
          }
        }
        final Matcher<ToolItem> matcherToolItem = WidgetMatcherFactory.<ToolItem>allOf(
          WidgetMatcherFactory.<ToolItem>widgetOfType(ToolItem.class));
        final List<? extends ToolItem> toolItems = IterableExtensions.toList(bot.<ToolItem>widgets(matcherToolItem));
        SWTBotHelper.printWidgetList("", "ToolItem", toolItems);
      }
    });
  }
  
  public static void printWidgetList(final String indent, final String itemType, final List<? extends Widget> items) {
    int _size = items.size();
    String _plus = ((((indent + "SWTBot ") + itemType) + "(") + Integer.valueOf(_size));
    String _plus_1 = (_plus + "):");
    InputOutput.<String>println(_plus_1);
    for (final Widget item : items) {
      if ((item instanceof ToolItem)) {
        String _toolTipText = ((ToolItem)item).getToolTipText();
        String _plus_2 = ((((indent + "\t") + item) + " toolTipText=") + _toolTipText);
        InputOutput.<String>println(_plus_2);
      } else {
        if ((item instanceof Button)) {
          String _text = ((Button)item).getText();
          String _plus_3 = ((((indent + "\t") + item) + " text=") + _text);
          String _plus_4 = (_plus_3 + " toolTipText=");
          String _toolTipText_1 = ((Button)item).getToolTipText();
          String _plus_5 = (_plus_4 + _toolTipText_1);
          InputOutput.<String>println(_plus_5);
        } else {
          InputOutput.<String>println(((indent + "\t") + item));
        }
      }
    }
  }
}
