/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.manager.visible;

import fr.inria.aoste.timesquare.backend.manager.controller.Controller;
import fr.inria.aoste.timesquare.backend.manager.datastructure.Entity;
import fr.inria.aoste.timesquare.backend.manager.visible.BehaviorConfigurator;
import fr.inria.aoste.timesquare.backend.manager.visible.ClockBehavior;
import fr.inria.aoste.timesquare.backend.manager.visible.ConfigurationHelper;
import fr.inria.aoste.timesquare.backend.manager.visible.DeleteHelper;
import fr.inria.aoste.timesquare.backend.manager.visible.PersistentOptions;
import fr.inria.aoste.timesquare.backend.manager.visible.RelationBehavior;
import fr.inria.aoste.timesquare.launcher.core.inter.CCSLInfo;
import fr.inria.aoste.timesquare.launcher.core.inter.ISolverForBackend;
import fr.inria.aoste.timesquare.launcher.debug.model.output.ReportMessage;
import fr.inria.aoste.trace.LogicalStep;
import org.eclipse.core.runtime.IPath;

public abstract class BehaviorManager {
    private String id = null;
    protected Controller controller = null;
    protected ConfigurationHelper _helper = null;
    LogicalStep currentstep;

    public abstract String getPluginName();

    protected String _getid() {
        String s = this.getPluginName().toLowerCase().replaceAll(" ", "");
        return s;
    }

    public final String getId() {
        if (this.id == null) {
            this.id = this._getid();
        }
        return this.id;
    }

    public boolean isActivable(ReportMessage rm, CCSLInfo ccslhelper) {
        return true;
    }

    public String validate() {
        return null;
    }

    public void deleteEntity(Entity entity, DeleteHelper deletehelper) {
    }

    public final void setController(Controller c) {
        this.controller = c;
    }

    public void init(ConfigurationHelper helper) {
        this._helper = helper;
    }

    public abstract void manageBehavior(ConfigurationHelper var1);

    public abstract ClockBehavior redoClockBehavior(ConfigurationHelper var1, PersistentOptions var2);

    public abstract RelationBehavior redoRelationBehavior(ConfigurationHelper var1, PersistentOptions var2);

    public abstract ClockBehavior redoAssertBehavior(ConfigurationHelper var1, PersistentOptions var2);

    public PersistentOptions getPluginOptions() {
        return null;
    }

    public void receivePluginOptions(ConfigurationHelper helper, PersistentOptions persistentOptions) throws Throwable {
    }

    public abstract void beforeExecution(ConfigurationHelper var1, IPath var2, String var3, ISolverForBackend var4);

    public abstract void end(ConfigurationHelper var1);

    public void aNewStep(int step) {
    }

    public void repeatStep(int step) {
    }

    public void aPostNewStep(int step) {
    }

    public BehaviorConfigurator<?> getConfigurator(ConfigurationHelper configurationHelper) {
        return null;
    }

    public final void activate() {
        this.controller.activate();
    }

    public final LogicalStep getCurrentStep() {
        return this.currentstep;
    }

    public final void setCurrentStep(LogicalStep currentstep) {
        this.currentstep = currentstep;
    }

    public void clear() {
    }
}

