/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.parser.xtext.validation;

import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.Clock;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.ImportStatement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.TimeModelPackage;
import fr.inria.aoste.timesquare.ccslkernel.parser.xtext.CCSLImportURIResolver;
import fr.inria.aoste.timesquare.ccslkernel.parser.xtext.validation.AbstractExtendedCCSLJavaValidator;
import fr.inria.aoste.timesquare.ccslkernel.xtext.util.BindingValidation;
import fr.inria.aoste.timesquare.ccslkernel.xtext.util.NamedElementValidation;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.ComposedChecks;

@ComposedChecks(validators={BindingValidation.class, NamedElementValidation.class})
public class ExtendedCCSLJavaValidator
extends AbstractExtendedCCSLJavaValidator {
    @Check
    public void checkImportStatement(ImportStatement s) {
        if (s.getImportURI() == null || s.getImportURI().length() == 0) {
            this.error("Missing Import URI", (EStructuralFeature)TimeModelPackage.eINSTANCE.getImportStatement_ImportURI());
            return;
        }
        if (s.getAlias() == null || s.getAlias().length() == 0) {
            this.error("Missing alias name", (EStructuralFeature)TimeModelPackage.eINSTANCE.getImportStatement_Alias());
            return;
        }
        try {
            Resource resource;
            String importedURI = new CCSLImportURIResolver().resolve((EObject)s);
            if (importedURI != null && !"platform:/".equals(importedURI) && (resource = EcoreUtil2.getResource((Resource)s.eResource(), (String)importedURI)) == null) {
                this.error("Import load failure", (EStructuralFeature)TimeModelPackage.eINSTANCE.getImportStatement_ImportURI());
                return;
            }
        }
        catch (Throwable e) {
            this.error("unLoading", (EStructuralFeature)TimeModelPackage.eINSTANCE.getImportStatement_ImportURI());
        }
    }

    @Check
    public void checkClock(Clock clock) {
        Collection refs = EcoreUtil.UsageCrossReferencer.find((EObject)clock, (ResourceSet)clock.eResource().getResourceSet());
        if (refs.size() == 0) {
            this.warning("Clock " + clock.getName() + " is currently unused.", (EObject)clock, (EStructuralFeature)TimeModelPackage.eINSTANCE.getNamedElement_Name(), 0);
        }
    }
}

