/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.runtime;

import fr.inria.aoste.timesquare.ccslkernel.runtime.ICCSLConstraint;
import fr.inria.aoste.timesquare.ccslkernel.runtime.INamedElement;
import fr.inria.aoste.timesquare.ccslkernel.runtime.IRuntimeContainer;
import fr.inria.aoste.timesquare.ccslkernel.runtime.QualifiedName;
import fr.inria.aoste.timesquare.ccslkernel.runtime.SerializedConstraintState;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.expressions.AbstractRuntimeExpression;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractSemanticHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractUpdateHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.relations.AbstractRuntimeRelation;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractRuntimeBlock
implements ICCSLConstraint,
IRuntimeContainer,
INamedElement {
    protected IRuntimeContainer parent;
    protected String name;
    private List<IRuntimeContainer> contents = new ArrayList<IRuntimeContainer>();
    private List<AbstractRuntimeRelation> relations = new ArrayList<AbstractRuntimeRelation>();
    private List<AbstractRuntimeExpression> expressions = new ArrayList<AbstractRuntimeExpression>();
    private List<RuntimeClock> denseClocks = new ArrayList<RuntimeClock>();
    private List<RuntimeClock> discreteClocks = new ArrayList<RuntimeClock>();

    public AbstractRuntimeBlock(IRuntimeContainer parent, String name) {
        this.setParent(parent);
        this.name = name;
    }

    protected abstract void init();

    protected abstract ICCSLConstraint[] getConstraints();

    public abstract AbstractRuntimeBlock[] getSubBlocks();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public QualifiedName getQualifiedName() {
        if (this.parent != null && this.parent instanceof INamedElement) {
            return new QualifiedName(((INamedElement)((Object)this.parent)).getQualifiedName()).append(this.getName());
        }
        return new QualifiedName(this.getName());
    }

    @Override
    public void setQualifiedName(QualifiedName qualifiedName) {
    }

    @Override
    public void setQualifiedName(String qualifiedName) {
    }

    @Override
    public IRuntimeContainer getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IRuntimeContainer parent) {
        this.parent = parent;
        if (parent != null) {
            parent.addContent(this);
        }
    }

    @Override
    public void addContent(IRuntimeContainer element) {
        if (element instanceof AbstractRuntimeRelation) {
            this.relations.add((AbstractRuntimeRelation)element);
        } else if (element instanceof AbstractRuntimeExpression) {
            this.expressions.add((AbstractRuntimeExpression)element);
        } else if (element instanceof RuntimeClock && ((RuntimeClock)element).isDense()) {
            this.denseClocks.add((RuntimeClock)element);
        } else if (element instanceof RuntimeClock) {
            this.discreteClocks.add((RuntimeClock)element);
        }
        this.contents.add(element);
    }

    @Override
    public List<IRuntimeContainer> getContents() {
        return this.contents;
    }

    protected List<AbstractRuntimeRelation> getRelations() {
        return this.relations;
    }

    protected List<AbstractRuntimeExpression> getExpressions() {
        return this.expressions;
    }

    public List<RuntimeClock> getDenseClocks() {
        return this.denseClocks;
    }

    public List<RuntimeClock> getDiscreteClocks() {
        return this.discreteClocks;
    }

    public List<RuntimeClock> getAllDiscreteClocks(List<RuntimeClock> res) {
        res.addAll(this.getDiscreteClocks());
        for (AbstractRuntimeRelation relation : this.getRelations()) {
            for (RuntimeClock clock : relation.getDiscreteClocks()) {
                res.add(clock);
            }
        }
        for (AbstractRuntimeExpression expression : this.getExpressions()) {
            res.addAll(expression.getDiscreteClocks());
        }
        AbstractRuntimeBlock[] abstractRuntimeBlockArray = this.getSubBlocks();
        int n = abstractRuntimeBlockArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractRuntimeBlock subBlock = abstractRuntimeBlockArray[n2];
            res.addAll(subBlock.getDiscreteClocks());
            ++n2;
        }
        return res;
    }

    public List<AbstractRuntimeRelation> getAllAssertions() {
        ArrayList<AbstractRuntimeRelation> res = new ArrayList<AbstractRuntimeRelation>();
        for (AbstractRuntimeRelation relation : this.getRelations()) {
            if (!relation.isAssertion()) continue;
            res.add(relation);
            res.addAll(relation.getAllAssertions());
        }
        AbstractRuntimeBlock[] abstractRuntimeBlockArray = this.getSubBlocks();
        int n = abstractRuntimeBlockArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractRuntimeBlock subBlock = abstractRuntimeBlockArray[n2];
            res.addAll(subBlock.getAllAssertions());
            ++n2;
        }
        return res;
    }

    @Override
    public void semantic(AbstractSemanticHelper helper) throws SimulationException {
        for (ICCSLConstraint iCCSLConstraint : this.getRelations()) {
            iCCSLConstraint.semantic(helper);
        }
        for (ICCSLConstraint iCCSLConstraint : this.getExpressions()) {
            iCCSLConstraint.semantic(helper);
        }
    }

    @Override
    public void deathSemantic(AbstractSemanticHelper helper) throws SimulationException {
        ICCSLConstraint[] iCCSLConstraintArray = this.getConstraints();
        int n = iCCSLConstraintArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICCSLConstraint ct = iCCSLConstraintArray[n2];
            ct.deathSemantic(helper);
            ++n2;
        }
    }

    @Override
    public void update(AbstractUpdateHelper helper) throws SimulationException {
        ICCSLConstraint[] iCCSLConstraintArray = this.getConstraints();
        int n = iCCSLConstraintArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICCSLConstraint ct = iCCSLConstraintArray[n2];
            ct.update(helper);
            ++n2;
        }
    }

    @Override
    public void start(AbstractSemanticHelper helper) throws SimulationException {
        ICCSLConstraint[] iCCSLConstraintArray = this.getConstraints();
        int n = iCCSLConstraintArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICCSLConstraint ct = iCCSLConstraintArray[n2];
            ct.start(helper);
            ++n2;
        }
    }

    @Override
    public void terminate(AbstractUpdateHelper helper) {
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public SerializedConstraintState dumpState() {
        return null;
    }

    @Override
    public void restoreState(SerializedConstraintState state) {
    }
}

