/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.k3.al.annotationprocessor;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.eclipse.xtend.lib.macro.Active;

/**
 * Indicates that this class is an aspect on top of another base class.
 * <br>
 * Minimal example:
 * <pre>
 * {@literal @}Aspect(className=XYZ)
 * class XYZAspect {}
 * </pre>
 * 
 * The <i>with</i> attribute is used in in case of multiple inheritance in the base classes/aspect:
 * <pre>
 * {@literal @}Aspect(className=Child, with=#[ParentAspect2, ParentAspect3] )
 * class ChildAspect extends Parent1Aspect{ }
 * </pre>
 * @see <a href="http://diverse-project.github.io/k3/publish/user_documentation/html_single/user_documentation.html#_creating_an_aspect_on_a_class">Creating an aspect class section in the documentation</a>
 * @see <a href="http://diverse-project.github.io/k3/publish/user_documentation/html_single/user_documentation.html#_extending_an_aspect_multi_inheritance">Extending an aspect (multi inheritance) section in the documentation</a>
 */
@Retention(RetentionPolicy.RUNTIME)
@Active(AspectProcessor.class)
@Target(ElementType.TYPE)
@SuppressWarnings("all")
public @interface Aspect {
  public Class<?> className();
  public Class<?>[] with() default {};
}
