/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.k3.al.annotationprocessor;

import com.google.common.base.Objects;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class EMFInvokeMethodHelper {
  public static final EMFInvokeMethodHelper instance = new EMFInvokeMethodHelper();

  public <T extends Object> T invokeMethod(final Object o, final String methodname, final String aspectQualifiedName, final T res, final Object... params) {
    Object _xtrycatchfinallyexpression = null;
    try {
      final Class<?> a = Thread.currentThread().getContextClassLoader().loadClass(aspectQualifiedName);
      final Method[] ms = a.getMethods();
      final Function1<Method, Boolean> _function = (Method it) -> {
        return Boolean.valueOf((Objects.equal(methodname, it.getName()) && (((List<Class<?>>)Conversions.doWrapArray(it.getParameterTypes())).size() == ((List<Object>)Conversions.doWrapArray(params)).size())));
      };
      Method m = IterableExtensions.<Method>findFirst(((Iterable<Method>)Conversions.doWrapArray(ms)), _function);
      Object _invoke = m.invoke(null, o, params);
      return ((T) _invoke);
    } catch (final Throwable _t) {
      if (_t instanceof IllegalAccessException) {
        _xtrycatchfinallyexpression = null;
      } else if (_t instanceof InvocationTargetException) {
        _xtrycatchfinallyexpression = null;
      } else if (_t instanceof ClassNotFoundException) {
        _xtrycatchfinallyexpression = null;
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
    return ((T)_xtrycatchfinallyexpression);
  }
}
