/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.diverse.k3.ui.tools;

import fr.inria.diverse.k3.ui.wizards.pages.NewK3ProjectWizardFields;
import java.io.File;
import java.util.Collections;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.Generator;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.generator.GenModelGeneratorAdapterFactory;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;

public class GenerateGenModelCode {
    Generator generator;

    public static void main(String[] args) {
        GenerateGenModelCode t = new GenerateGenModelCode();
        t.createGenModel("My.ecore", "TEST");
    }

    public Boolean existGenModel(NewK3ProjectWizardFields context) {
        int i = 0;
        Boolean bRet = false;
        int endIndex = context.ecoreIFile.getLocation().toOSString().length();
        int beginIndex = endIndex - context.ecoreIFile.getName().length();
        String pathFolder = context.ecoreIFile.getLocation().toOSString().substring(0, beginIndex);
        File folder = new File(pathFolder);
        i = 0;
        while (i < folder.list().length) {
            if (folder.list()[i].endsWith(".genmodel")) {
                context.genModelFile = folder.listFiles()[i].getPath();
                bRet = true;
            }
            ++i;
        }
        return bRet;
    }

    public String getBasePackage(String genModelFile) {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("genmodel", new EcoreResourceFactoryImpl());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
        URI genModelURI = URI.createFileURI((String)genModelFile);
        Resource resource = resourceSet.getResource(genModelURI, true);
        GenModel eltGenModel = (GenModel)resource.getContents().get(0);
        return ((GenPackage)eltGenModel.getGenPackages().get(0)).getBasePackage();
    }

    public void createGenModel(String ecorepath, String outputPath) {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("genmodel", new EcoreResourceFactoryImpl());
        Path ecorePath = new Path(ecorepath);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
        URI ecoreURI = URI.createFileURI((String)ecorePath.toString());
        Resource resource = resourceSet.getResource(ecoreURI, true);
        EPackage ePackage = (EPackage)resource.getContents().get(0);
        IPath genModelPath = ecorePath.removeFileExtension().addFileExtension("genmodel");
        URI genModelURI = URI.createFileURI((String)genModelPath.toString());
        Resource genModelResource = Resource.Factory.Registry.INSTANCE.getFactory(genModelURI).createResource(genModelURI);
        GenModel genModel = GenModelFactory.eINSTANCE.createGenModel();
        genModelResource.getContents().add((Object)genModel);
        resourceSet.getResources().add((Object)genModelResource);
        genModel.setModelDirectory("/" + outputPath + "/src");
        genModel.getForeignModel().add((Object)ecorePath.toString());
        genModel.initialize(Collections.singleton(ePackage));
        GenPackage genPackage = (GenPackage)genModel.getGenPackages().get(0);
        genModel.setModelName(genModelURI.trimFileExtension().lastSegment());
        genPackage.setPrefix(genPackage.getNSName());
        genPackage.setBasePackage("");
        File f = new File(outputPath);
        this.deleteDirectory(f);
        f.mkdir();
        EcorePlugin.getPlatformResourceMap().put(outputPath, URI.createFileURI((String)(String.valueOf(f.getAbsolutePath()) + "/")));
        this.generate(genModel);
    }

    public void generate(GenModel genModel) {
        genModel.setCanGenerate(true);
        GeneratorAdapterFactory.Descriptor.Registry.INSTANCE.addDescriptor("http://www.eclipse.org/emf/2002/GenModel", GenModelGeneratorAdapterFactory.DESCRIPTOR);
        org.eclipse.emf.codegen.ecore.generator.Generator generator = new org.eclipse.emf.codegen.ecore.generator.Generator();
        generator.setInput((Object)genModel);
        Diagnostic d = generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", (Monitor)new BasicMonitor.Printing(System.out));
        System.out.println(d.getMessage());
    }

    public boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    this.deleteDirectory(files[i]);
                } else {
                    files[i].delete();
                }
                ++i;
            }
        }
        return path.delete();
    }
}

