/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.ide.ui.project;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecoretools.ale.core.env.IAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.env.impl.FileBasedAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.io.IOResources;
import org.eclipse.emf.ecoretools.ale.ide.project.AleProjectPreferences;
import org.eclipse.emf.ecoretools.ale.ide.ui.Activator;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.internal.session.SessionTransientAttachment;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelectionCallback;
import org.eclipse.sirius.ui.business.internal.commands.ChangeViewpointSelectionCommand;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.osgi.service.prefs.BackingStoreException;

public class WorkspaceAleProject {
    private WorkspaceAleProject() {
    }

    public static final class Description {
        public final boolean useAnExistingEcoreModel;
        public final IPath ecoreModelFilePath;
        public final String ecorePackageName;
        public final boolean createRepresentation;
        public final boolean activateJava;
        public final boolean createDslConfigurationFile;

        public Description(boolean useAnExistingEcoreModel, IPath ecoreModelFilePath, String ecorePackageName, boolean createRepresentation, boolean activateJava, boolean createDslConfigurationFile) {
            this.useAnExistingEcoreModel = useAnExistingEcoreModel;
            this.ecoreModelFilePath = ecoreModelFilePath;
            this.ecorePackageName = ecorePackageName;
            this.createRepresentation = createRepresentation;
            this.activateJava = activateJava;
            this.createDslConfigurationFile = createDslConfigurationFile;
        }
    }

    public static class Template {
        private final IWorkspace workspace;
        private final Description description;

        public Template(IWorkspace workspace, Description description) {
            this.workspace = Objects.requireNonNull(workspace, "workspace");
            this.description = Objects.requireNonNull(description, "description");
        }

        public IProject create(String name, IPath path, IProgressMonitor monitor) throws CoreException {
            ICoreRunnable createProject = projectMonitor -> {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)projectMonitor, (String)"Creating ALE project", (int)7);
                try {
                    try {
                        IProject project = this.createProject(name, path, (IProgressMonitor)subMonitor.split(1));
                        EPackage epackage = this.getOrCreateEcoreModel(project, (IProgressMonitor)subMonitor.split(1));
                        IPath aleFilePath = this.createAleSourceFile(project, epackage, (IProgressMonitor)subMonitor.split(1));
                        this.configureAleEnvironment(project, Arrays.asList(epackage.eResource().getURI().toString()), Arrays.asList(URI.createPlatformResourceURI((String)aleFilePath.toPortableString(), (boolean)true).toString()), (IProgressMonitor)subMonitor.split(1));
                        this.createRepresentation(project, (EObject)epackage, (IProgressMonitor)subMonitor.split(1));
                        this.addJavaNature(project, (IProgressMonitor)subMonitor.split(1));
                        project.refreshLocal(2, (IProgressMonitor)subMonitor.split(1));
                    }
                    catch (IOException e) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.emf.ecoretools.ale.ide.ui", e.getMessage(), (Throwable)e));
                    }
                }
                finally {
                    monitor.done();
                }
            };
            this.workspace.run(createProject, monitor);
            return this.workspace.getRoot().getProject(name);
        }

        private IProject createProject(String name, IPath path, IProgressMonitor monitor) throws CoreException {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Creating the project...", (int)3);
            IProject project = this.workspace.getRoot().getProject(name);
            if (project.exists()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.emf.ecoretools.ale.ide.ui", "project " + name + " already exists in the workspace"));
            }
            IProjectDescription desc = this.workspace.newProjectDescription(name);
            desc.setLocation(path);
            desc.setNatureIds(new String[]{"org.eclipse.xtext.ui.shared.xtextNature", "org.eclipse.emf.ecoretools.ale.ide.project.alenature"});
            subMonitor.subTask("Creating the project " + name + "...");
            project.create(desc, (IProgressMonitor)subMonitor.split(1));
            subMonitor.subTask("Opening the project " + name + "...");
            project.open((IProgressMonitor)subMonitor.split(1));
            subMonitor.subTask("Creating the model folder...");
            project.getFolder("model").create(false, true, (IProgressMonitor)subMonitor.split(1));
            return project;
        }

        private EPackage getOrCreateEcoreModel(IProject project, IProgressMonitor monitor) throws IOException {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Creating the Ecore model...", (int)1);
            if (!this.description.useAnExistingEcoreModel) {
                return Template.createEcoreModel(project, this.description.ecorePackageName, (IProgressMonitor)subMonitor.split(1));
            }
            return Template.getEcoreModel(this.description.ecoreModelFilePath);
        }

        private static EPackage createEcoreModel(IProject project, String packageName, IProgressMonitor monitor) throws IOException {
            EPackage pkg = EcoreFactory.eINSTANCE.createEPackage();
            pkg.setName(packageName);
            pkg.setNsPrefix(packageName);
            pkg.setNsURI("http://" + packageName);
            IFile ecoreFile = project.getFolder("model").getFile(String.valueOf(project.getName()) + ".ecore");
            ResourceSetImpl resources = new ResourceSetImpl();
            Resource resource = resources.createResource(URI.createPlatformResourceURI((String)ecoreFile.getFullPath().toOSString(), (boolean)true));
            resource.getContents().add((Object)pkg);
            resource.save(Collections.emptyMap());
            return pkg;
        }

        private IPath createAleSourceFile(IProject project, EPackage epackage, IProgressMonitor monitor) throws CoreException {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Creating ALE source file...", (int)2);
            String initialContent = "behavior " + epackage.getName() + ";";
            ByteArrayInputStream readableInitialContent = new ByteArrayInputStream(initialContent.getBytes());
            IFolder srcFolder = project.getFolder("src-ale");
            srcFolder.create(false, true, (IProgressMonitor)subMonitor.split(1));
            IFile src = srcFolder.getFile(String.valueOf(project.getName()) + ".ale");
            src.create((InputStream)readableInitialContent, false, (IProgressMonitor)subMonitor.split(1));
            return src.getFullPath();
        }

        private static EPackage getEcoreModel(IPath path) {
            ResourceSetImpl resources = new ResourceSetImpl();
            Resource resource = resources.getResource(URI.createPlatformResourceURI((String)path.toOSString(), (boolean)true), true);
            return (EPackage)resource.getContents().get(0);
        }

        private void configureAleEnvironment(IProject project, List<String> ecoreModels, List<String> aleSourceFiles, IProgressMonitor monitor) {
            ProjectScope context = new ProjectScope(project);
            IEclipsePreferences preferences = context.getNode("org.eclipse.emf.ecoretools.ale.core");
            if (this.description.createDslConfigurationFile) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Creating .dsl file...", (int)1);
                IFile dslFile = project.getFile(String.valueOf(project.getName()) + ".dsl");
                try {
                    Throwable throwable = null;
                    Object var10_14 = null;
                    try (FileBasedAleEnvironment dsl = IAleEnvironment.fromFile((IFile)dslFile);){
                        dsl.save(IAleEnvironment.fromPaths(ecoreModels, aleSourceFiles));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    Activator.error("Unable to save " + dslFile.getFullPath(), e);
                }
                try {
                    preferences.putBoolean(AleProjectPreferences.CONFIGURED_FROM_DSL_FILE.property(), true);
                    preferences.put(AleProjectPreferences.DSL_FILE_PATH.property(), IOResources.toPlatformResourceURI((IFile)dslFile).toString());
                    preferences.flush();
                }
                catch (BackingStoreException e) {
                    Activator.error(e.getMessage(), e);
                }
                subMonitor.worked(1);
            } else {
                try {
                    preferences.putBoolean(AleProjectPreferences.CONFIGURED_FROM_DSL_FILE.property(), false);
                    preferences.put(AleProjectPreferences.ALE_SOURCE_FILES.property(), String.join((CharSequence)",", aleSourceFiles));
                    preferences.put(AleProjectPreferences.ECORE_MODEL_FILES.property(), String.join((CharSequence)",", ecoreModels));
                    preferences.flush();
                }
                catch (BackingStoreException e) {
                    Activator.error(e.getMessage(), e);
                }
            }
        }

        private void createRepresentation(final IProject project, final EObject model, IProgressMonitor monitor) {
            Optional<RepresentationDescription> representationDescription;
            if (!this.description.createRepresentation) {
                return;
            }
            final SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Creating Sirius representation...", (int)4);
            URI sessionResourceURI = URI.createPlatformResourceURI((String)project.getFolder("model").getFile(String.valueOf(project.getName()) + ".aird").getFullPath().toOSString(), (boolean)true);
            final Session session = SessionManager.INSTANCE.getSession(sessionResourceURI, (IProgressMonitor)new NullProgressMonitor());
            session.open((IProgressMonitor)new NullProgressMonitor());
            session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(session.getTransactionalEditingDomain()){

                protected void doExecute() {
                    session.addSemanticResource(URI.createURI((String)"http://www.eclipse.org/emf/2002/Ecore"), (IProgressMonitor)subMonitor);
                }
            });
            final Optional<Viewpoint> maybeDesignViewpoint = Template.findDesignViewpoint(ViewpointRegistry.getInstance());
            if (!maybeDesignViewpoint.isPresent()) {
                Activator.error("Cannot create Sirius representation in project " + project.getName() + ": 'Design' viewpoint not found", null);
                return;
            }
            Viewpoint designViewpoint = maybeDesignViewpoint.get();
            ChangeViewpointSelectionCommand cc = new ChangeViewpointSelectionCommand(session, (ViewpointSelection.Callback)new ViewpointSelectionCallback(), new HashSet<Viewpoint>(Arrays.asList(designViewpoint)), Collections.emptySet(), (IProgressMonitor)subMonitor.split(1));
            session.getTransactionalEditingDomain().getCommandStack().execute((Command)cc);
            session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(session.getTransactionalEditingDomain()){

                protected void doExecute() {
                    session.createView((Viewpoint)maybeDesignViewpoint.get(), Arrays.asList(model), true, (IProgressMonitor)subMonitor.split(1));
                }
            });
            Collection selectedViews = session.getSelectedViews();
            if (!selectedViews.isEmpty()) {
                DView view = (DView)selectedViews.iterator().next();
                designViewpoint = view.getViewpoint();
            }
            if (!(representationDescription = DialectManager.INSTANCE.getAvailableRepresentationDescriptions(Arrays.asList(designViewpoint), model).stream().filter(desc -> desc.getName().equals("Entities")).findAny()).isPresent()) {
                Activator.error("Cannot create Sirius representation in project " + project.getName() + ": 'Entities' representation not found", null);
                return;
            }
            model.eAdapters().add((Object)new SessionTransientAttachment(session));
            session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(session.getTransactionalEditingDomain()){

                protected void doExecute() {
                    DialectManager.INSTANCE.createRepresentation(String.valueOf(project.getName()) + " class diagram", model, (RepresentationDescription)representationDescription.get(), session, (IProgressMonitor)subMonitor.split(1));
                }
            });
            new Job("Close Sirius session of project " + project.getName()){

                protected IStatus run(IProgressMonitor monitor) {
                    boolean sessionIsSaved;
                    boolean bl = sessionIsSaved = Job.getJobManager().find((Object)"org.eclipse.sirius.saveSessionJob").length == 0;
                    if (!sessionIsSaved) {
                        this.schedule(5L);
                    } else {
                        session.close((IProgressMonitor)new NullProgressMonitor());
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }

        private static Optional<Viewpoint> findDesignViewpoint(ViewpointRegistry registry) {
            return registry.getViewpoints().stream().filter(viewpoint -> registry.isFromPlugin(viewpoint)).filter(viewpoint -> "Design".equals(viewpoint.getName())).findAny();
        }

        private void addJavaNature(IProject project, IProgressMonitor monitor) throws CoreException {
            if (!this.description.activateJava) {
                return;
            }
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)6);
            try {
                subMonitor.setTaskName("Adding Java nature...");
                IProjectDescription desc = project.getDescription();
                String[] prevNatures = desc.getNatureIds();
                String[] newNatures = new String[prevNatures.length + 1];
                System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
                newNatures[prevNatures.length] = "org.eclipse.jdt.core.javanature";
                desc.setNatureIds(newNatures);
                project.setDescription(desc, (IProgressMonitor)subMonitor.split(1));
                subMonitor.setTaskName("Configuring classpath...");
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IFolder binFolder = project.getFolder("bin");
                binFolder.create(false, true, (IProgressMonitor)subMonitor.split(1));
                javaProject.setOutputLocation(binFolder.getFullPath(), (IProgressMonitor)subMonitor.split(1));
                ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
                entries.add(JavaRuntime.getDefaultJREContainerEntry());
                javaProject.setRawClasspath(entries.toArray(new IClasspathEntry[entries.size()]), (IProgressMonitor)subMonitor.split(1));
                IFolder sourceFolder = project.getFolder("src");
                sourceFolder.create(false, true, (IProgressMonitor)subMonitor.split(1));
                IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)sourceFolder);
                IClasspathEntry[] oldEntries = javaProject.getRawClasspath();
                IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
                System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
                newEntries[oldEntries.length] = JavaCore.newSourceEntry((IPath)root.getPath());
                javaProject.setRawClasspath(newEntries, (IProgressMonitor)subMonitor.split(1));
            }
            catch (NoClassDefFoundError e) {
                Activator.error("Unable to set Java nature to project '" + project.getName() + "': org.eclipse.jdt.core or org.eclipse.jdt.launching is not available", e);
            }
        }
    }
}

