/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.ide.listener;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecoretools.ale.ide.listener.AleWorkspaceListener;
import org.eclipse.emf.ecoretools.ale.ide.resource.AleResource;
import org.eclipse.emf.ecoretools.design.service.EcoreToolsDesignPlugin;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class AleSessionManagerListener
implements SessionManagerListener {
    public static final String BEHAVIOR_VP_ID = "Behavior";
    public static final String BEHAVIOR_LAYER = "Behavior";
    public static final String ECORE_VP_EXTENSION = "BehaviorEntities";
    public static final String IMPLEM_EXTENSION = "ale";
    public static final String DSL_EXTENSION = "dsl";
    AleWorkspaceListener wsListener;

    public void notifyAddSession(Session newSession) {
        this.registerEmfFactory(newSession);
        this.createDslIfNeeded(newSession);
    }

    public void notifyRemoveSession(Session removedSession) {
        this.removeWsListener(removedSession);
    }

    public void viewpointSelected(Viewpoint selectedSirius) {
    }

    public void viewpointDeselected(Viewpoint deselectedSirius) {
    }

    public void notify(Session updated, int notification) {
        if (notification == 0) {
            this.createDslIfNeeded(updated);
        }
    }

    private void createDslIfNeeded(Session session) {
        Optional<Viewpoint> behaviorVP = session.getSelectedViewpoints(true).stream().filter(vp -> vp.getName().equals("Behavior")).findFirst();
        if (behaviorVP.isPresent()) {
            this.getDsl(session).isPresent();
            this.createWsListener(session);
        }
    }

    private void registerEmfFactory(Session session) {
        TransactionalEditingDomain editingDomain = session.getTransactionalEditingDomain();
        ResourceSet rs = editingDomain.getResourceSet();
    }

    private Optional<Resource> getDsl(Session session) {
        List dslRes = session.getSemanticResources().stream().filter(r -> {
            String fileExt = r.getURI().fileExtension();
            if (fileExt != null) {
                return fileExt.equals(DSL_EXTENSION);
            }
            return false;
        }).collect(Collectors.toList());
        if (dslRes.isEmpty()) {
            return Optional.empty();
        }
        if (dslRes.size() == 1) {
            return Optional.of((Resource)dslRes.get(0));
        }
        return Optional.of((Resource)dslRes.get(0));
    }

    private void createAndRegisterDsl(final Session session) {
        List<Resource> mmRes = this.getMetamodels(session);
        if (!mmRes.isEmpty()) {
            Resource ecoreResource = mmRes.get(0);
            String ecoreURI = ecoreResource.getURI().toString();
            String aleURI = ecoreResource.getURI().trimFileExtension().appendFileExtension(IMPLEM_EXTENSION).toString();
            IFile file = WorkspaceSynchronizer.getFile((Resource)ecoreResource);
            IPath alePath = file.getFullPath().removeFileExtension().addFileExtension(IMPLEM_EXTENSION);
            IPath dslPath = file.getFullPath().removeFileExtension().addFileExtension(DSL_EXTENSION);
            String aleContent = "behavior " + this.getSimpleName(ecoreResource) + ";\n";
            String dslContent = "ecore=" + ecoreURI + "\n" + IMPLEM_EXTENSION + "=" + aleURI + "\n";
            this.createFile(alePath, aleContent);
            this.createFile(dslPath, dslContent);
            final URI dslURI = ecoreResource.getURI().trimFileExtension().appendFileExtension(DSL_EXTENSION);
            RecordingCommand cmd = new RecordingCommand(session.getTransactionalEditingDomain()){

                protected void doExecute() {
                    session.addSemanticResource(dslURI, (IProgressMonitor)new NullProgressMonitor());
                }
            };
            try {
                CommandStack commandStack = session.getTransactionalEditingDomain().getCommandStack();
                commandStack.execute((Command)cmd);
            }
            catch (Exception e) {
                EcoreToolsDesignPlugin.INSTANCE.log((Object)e);
            }
        }
    }

    private void createWsListener(Session session) {
        Optional<Resource> dslRes;
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        if (this.wsListener != null) {
            ws.removeResourceChangeListener((IResourceChangeListener)this.wsListener);
            System.out.println("debug remove");
        }
        if ((dslRes = this.getDsl(session)).isPresent()) {
            AleResource res = (AleResource)dslRes.get();
            this.wsListener = new AleWorkspaceListener(session, (Resource)res);
            ws.addResourceChangeListener((IResourceChangeListener)this.wsListener);
            res.getParseResult().forEach(parse -> {
                String filePath = parse.getSourceFile();
                Path path = new Path(filePath);
                IFile file = null;
                file = path.isAbsolute() ? ws.getRoot().getFileForLocation((IPath)path) : ws.getRoot().getFile((IPath)path);
                this.wsListener.listen(file);
            });
        }
    }

    private void removeWsListener(Session session) {
        if (this.wsListener != null) {
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            ws.removeResourceChangeListener((IResourceChangeListener)this.wsListener);
            System.out.println("debug remove");
        }
    }

    private List<Resource> getMetamodels(Session session) {
        List<Resource> mmRes = session.getSemanticResources().stream().filter(res -> this.isMetamodel((Resource)res)).collect(Collectors.toList());
        return mmRes;
    }

    private boolean isMetamodel(Resource res) {
        String fileExt = res.getURI().fileExtension();
        return fileExt != null && fileExt.equals("ecore");
    }

    private String getSimpleName(Resource ecoreRes) {
        return ecoreRes.getURI().lastSegment().replaceAll("\\.ecore", "");
    }

    private void createFile(IPath filePath, String fileContent) {
        IWorkspaceRoot ws = ResourcesPlugin.getWorkspace().getRoot();
        IFile dslFile = ws.getFile(filePath);
        ByteArrayInputStream source = new ByteArrayInputStream(fileContent.getBytes());
        try {
            if (!dslFile.exists()) {
                dslFile.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            EcoreToolsDesignPlugin.INSTANCE.log((Object)e);
        }
    }
}

