/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.sequential.javaxdsml.ide.ui.editor;

import fr.inria.diverse.melange.metamodel.melange.Language;
import fr.inria.diverse.melange.metamodel.melange.ModelTypingSpace;
import fr.inria.diverse.melange.ui.contentassist.IProposal;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecoretools.design.ui.wizard.EcoreModelerWizard;
import org.eclipse.gemoc.commons.eclipse.core.resources.FileFinderVisitor;
import org.eclipse.gemoc.commons.eclipse.core.resources.NewProjectWorkspaceListener;
import org.eclipse.gemoc.commons.eclipse.pde.manifest.ManifestChanger;
import org.eclipse.gemoc.commons.eclipse.ui.WizardFinder;
import org.eclipse.gemoc.xdsmlframework.ide.ui.Activator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class CreateEcoreProposal
implements IProposal {
    private IProject ecoreProject;
    private String packageName = "packageName";
    private String languageName = "languageName";

    public String getDisplayText() {
        return "-- Create a Domain Model Project --";
    }

    public String getReplacementText() {
        IWizardDescriptor descriptor = WizardFinder.findNewWizardDescriptor((String)"org.eclipse.ecoretools.emf.design.wizardID");
        if (descriptor != null) {
            NewProjectWorkspaceListener workspaceListener = new NewProjectWorkspaceListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)workspaceListener);
            try {
                try {
                    IWorkbenchWizard wizard = descriptor.createWizard();
                    String newProjectName = (String.valueOf(this.packageName) + "." + this.languageName + ".model").toLowerCase();
                    ((EcoreModelerWizard)wizard).setInitialProjectName(newProjectName);
                    ((EcoreModelerWizard)wizard).init(PlatformUI.getWorkbench(), null);
                    WizardDialog wd = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                    wd.create();
                    wd.setTitle(wizard.getWindowTitle());
                    int res = wd.open();
                    if (res == 0) {
                        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)workspaceListener);
                        this.ecoreProject = workspaceListener.getLastCreatedProject();
                    }
                }
                catch (CoreException e) {
                    Activator.error((String)e.getMessage(), (Throwable)e);
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)workspaceListener);
                    if (this.ecoreProject != null) {
                        return this.getCreatedEcoreUri();
                    }
                }
            }
            finally {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)workspaceListener);
                if (this.ecoreProject != null) {
                    return this.getCreatedEcoreUri();
                }
            }
        }
        return "";
    }

    public void configureProject(IProject project) {
        ManifestChanger manifestChanger = new ManifestChanger(project);
        try {
            manifestChanger.addPluginDependency(this.ecoreProject.getName());
            manifestChanger.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getCreatedEcoreUri() {
        FileFinderVisitor ecoreProjectVisitor = new FileFinderVisitor("ecore");
        try {
            this.ecoreProject.accept((IResourceVisitor)ecoreProjectVisitor);
            IFile ecoreIFile = ecoreProjectVisitor.getFile();
            if (ecoreIFile != null) {
                return "syntax \"platform:/resource" + ecoreIFile.getFullPath().toString() + "\"";
            }
        }
        catch (CoreException e) {
            Activator.error((String)e.getMessage(), (Throwable)e);
        }
        return "";
    }

    public void configureProposal(EObject context) {
        if (context instanceof Language) {
            Language lang = (Language)context;
            this.packageName = ((ModelTypingSpace)lang.eContainer()).getName();
            this.languageName = lang.getName();
        }
    }
}

