/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.event.ui.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gemoc.executionframework.behavioralinterface.behavioralInterface.BehavioralInterface;
import org.eclipse.gemoc.executionframework.behavioralinterface.behavioralInterface.Event;
import org.eclipse.gemoc.executionframework.behavioralinterface.behavioralInterface.EventParameter;
import org.eclipse.gemoc.executionframework.behavioralinterface.behavioralInterface.EventType;
import org.eclipse.gemoc.executionframework.event.manager.IEventManager;
import org.eclipse.gemoc.executionframework.event.manager.IEventManagerListener;
import org.eclipse.gemoc.executionframework.event.model.event.EventOccurrence;
import org.eclipse.gemoc.executionframework.event.ui.views.EventOccurrenceConfigurator;
import org.eclipse.gemoc.executionframework.ui.views.engine.EngineSelectionDependentViewPart;
import org.eclipse.gemoc.executionframework.value.model.value.BooleanAttributeValue;
import org.eclipse.gemoc.executionframework.value.model.value.BooleanObjectAttributeValue;
import org.eclipse.gemoc.executionframework.value.model.value.FloatAttributeValue;
import org.eclipse.gemoc.executionframework.value.model.value.FloatObjectAttributeValue;
import org.eclipse.gemoc.executionframework.value.model.value.IntegerAttributeValue;
import org.eclipse.gemoc.executionframework.value.model.value.IntegerObjectAttributeValue;
import org.eclipse.gemoc.executionframework.value.model.value.SingleReferenceValue;
import org.eclipse.gemoc.executionframework.value.model.value.StringAttributeValue;
import org.eclipse.gemoc.executionframework.value.model.value.Value;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.IEngineAddon;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;

public class EventManagerViewPart
extends EngineSelectionDependentViewPart
implements IEngineAddon {
    public static final String ID = "org.eclipse.gemoc.executionframework.event.ui.views.EventManager";
    private IEventManager eventManager;
    private final List<BehavioralInterface> behavioralInterfaces = new ArrayList<BehavioralInterface>();
    private final List<Event> events = new ArrayList<Event>();
    private final List<BehavioralInterface> selectedBehavioralInterfaces = new ArrayList<BehavioralInterface>();
    private final Map<EventParameter, EClass> parameterToParameterClass = new HashMap<EventParameter, EClass>();
    private final Map<EClass, List<EObject>> parameterClassToMatchingModelElements = new HashMap<EClass, List<EObject>>();
    private Resource executedModel;
    private EPackage ePackage;
    private org.eclipse.swt.widgets.List behavioralInterfaceList;
    private org.eclipse.swt.widgets.List exposedEventOccurrenceList;
    private Group eventOccurrenceConfiguratorGroup;
    private final Map<Event, List<EventOccurrence>> eventToEventOccurrences = new HashMap<Event, List<EventOccurrence>>();
    private IExecutionEngine<?> executionEngine;
    private final IEventManagerListener eventListener = new IEventManagerListener(){

        public Set<BehavioralInterface> getBehavioralInterfaces() {
            return EventManagerViewPart.this.eventManager.getBehavioralInterfaces();
        }

        public void eventReceived(EventOccurrence event) {
            final String s = String.valueOf(event.getEvent().getName()) + "(" + event.getArgs().stream().map(a -> EventManagerViewPart.this.getValueString(a.getValue())).reduce((s1, s2) -> String.valueOf(s1) + ", " + s2).orElse("") + ")";
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    (this).EventManagerViewPart.this.exposedEventOccurrenceList.add(s, 0);
                }
            });
        }
    };
    private final DefaultDeclarativeQualifiedNameProvider nameProvider = new DefaultDeclarativeQualifiedNameProvider();
    private final Function<Object, String> namingFunction = o -> {
        if (o == null) {
            return null;
        }
        if (o instanceof EObject) {
            EObject eObject = (EObject)o;
            QualifiedName fqn = this.nameProvider.apply(eObject);
            if (fqn == null || fqn.isEmpty()) {
                if (eObject.eResource() == null) {
                    String s = o.toString();
                    return s.substring(s.lastIndexOf(".") + 1);
                }
                return eObject.eResource().getURIFragment(eObject);
            }
            return fqn.getLastSegment();
        }
        String s = o.toString();
        return s.substring(s.lastIndexOf(".") + 1);
    };

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm(parent, 256);
        this.createBehavioralInterfaceList((Composite)sashForm);
        this.createEventOccurrenceConfiguratorList((Composite)sashForm);
        this.createExposedEventOccurrenceList((Composite)sashForm);
        sashForm.setWeights(new int[]{3, 5, 2});
    }

    private Group createSimpleGroup(Composite parent, String text) {
        Group group = new Group(parent, 0);
        group.setText(text);
        GridLayout locationLayout = new GridLayout();
        locationLayout.marginHeight = 10;
        locationLayout.marginWidth = 10;
        group.setLayout((Layout)locationLayout);
        return group;
    }

    private void createBehavioralInterfaceList(Composite parent) {
        Group group = this.createSimpleGroup(parent, "Behavioral Interfaces");
        this.behavioralInterfaceList = new org.eclipse.swt.widgets.List((Composite)group, 2562);
        GridData gd = new GridData(1808);
        this.behavioralInterfaceList.setLayoutData((Object)gd);
        this.behavioralInterfaceList.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.selectBehavioralInterface()));
    }

    private void createEventOccurrenceConfiguratorList(Composite parent) {
        this.eventOccurrenceConfiguratorGroup = this.createSimpleGroup(parent, "Accepted Event Occurrences");
    }

    private void createExposedEventOccurrenceList(Composite parent) {
        Group group = this.createSimpleGroup(parent, "Exposed Event Occurrences");
        this.exposedEventOccurrenceList = new org.eclipse.swt.widgets.List((Composite)group, 2560);
        GridData gd = new GridData(1808);
        this.exposedEventOccurrenceList.setLayoutData((Object)gd);
    }

    private void fillBehavioralInterfaceList(Set<BehavioralInterface> behavioralInterfaces) {
        this.behavioralInterfaces.addAll(behavioralInterfaces);
        this.behavioralInterfaceList.setItems(this.behavioralInterfaces.stream().map(itf -> itf.getName()).collect(Collectors.toList()).toArray(new String[0]));
        this.refreshEventParameters();
        this.refreshEventArguments();
        this.behavioralInterfaceList.select(0);
        this.selectBehavioralInterface();
    }

    private void selectBehavioralInterface() {
        this.clearEventOccurrenceConfiguratorGroup();
        this.selectedBehavioralInterfaces.clear();
        Arrays.stream(this.behavioralInterfaceList.getSelectionIndices()).forEach(i -> {
            boolean bl = this.selectedBehavioralInterfaces.add(this.behavioralInterfaces.get(i));
        });
        this.fillEventOccurrenceConfiguratorGroup((Composite)this.eventOccurrenceConfiguratorGroup);
    }

    private void clearBehavioralInterfaceList() {
        this.clearEventOccurrenceConfiguratorGroup();
        this.parameterToParameterClass.clear();
        this.parameterClassToMatchingModelElements.clear();
        this.exposedEventOccurrenceList.removeAll();
        this.behavioralInterfaceList.removeAll();
    }

    private void fillEventOccurrenceConfiguratorGroup(Composite parent) {
        ScrolledComposite scroll = new ScrolledComposite(parent, 512);
        scroll.setLayout((Layout)new GridLayout(1, false));
        scroll.setLayoutData((Object)new GridData(4, 4, true, true));
        scroll.setBackgroundMode(0);
        Composite content = new Composite((Composite)scroll, 0);
        content.setLayout((Layout)new GridLayout(1, false));
        content.setLayoutData((Object)new GridData(4, 1, true, false));
        this.selectedBehavioralInterfaces.stream().flatMap(b -> b.getEvents().stream()).filter(e -> e.getType() != EventType.EXPOSED).forEach(e -> {
            EventOccurrenceConfigurator eventOccurrenceConfigurator = new EventOccurrenceConfigurator(content, this.eventManager, (Event)e, this.parameterToParameterClass, this.parameterClassToMatchingModelElements, this.namingFunction);
        });
        scroll.setContent((Control)content);
        scroll.setExpandHorizontal(true);
        scroll.setExpandVertical(true);
        scroll.setMinSize(content.computeSize(-1, -1));
    }

    private void clearEventOccurrenceConfiguratorGroup() {
        Arrays.stream(this.eventOccurrenceConfiguratorGroup.getChildren()).forEach(c -> c.dispose());
    }

    private void refreshEventParameters() {
        this.behavioralInterfaces.forEach(itf -> itf.getEvents().forEach(e -> e.getParams().forEach(param -> this.parameterToParameterClass.computeIfAbsent((EventParameter)param, p -> {
            String type = p.getType();
            EClass result = null;
            switch (type) {
                default: {
                    return this.ePackage.getEClassifiers().stream().filter(c -> c instanceof EClass && ((EClass)c).getInstanceTypeName().equals(type)).findFirst().map(c -> (EClass)c).orElse(null);
                }
                case "java.lang.Integer": 
                case "java.lang.Float": 
                case "int": 
                case "boolean": 
                case "float": 
                case "java.lang.Boolean": 
                case "java.lang.String": 
            }
            return result;
        }))));
    }

    private void refreshEventArguments() {
        this.parameterToParameterClass.values().forEach(c -> {
            List elements = this.parameterClassToMatchingModelElements.computeIfAbsent((EClass)c, k -> new ArrayList());
            this.executedModel.getAllContents().forEachRemaining(modelElement -> {
                EClass elementClass = modelElement.eClass();
                if (c.getEPackage() == elementClass.getEPackage() && (elementClass.getClassifierID() == c.getClassifierID() || elementClass.getEAllSuperTypes().contains(c)) && !elements.contains(modelElement)) {
                    elements.add(modelElement);
                }
            });
        });
    }

    protected Label createTextLabelLayout(Composite parent, String labelString) {
        GridData gd = new GridData(768);
        parent.setLayoutData((Object)gd);
        Label inputLabel = new Label(parent, 0);
        inputLabel.setText(labelString);
        return inputLabel;
    }

    private void setExecutedModel(Resource executedModel) {
        this.executedModel = executedModel;
        this.ePackage = this.executedModel.getContents().stream().findFirst().map(o -> o.eClass().getEPackage()).orElse(null);
    }

    public void engineSelectionChanged(IExecutionEngine<?> engine) {
        this.executionEngine = engine;
        if (this.eventManager != null) {
            this.eventManager.removeListener(this.eventListener);
            this.exposedEventOccurrenceList.removeAll();
        }
        this.behavioralInterfaces.clear();
        this.clearBehavioralInterfaceList();
        this.clearEventOccurrenceConfiguratorGroup();
        if (this.executionEngine != null) {
            this.setExecutedModel(this.executionEngine.getExecutionContext().getResourceModel());
            this.eventManager = this.executionEngine.getAddonsTypedBy(IEventManager.class).stream().findFirst().orElse(null);
            this.eventManager.addListener(this.eventListener);
            this.events.clear();
            this.fillBehavioralInterfaceList(this.eventManager.getBehavioralInterfaces());
            this.executionEngine.getExecutionContext().getExecutionPlatform().addEngineAddon((IEngineAddon)this);
        } else {
            this.executedModel = null;
            this.events.clear();
            this.eventToEventOccurrences.clear();
        }
    }

    private String getValueString(Value val) {
        String result = "";
        switch (val.eClass().getClassifierID()) {
            case 3: {
                result = String.valueOf(result) + ((BooleanAttributeValue)val).isAttributeValue();
                break;
            }
            case 4: {
                result = String.valueOf(result) + ((BooleanObjectAttributeValue)val).getAttributeValue();
                break;
            }
            case 5: {
                result = String.valueOf(result) + ((IntegerAttributeValue)val).getAttributeValue();
                break;
            }
            case 6: {
                result = String.valueOf(result) + ((IntegerObjectAttributeValue)val).getAttributeValue();
                break;
            }
            case 9: {
                result = String.valueOf(result) + ((FloatAttributeValue)val).getAttributeValue();
                break;
            }
            case 10: {
                result = String.valueOf(result) + ((FloatObjectAttributeValue)val).getAttributeValue();
                break;
            }
            case 11: {
                result = String.valueOf(result) + ((StringAttributeValue)val).getAttributeValue();
                break;
            }
            case 21: {
                result = String.valueOf(result) + this.namingFunction.apply(((SingleReferenceValue)val).getReferenceValue());
            }
        }
        return result;
    }

    public void setFocus() {
    }

    public void aboutToExecuteStep(IExecutionEngine<?> engine, Step<?> stepToExecute) {
        this.refreshEventArguments();
    }

    public void stepExecuted(IExecutionEngine<?> engine, Step<?> stepExecuted) {
        this.refreshEventArguments();
    }

    static /* synthetic */ String access$0(EventManagerViewPart eventManagerViewPart, Value value) {
        return eventManagerViewPart.getValueString(value);
    }
}

