/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.gexpressions.utils;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gemoc.gexpressions.GAdditionExpression;
import org.eclipse.gemoc.gexpressions.GAndExpression;
import org.eclipse.gemoc.gexpressions.GBooleanExpression;
import org.eclipse.gemoc.gexpressions.GBraceExpression;
import org.eclipse.gemoc.gexpressions.GDoubleExpression;
import org.eclipse.gemoc.gexpressions.GEnumLiteralExpression;
import org.eclipse.gemoc.gexpressions.GEqualityExpression;
import org.eclipse.gemoc.gexpressions.GIfExpression;
import org.eclipse.gemoc.gexpressions.GIntegerExpression;
import org.eclipse.gemoc.gexpressions.GMultiplicationExpression;
import org.eclipse.gemoc.gexpressions.GNavigationExpression;
import org.eclipse.gemoc.gexpressions.GNegationExpression;
import org.eclipse.gemoc.gexpressions.GOrExpression;
import org.eclipse.gemoc.gexpressions.GReferenceExpression;
import org.eclipse.gemoc.gexpressions.GRelationExpression;
import org.eclipse.gemoc.gexpressions.GStringExpression;
import org.eclipse.gemoc.gexpressions.GXorExpression;
import org.eclipse.gemoc.gexpressions.util.GexpressionsSwitch;

public class GExpressionsInterpreter
extends GexpressionsSwitch<Object> {
    @Override
    public Object caseGNavigationExpression(GNavigationExpression object) {
        EObject referencedEObject = object.getReferencedEObject();
        if (referencedEObject instanceof EStructuralFeature) {
            EStructuralFeature feature = (EStructuralFeature)referencedEObject;
            Object previousObject = this.doSwitch(object.getBody());
            EObject eo = (EObject)previousObject;
            if (eo instanceof EClass) {
                return ((EClass)eo).getEStructuralFeature(feature.getName()).getEType();
            }
            return eo.eGet(eo.eClass().getEStructuralFeature(feature.getName()));
        }
        if (referencedEObject instanceof EOperation) {
            EOperation operation = (EOperation)referencedEObject;
            Object previousObject = this.doSwitch(object.getBody());
            EObject eo = (EObject)previousObject;
            if (eo instanceof EClass) {
                return ((EClass)eo).getEOperation(operation.getOperationID());
            }
            return eo.eClass().getEOperation(operation.getOperationID());
        }
        return object.getReferencedEObject();
    }

    @Override
    public Object caseGReferenceExpression(GReferenceExpression object) {
        return object.getReferencedObject() == null ? object.getReferencedEObject() : object.getReferencedObject();
    }

    @Override
    public Object caseGStringExpression(GStringExpression object) {
        return object.getValue();
    }

    @Override
    public Object caseGBooleanExpression(GBooleanExpression object) {
        return object.isValue();
    }

    @Override
    public Object caseGIntegerExpression(GIntegerExpression object) {
        return object.getValue();
    }

    @Override
    public Object caseGDoubleExpression(GDoubleExpression object) {
        return object.getValue();
    }

    @Override
    public Object caseGIfExpression(GIfExpression object) {
        Boolean conditionResult = (Boolean)this.doSwitch(object.getCondition());
        if (conditionResult.booleanValue()) {
            return this.doSwitch(object.getThenExpression());
        }
        return this.doSwitch(object.getElseExpression());
    }

    @Override
    public Object caseGBraceExpression(GBraceExpression object) {
        return this.doSwitch(object.getInnerExpression());
    }

    @Override
    public Object caseGEnumLiteralExpression(GEnumLiteralExpression object) {
        return object.getValue();
    }

    @Override
    public Object caseGAndExpression(GAndExpression object) {
        if (((Boolean)this.doSwitch(object.getLeftOperand())).booleanValue() && ((Boolean)this.doSwitch(object.getRightOperand())).booleanValue()) {
            return true;
        }
        return false;
    }

    @Override
    public Object caseGXorExpression(GXorExpression object) {
        return (Boolean)this.doSwitch(object.getLeftOperand()) ^ (Boolean)this.doSwitch(object.getRightOperand());
    }

    @Override
    public Object caseGOrExpression(GOrExpression object) {
        if (!((Boolean)this.doSwitch(object.getLeftOperand())).booleanValue() && !((Boolean)this.doSwitch(object.getRightOperand())).booleanValue()) {
            return false;
        }
        return true;
    }

    @Override
    public Object caseGEqualityExpression(GEqualityExpression object) {
        Object leftValue = this.doSwitch(object.getLeftOperand());
        Object rightValue = this.doSwitch(object.getRightOperand());
        switch (object.getOperator()) {
            case EQUAL: {
                if (leftValue instanceof Comparable && rightValue instanceof Comparable) {
                    if (((Comparable)leftValue).compareTo((Comparable)rightValue) == 0) {
                        return true;
                    }
                    return false;
                }
                return leftValue.equals(rightValue);
            }
            case NOTEQUAL: {
                if (leftValue instanceof Comparable && rightValue instanceof Comparable) {
                    if (((Comparable)leftValue).compareTo((Comparable)rightValue) != 0) {
                        return true;
                    }
                    return false;
                }
                return !leftValue.equals(rightValue);
            }
        }
        throw new UnsupportedOperationException("Could not determine the type of the operator: " + (Object)((Object)object.getOperator()));
    }

    @Override
    public Object caseGRelationExpression(GRelationExpression object) {
        switch (object.getOperator()) {
            case GREATER: {
                if (((Comparable)this.doSwitch(object.getLeftOperand())).compareTo((Comparable)this.doSwitch(object.getRightOperand())) > 0) {
                    return true;
                }
                return false;
            }
            case GREATEREQUAL: {
                if (((Comparable)this.doSwitch(object.getLeftOperand())).compareTo((Comparable)this.doSwitch(object.getRightOperand())) >= 0) {
                    return true;
                }
                return false;
            }
            case LESS: {
                if (((Comparable)this.doSwitch(object.getLeftOperand())).compareTo((Comparable)this.doSwitch(object.getRightOperand())) < 0) {
                    return true;
                }
                return false;
            }
            case LESSEQUAL: {
                if (((Comparable)this.doSwitch(object.getLeftOperand())).compareTo((Comparable)this.doSwitch(object.getRightOperand())) <= 0) {
                    return true;
                }
                return false;
            }
        }
        throw new UnsupportedOperationException("Could not determine the type of the operator: " + (Object)((Object)object.getOperator()));
    }

    @Override
    public Object caseGAdditionExpression(GAdditionExpression object) {
        Object op1 = this.doSwitch(object.getLeftOperand());
        Object op2 = this.doSwitch(object.getRightOperand());
        switch (object.getOperator()) {
            case ADDITION: {
                return this.addition(op1, op2);
            }
            case SUBTRACTION: {
                return this.subtraction(op1, op2);
            }
        }
        throw new UnsupportedOperationException("Could not determine the type of the operator: " + (Object)((Object)object.getOperator()));
    }

    private Object addition(Object op1, Object op2) {
        if (op1 instanceof String || op2 instanceof String) {
            return String.valueOf(String.valueOf(op1)) + String.valueOf(op2);
        }
        if (!(op1 instanceof Number) || !(op2 instanceof Number)) {
            throw new UnsupportedOperationException("Invalid operands for mathematical operator [+]");
        }
        if (op1 instanceof Double || op2 instanceof Double) {
            return ((Number)op1).doubleValue() + ((Number)op2).doubleValue();
        }
        if (op1 instanceof Float || op2 instanceof Float) {
            return Float.valueOf(((Number)op1).floatValue() + ((Number)op2).floatValue());
        }
        if (op1 instanceof Long || op2 instanceof Long) {
            return ((Number)op1).longValue() + ((Number)op2).longValue();
        }
        return ((Number)op1).intValue() + ((Number)op2).intValue();
    }

    private Object subtraction(Object op1, Object op2) {
        if (!(op1 instanceof Number) || !(op2 instanceof Number)) {
            throw new UnsupportedOperationException("Invalid operands for mathematical operator [-]");
        }
        if (op1 instanceof Double || op2 instanceof Double) {
            return ((Number)op1).doubleValue() - ((Number)op2).doubleValue();
        }
        if (op1 instanceof Float || op2 instanceof Float) {
            return Float.valueOf(((Number)op1).floatValue() - ((Number)op2).floatValue());
        }
        if (op1 instanceof Long || op2 instanceof Long) {
            return ((Number)op1).longValue() - ((Number)op2).longValue();
        }
        return ((Number)op1).intValue() - ((Number)op2).intValue();
    }

    @Override
    public Object caseGMultiplicationExpression(GMultiplicationExpression object) {
        Object op1 = this.doSwitch(object.getLeftOperand());
        Object op2 = this.doSwitch(object.getRightOperand());
        switch (object.getOperator()) {
            case MULTIPLICATION: {
                return this.multiplication(op1, op2);
            }
            case DIVISION: {
                return this.division(op1, op2);
            }
        }
        throw new UnsupportedOperationException("Could not determine the type of the operator: " + (Object)((Object)object.getOperator()));
    }

    private Object multiplication(Object op1, Object op2) {
        if (!(op1 instanceof Number) || !(op2 instanceof Number)) {
            throw new UnsupportedOperationException("Invalid operands for mathematical operator [*]");
        }
        if (op1 instanceof Double || op2 instanceof Double) {
            return ((Number)op1).doubleValue() * ((Number)op2).doubleValue();
        }
        if (op1 instanceof Float || op2 instanceof Float) {
            return Float.valueOf(((Number)op1).floatValue() * ((Number)op2).floatValue());
        }
        if (op1 instanceof Long || op2 instanceof Long) {
            return ((Number)op1).longValue() * ((Number)op2).longValue();
        }
        return ((Number)op1).intValue() * ((Number)op2).intValue();
    }

    private Object division(Object op1, Object op2) {
        if (!(op1 instanceof Number) || !(op2 instanceof Number)) {
            throw new UnsupportedOperationException("Invalid operands for mathematical operator [/]");
        }
        if (op1 instanceof Double || op2 instanceof Double) {
            return ((Number)op1).doubleValue() / ((Number)op2).doubleValue();
        }
        if (op1 instanceof Float || op2 instanceof Float) {
            return Float.valueOf(((Number)op1).floatValue() / ((Number)op2).floatValue());
        }
        if (op1 instanceof Long || op2 instanceof Long) {
            return ((Number)op1).longValue() / ((Number)op2).longValue();
        }
        return ((Number)op1).intValue() / ((Number)op2).intValue();
    }

    @Override
    public Object caseGNegationExpression(GNegationExpression object) {
        Object op = this.doSwitch(object.getOperand());
        switch (object.getOperator()) {
            case MINUS: {
                return this.subtraction(0, op);
            }
            case NEGATION: {
                return this.negation(op);
            }
        }
        throw new UnsupportedOperationException("Could not determine the type of the operator: " + (Object)((Object)object.getOperator()));
    }

    private Object negation(Object op) {
        if (!(op instanceof Boolean)) {
            throw new UnsupportedOperationException("Cannot apply negation on non-boolean object");
        }
        Boolean b = (Boolean)op;
        return b == false;
    }
}

