/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.timeline.editpart;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gemoc.timeline.editpart.BranchEditPart;
import org.eclipse.gemoc.timeline.layout.LineLayout;
import org.eclipse.gemoc.timeline.model.Choice;
import org.eclipse.gemoc.timeline.model.PossibleStep;

public class ChoiceEditPart
extends AbstractGraphicalEditPart {
    public static final int SPACING = 5;
    private Label label;

    protected IFigure createFigure() {
        LineLayout layout = new LineLayout();
        layout.setHorizontal(false);
        layout.setMajorAlignment(1);
        layout.setMinorAlignment(1);
        layout.setMinorSpacing(5);
        FreeformLayer res = new FreeformLayer();
        res.setLayoutManager((LayoutManager)layout);
        this.label = new Label();
        res.add((IFigure)this.label);
        return res;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        if (this.getModel().hasSelected()) {
            ((LineLayout)this.getFigure().getLayoutManager()).setMinorAlignment(0);
            this.align();
        }
        this.label.setText(String.valueOf(this.getModel().getIndex()));
    }

    private void align() {
        block5: {
            int offset;
            int existing;
            IFigure figure;
            block4: {
                figure = this.getFigure();
                existing = 0;
                while (figure.getChildren().size() - existing - 2 >= 0 && figure.getChildren().get(figure.getChildren().size() - existing - 2) instanceof PaddingFigure) {
                    ++existing;
                }
                offset = ((BranchEditPart)this.getParent()).getModel().getTimelineWindow().getMaxSelectedIndex(this.getModel().getBranch()) - this.getModel().getConnectedIndex();
                if (existing >= offset) break block4;
                int i = 0;
                while (i < offset - existing) {
                    figure.add((IFigure)new PaddingFigure(), figure.getChildren().size() - 1);
                    ++i;
                }
                break block5;
            }
            if (existing <= offset) break block5;
            int i = 1;
            while (i <= existing - offset) {
                IFigure toRemoveFigure;
                if (figure.getChildren().size() - 2 >= 0 && (toRemoveFigure = (IFigure)figure.getChildren().get(figure.getChildren().size() - 2)) instanceof PaddingFigure) {
                    figure.remove(toRemoveFigure);
                }
                ++i;
            }
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new XYLayoutEditPolicy(){

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        });
    }

    public List<PossibleStep> getModelChildren() {
        ArrayList<PossibleStep> res = new ArrayList<PossibleStep>();
        List<PossibleStep> possibleSteps = this.getModel().getPossibleSteps();
        int i = possibleSteps.size() - 1;
        while (i >= 0) {
            res.add(possibleSteps.get(i));
            --i;
        }
        return res;
    }

    public Choice getModel() {
        return (Choice)super.getModel();
    }

    private static final class PaddingFigure
    extends Ellipse {
        public PaddingFigure() {
            this.setBackgroundColor(ColorConstants.listBackground);
            this.setForegroundColor(ColorConstants.listBackground);
            this.setSize(20, 20);
        }
    }
}

