/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.xdsmlframework.extensions.sirius.wizards.pages;

import org.eclipse.gemoc.xdsmlframework.extensions.sirius.wizards.NewGemocDebugRepresentationWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewViewPointProjectPage
extends WizardPage {
    private final NewGemocDebugRepresentationWizard newGemocDebugRepresentationWizard;
    private Text projectNameText;
    private Text viewpointSpecificationModelText;
    private Text viewpointNameText;
    private Text diagramNameText;
    private DiagramDescription diagramToExtends;

    public NewViewPointProjectPage(NewGemocDebugRepresentationWizard newGemocDebugRepresentationWizard) {
        super("Create Viewpoint definition project");
        this.newGemocDebugRepresentationWizard = newGemocDebugRepresentationWizard;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewViewPointProjectPage.this.setPageComplete(this.isSet(NewViewPointProjectPage.this.diagramNameText) && this.isSet(NewViewPointProjectPage.this.projectNameText) && this.isSet(NewViewPointProjectPage.this.viewpointNameText) && this.isSet(NewViewPointProjectPage.this.viewpointSpecificationModelText));
            }

            private boolean isSet(Text text) {
                return text != null && !"".equals(text.getText());
            }
        };
        this.projectNameText = this.createProjectNameComposite(composite, listener);
        this.viewpointSpecificationModelText = this.createViewpointSpecificationModelNameComposite(composite, listener);
        this.viewpointNameText = this.createViewpointNameComposite(composite, listener);
        this.diagramNameText = this.createDiagramNameComposite(composite, listener);
        this.setControl((Control)composite);
        this.setPageComplete(true);
    }

    private Text createProjectNameComposite(Composite composite, ModifyListener listener) {
        Composite projectNameComposite = new Composite(composite, 0);
        projectNameComposite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectNameComposite.setLayout((Layout)layout);
        Label label = new Label(projectNameComposite, 0);
        label.setText("Project Name:");
        Text text = new Text(projectNameComposite, 4);
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(listener);
        text.setText(String.valueOf(this.newGemocDebugRepresentationWizard.getInitialProjectName()) + ".debug.design");
        return text;
    }

    private Text createViewpointSpecificationModelNameComposite(Composite composite, ModifyListener listener) {
        Composite projectNameComposite = new Composite(composite, 0);
        projectNameComposite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectNameComposite.setLayout((Layout)layout);
        Label label = new Label(projectNameComposite, 0);
        label.setText("Viewpoint Specification Model name:");
        Text text = new Text(projectNameComposite, 4);
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(listener);
        text.setText(String.valueOf(this.newGemocDebugRepresentationWizard.getInitialLanguageName()) + ".odesign");
        return text;
    }

    private Text createViewpointNameComposite(Composite composite, ModifyListener listener) {
        Composite projectNameComposite = new Composite(composite, 0);
        projectNameComposite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectNameComposite.setLayout((Layout)layout);
        Label label = new Label(projectNameComposite, 0);
        label.setText("Viewpoint Name:");
        Text text = new Text(projectNameComposite, 4);
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(listener);
        text.setText(String.valueOf(this.newGemocDebugRepresentationWizard.getInitialLanguageName()) + "Viewpoint");
        return text;
    }

    private Text createDiagramNameComposite(Composite composite, ModifyListener listener) {
        Composite projectNameComposite = new Composite(composite, 0);
        projectNameComposite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectNameComposite.setLayout((Layout)layout);
        Label label = new Label(projectNameComposite, 0);
        label.setText("Diagram Name:");
        Text text = new Text(projectNameComposite, 4);
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(listener);
        text.setText(this.newGemocDebugRepresentationWizard.getInitialLanguageName());
        return text;
    }

    public IWizardPage getNextPage() {
        return this.newGemocDebugRepresentationWizard.getAddDebugRepresentationPage();
    }

    public String getProjectName() {
        return this.projectNameText.getText();
    }

    public String getViewpointSpecificationModelName() {
        return this.viewpointSpecificationModelText.getText();
    }

    public void setDiagramToExtend(DiagramDescription diagram) {
        this.diagramToExtends = diagram;
    }

    public DiagramDescription getDiagramToExtends() {
        return this.diagramToExtends;
    }

    public String getViewpointName() {
        return this.viewpointNameText.getText();
    }

    public String getDiagramName() {
        return this.diagramNameText.getText();
    }
}

