/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.graph;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.glsp.graph.GEdge;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.impl.GModelIndexImpl;

public interface GModelIndex {
    public static GModelIndex get(GModelElement element) {
        EObject root = EcoreUtil.getRootContainer((EObject)element);
        GModelIndexImpl existingIndex = (GModelIndexImpl)EcoreUtil.getExistingAdapter((Notifier)root, GModelIndexImpl.class);
        return Optional.ofNullable(existingIndex).orElseGet(() -> GModelIndex.create(element));
    }

    public static GModelIndex create(GModelElement element) {
        return new GModelIndexImpl(EcoreUtil.getRootContainer((EObject)element));
    }

    public static void remove(GModelElement element) {
        EObject root = EcoreUtil.getRootContainer((EObject)element);
        GModelIndexImpl existingIndex = (GModelIndexImpl)EcoreUtil.getExistingAdapter((Notifier)root, GModelIndexImpl.class);
        if (existingIndex == null) {
            return;
        }
        existingIndex.unsetTarget((Notifier)root);
    }

    public Optional<GModelElement> get(String var1);

    public Set<GModelElement> getAll(Collection<String> var1);

    public Collection<GEdge> getIncomingEdges(GModelElement var1);

    public Collection<GEdge> getOutgoingEdges(GModelElement var1);

    public Set<String> allIds();

    public GModelElement getRoot();

    public int getCounter(EClass var1, Function<Integer, String> var2);

    default public <T extends GModelElement> Optional<T> findElementByClass(String elementId, Class<T> clazz) {
        Optional<GModelElement> element = this.get(elementId);
        if (element.isPresent()) {
            return this.findElementByClass(element.get(), clazz);
        }
        return Optional.empty();
    }

    default public <T extends GModelElement> Optional<T> findElementByClass(GModelElement element, Class<T> clazz) {
        if (element == null) {
            return Optional.empty();
        }
        if (clazz.isInstance(element)) {
            return Optional.of((GModelElement)clazz.cast(element));
        }
        GModelElement parent = element.getParent();
        return parent != null ? this.findElementByClass(parent, clazz) : Optional.empty();
    }

    default public Optional<GModelElement> findElement(String elementId, Predicate<GModelElement> predicate) {
        Optional<GModelElement> element = this.get(elementId);
        if (element.isPresent()) {
            return this.findElement(element.get(), predicate);
        }
        return Optional.empty();
    }

    default public Optional<GModelElement> findElement(GModelElement element, Predicate<GModelElement> predicate) {
        if (element == null) {
            return Optional.empty();
        }
        if (predicate.test(element)) {
            return Optional.of(element);
        }
        GModelElement parent = element.getParent();
        return parent != null ? this.findElement(parent, predicate) : Optional.empty();
    }

    default public <T extends GModelElement> Set<T> getAllByClass(Class<T> clazz) {
        return this.findAll(this.getRoot(), clazz);
    }

    default public <T extends GModelElement> Set<T> findAll(GModelElement parent, Class<T> type) {
        return this.getStream(parent).flatMap(this::getStream).filter(type::isInstance).map(type::cast).collect(Collectors.toSet());
    }

    default public Stream<GModelElement> getStream(GModelElement element) {
        if (element == null) {
            return Stream.empty();
        }
        if (element.getChildren() == null) {
            return Stream.of(element);
        }
        return Stream.concat(Stream.of(element), element.getChildren().stream());
    }

    public int getTypeCount(EClass var1);
}

