/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.utils;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.glsp.server.actions.MessageAction;
import org.eclipse.glsp.server.types.Severity;

public final class MessageActionUtil {
    protected static Logger LOGGER = LogManager.getLogger(MessageActionUtil.class);

    private MessageActionUtil() {
    }

    public static MessageAction message(Severity severity, String message) {
        return new MessageAction(severity, message);
    }

    public static MessageAction info(String message) {
        return new MessageAction(Severity.INFO, message);
    }

    public static MessageAction warn(String message) {
        return new MessageAction(Severity.WARNING, message);
    }

    public static MessageAction error(String message) {
        return new MessageAction(Severity.ERROR, message);
    }

    public static MessageAction error(String message, String details) {
        return new MessageAction(Severity.ERROR, message, details);
    }

    public static MessageAction error(String message, Throwable cause) {
        return new MessageAction(Severity.ERROR, message, MessageActionUtil.getDetails(cause));
    }

    public static MessageAction error(Exception e) {
        return MessageActionUtil.error(MessageActionUtil.getMessage(e), MessageActionUtil.getDetails(e));
    }

    public static MessageAction clear() {
        return new MessageAction(Severity.NONE, "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getDetails(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        if (throwable.getMessage() != null) {
            result.append(String.valueOf(throwable.getMessage()) + "\n");
        }
        try {
            Throwable throwable2 = null;
            Object var3_5 = null;
            try {
                StringWriter stackTraceWriter = new StringWriter();
                try {
                    try (PrintWriter printWriter = new PrintWriter(stackTraceWriter);){
                        throwable.printStackTrace(printWriter);
                        result.append(stackTraceWriter.toString());
                    }
                    if (stackTraceWriter == null) return result.toString();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    if (stackTraceWriter == null) throw throwable2;
                    stackTraceWriter.close();
                    throw throwable2;
                }
                stackTraceWriter.close();
                return result.toString();
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                    throw throwable2;
                } else {
                    if (throwable2 == throwable4) throw throwable2;
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
        }
        catch (IOException ex) {
            LOGGER.error("Could not write stacktrace.", (Throwable)ex);
            return null;
        }
    }

    public static String getMessage(Exception e) {
        if (e == null) {
            return "<no-message>";
        }
        if (e.getMessage() != null) {
            return e.getMessage();
        }
        return e.getClass().toString();
    }
}

