/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.context;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.util.Property;

public final class Context
implements IContext {
    private final Map<Object, Object> bindings = new HashMap<Object, Object>();

    @Override
    public <T> T get(Property<T> property) {
        return (T)this.internalGet(property);
    }

    @Override
    public <T> T get(Class<T> clazz) {
        return (T)this.internalGet(clazz);
    }

    @Override
    public boolean containsKey(Property<?> property) {
        return this.internalContainsKey(property);
    }

    @Override
    public boolean containsKey(Class<?> clazz) {
        return this.internalContainsKey(clazz);
    }

    public <T> BindingBuilder<T> bind(Property<T> property) {
        return new BindingBuilder(this.requireUnique(property));
    }

    public <T> BindingBuilder<T> bind(Class<T> clazz) {
        return new BindingBuilder(this.requireUnique(clazz));
    }

    private Object internalGet(Object key) {
        Object value = this.bindings.get(key);
        if (value instanceof ContextFunction) {
            value = ((ContextFunction)value).eval();
        }
        return value;
    }

    private boolean internalContainsKey(Object key) {
        return this.bindings.containsKey(key);
    }

    private Object requireUnique(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (this.internalContainsKey(key)) {
            throw new IllegalArgumentException("Already bound: " + key);
        }
        return key;
    }

    public class BindingBuilder<T> {
        private Object key;

        private BindingBuilder(Object key) {
            this.key = key;
        }

        public Context to(T value) {
            return this.bind(value);
        }

        public Context toSupplier(final Supplier<? extends T> supplier) {
            if (supplier == null) {
                throw new IllegalArgumentException();
            }
            return this.bind(new ContextFunction<T>(){

                @Override
                public T eval() {
                    return supplier.get();
                }
            });
        }

        private Context bind(Object value) {
            Context.this.bindings.put(this.key, value);
            return Context.this;
        }
    }

    private static interface ContextFunction<T> {
        public T eval();
    }
}

