/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditor;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentPartitioner;
import org.eclipse.mylyn.docs.intent.client.ui.logger.IntentUiLogger;
import org.eclipse.swt.widgets.Display;

public final class IntentReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    protected final Map<Annotation, Position> addedAnnotations = new HashMap<Annotation, Position>();
    protected final Map<Annotation, Position> currentAnnotations = new HashMap<Annotation, Position>();
    protected final List<Annotation> deletedAnnotations = new ArrayList<Annotation>();
    protected final IntentEditor editor;
    protected final Map<Annotation, Position> modifiedAnnotations = new HashMap<Annotation, Position>();
    private IDocument document;
    private int offset;

    public IntentReconcilingStrategy(IntentEditor editor) {
        this.editor = editor;
    }

    public void initialReconcile() {
        this.offset = 0;
        this.computePositions();
        this.updateFoldingStructure();
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile(subRegion);
    }

    public void reconcile(IRegion partition) {
        this.offset = partition.getOffset();
        this.computePositions();
        this.updateFoldingStructure();
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    private void computePositions() {
        this.deletedAnnotations.clear();
        this.modifiedAnnotations.clear();
        this.addedAnnotations.clear();
        this.deletedAnnotations.addAll(this.currentAnnotations.keySet());
        for (Map.Entry<Annotation, Position> entry : this.currentAnnotations.entrySet()) {
            Position position = entry.getValue();
            if (position.getOffset() + position.getLength() >= this.offset) continue;
            this.deletedAnnotations.remove(entry.getKey());
        }
        IntentPartitioner partitioner = (IntentPartitioner)this.document.getDocumentPartitioner();
        try {
            for (ITypedRegion iTypedRegion : partitioner.getRegions()) {
                String beginning;
                if ("__Intent__modelingunit".equals(iTypedRegion.getType())) {
                    this.createOrUpdateAnnotation(iTypedRegion.getOffset(), iTypedRegion.getLength() + 1, false);
                    continue;
                }
                if (!"__Intent__structuralcontent".equals(iTypedRegion.getType()) || this.document.getChar(iTypedRegion.getOffset()) == '}' || !(beginning = this.document.get(iTypedRegion.getOffset(), iTypedRegion.getLength()).trim()).endsWith("{")) continue;
                int regionEnd = iTypedRegion.getOffset() + beginning.length();
                IRegion wholeRegion = this.editor.getBlockMatcher().match(this.document, regionEnd);
                if (wholeRegion == null) continue;
                this.createOrUpdateAnnotation(iTypedRegion.getOffset(), beginning.length() + wholeRegion.getLength(), false);
            }
        }
        catch (BadLocationException badLocationException) {
            IntentUiLogger.logError(badLocationException);
        }
        Iterator<Annotation> iterator = this.deletedAnnotations.iterator();
        while (iterator.hasNext()) {
            this.currentAnnotations.remove(iterator.next());
        }
    }

    private void createOrUpdateAnnotation(int newOffset, int newLength, boolean initiallyCollapsed) throws BadLocationException {
        boolean createAnnotation = true;
        HashMap<Annotation, Position> copy = new HashMap<Annotation, Position>(this.currentAnnotations);
        String text = this.document.get(newOffset, newLength);
        for (Map.Entry entry : copy.entrySet()) {
            if (!((Annotation)entry.getKey()).getText().equals(text)) continue;
            createAnnotation = false;
            Position oldPosition = (Position)entry.getValue();
            if (oldPosition.getOffset() != newOffset || oldPosition.getLength() != newLength) {
                Position newPosition = new Position(newOffset, newLength);
                this.modifiedAnnotations.put((Annotation)entry.getKey(), newPosition);
                this.currentAnnotations.put((Annotation)entry.getKey(), newPosition);
            }
            this.deletedAnnotations.remove(entry.getKey());
            break;
        }
        if (createAnnotation) {
            ProjectionAnnotation annotation = null;
            annotation = new ProjectionAnnotation(initiallyCollapsed);
            annotation.setText(text);
            Position position = new Position(newOffset, newLength);
            this.currentAnnotations.put((Annotation)annotation, position);
            this.addedAnnotations.put((Annotation)annotation, position);
        }
    }

    private void updateFoldingStructure() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                IntentReconcilingStrategy.this.editor.updateFoldingStructure(IntentReconcilingStrategy.this.addedAnnotations, IntentReconcilingStrategy.this.deletedAnnotations, IntentReconcilingStrategy.this.modifiedAnnotations);
            }
        });
    }
}

