/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.compare.match;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.diff.DefaultDiffEngine;
import org.eclipse.emf.compare.diff.FeatureFilter;
import org.eclipse.emf.compare.diff.IDiffProcessor;
import org.eclipse.emf.compare.match.DefaultComparisonFactory;
import org.eclipse.emf.compare.match.IComparisonFactory;
import org.eclipse.emf.compare.match.IEqualityHelperFactory;
import org.eclipse.emf.compare.match.eobject.ProximityEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.URIDistance;
import org.eclipse.emf.compare.utils.DiffUtil;
import org.eclipse.emf.compare.utils.EqualityHelper;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.mylyn.docs.intent.compare.match.IntentCountingDiffEngine;

public class EditionDistance
implements ProximityEObjectMatcher.DistanceFunction {
    private int referenceChangeCoef = 10;
    private int attributeChangeCoef = 20;
    private int locationChangeCoef = 4;
    private int orderChangeCoef = 5;
    private Map<EStructuralFeature, Integer> weights;
    private Set<EStructuralFeature> toBeIgnored;
    private URIDistance uriDistance = new URIDistance();
    private EqualityHelper helper;
    private Notifier leftRoot;
    private Notifier rightRoot;

    public EditionDistance(Notifier leftRoot, Notifier rightRoot) {
        this.weights = Maps.newHashMap();
        this.helper = new EqualityHelper(){

            protected boolean matchingEObjects(EObject object1, EObject object2) {
                Match match = this.getTarget().getMatch(object1);
                boolean equal = match != null ? match.getLeft() == object2 || match.getRight() == object2 || match.getOrigin() == object2 : EditionDistance.this.uriDistance.proximity(object1, object2) == 0;
                return equal;
            }
        };
        this.toBeIgnored = Sets.newLinkedHashSet();
        this.leftRoot = leftRoot;
        this.rightRoot = rightRoot;
    }

    public int distance(EObject a, EObject b) {
        int maxDist = Math.max(this.getMaxDistance(a), this.getMaxDistance(b));
        int measuredDist = new IntentCountingDiffEngine(this, maxDist).measureDifferences(a, b);
        if (measuredDist >= maxDist) {
            return Integer.MAX_VALUE;
        }
        return measuredDist;
    }

    public boolean areIdentic(EObject a, EObject b) {
        boolean areRoots;
        boolean bl = areRoots = a.equals(this.leftRoot) && b.equals(this.rightRoot) || b.equals(this.leftRoot) && a.equals(this.rightRoot);
        return areRoots || new IntentCountingDiffEngine(this, 0).measureDifferences(a, b) == 0;
    }

    public static Builder builder(Notifier leftRoot, Notifier rightRoot) {
        return new Builder(leftRoot, rightRoot);
    }

    private int getWeight(EStructuralFeature attribute) {
        Integer found = this.weights.get(attribute);
        if (found == null) {
            found = "name".equals(attribute.getName()) ? Integer.valueOf(3) : Integer.valueOf(1);
        }
        return found;
    }

    public int getMaxDistance(EObject eObj) {
        Predicate<EStructuralFeature> featureFilter = new Predicate<EStructuralFeature>(){

            public boolean apply(EStructuralFeature feat) {
                return !feat.isDerived() && !feat.isTransient() && !EditionDistance.this.toBeIgnored.contains(feat);
            }
        };
        int max = 0;
        for (EReference feat : Iterables.filter((Iterable)eObj.eClass().getEAllReferences(), (Predicate)featureFilter)) {
            if (feat.isContainer() || feat.isContainment() || !eObj.eIsSet((EStructuralFeature)feat)) continue;
            max += this.getWeight((EStructuralFeature)feat) * this.referenceChangeCoef;
        }
        for (EReference feat : Iterables.filter((Iterable)eObj.eClass().getEAllAttributes(), (Predicate)featureFilter)) {
            if (!eObj.eIsSet((EStructuralFeature)feat)) continue;
            max += this.getWeight((EStructuralFeature)feat) * this.attributeChangeCoef;
        }
        return Double.valueOf((max += this.locationChangeCoef * 5) / 3 * 2).intValue();
    }

    public static class Builder {
        private EditionDistance toBeBuilt;

        public Builder(Notifier leftRoot, Notifier rightRoot) {
            this.toBeBuilt = new EditionDistance(leftRoot, rightRoot);
        }

        public Builder weight(EStructuralFeature feat, Integer weight) {
            this.toBeBuilt.weights.put(feat, weight);
            return this;
        }

        public Builder ignore(EStructuralFeature featToIgnore) {
            this.toBeBuilt.toBeIgnored.add(featToIgnore);
            return this;
        }

        public Builder uri(int weight) {
            this.toBeBuilt.locationChangeCoef = weight;
            return this;
        }

        public Builder order(int weight) {
            this.toBeBuilt.orderChangeCoef = weight;
            return this;
        }

        public Builder attribute(int weight) {
            this.toBeBuilt.attributeChangeCoef = weight;
            return this;
        }

        public Builder reference(int weight) {
            this.toBeBuilt.referenceChangeCoef = weight;
            return this;
        }

        public EditionDistance build() {
            return this.toBeBuilt;
        }
    }

    class CountingDiffEngine
    extends DefaultDiffEngine {
        private int maxDistance;
        private final IComparisonFactory fakeComparisonFactory;

        public CountingDiffEngine(int maxDistance) {
            super((IDiffProcessor)new CountingDiffProcessor());
            this.maxDistance = maxDistance;
            IEqualityHelperFactory fakeEqualityHelperFactory = new IEqualityHelperFactory(){

                public IEqualityHelper createEqualityHelper() {
                    return EditionDistance.this.helper;
                }
            };
            this.fakeComparisonFactory = new DefaultComparisonFactory(fakeEqualityHelperFactory);
        }

        protected void computeDifferences(Match match, EAttribute attribute, boolean checkOrdering) {
            if (this.getCounter().getComputedDistance() <= this.maxDistance) {
                super.computeDifferences(match, attribute, checkOrdering);
            }
        }

        protected void computeDifferences(Match match, EReference reference, boolean checkOrdering) {
            if (this.getCounter().getComputedDistance() <= this.maxDistance) {
                super.computeDifferences(match, reference, checkOrdering);
            }
        }

        public int measureDifferences(EObject a, EObject b) {
            Match fakeMatch = this.createFakeMatch(a, b);
            int changes = 0;
            int dist = EditionDistance.this.uriDistance.proximity(a, b);
            if ((changes += dist * EditionDistance.this.locationChangeCoef) <= this.maxDistance) {
                this.checkForDifferences(fakeMatch, (Monitor)new BasicMonitor());
                changes += this.getCounter().getComputedDistance();
            }
            return changes;
        }

        private Match createFakeMatch(EObject a, EObject b) {
            Comparison fakeComparison = this.fakeComparisonFactory.createComparison();
            Match fakeMatch = CompareFactory.eINSTANCE.createMatch();
            ((InternalEList)fakeComparison.getMatches()).addUnique((Object)fakeMatch);
            fakeMatch.setLeft(a);
            fakeMatch.setRight(b);
            return fakeMatch;
        }

        protected CountingDiffProcessor getCounter() {
            return (CountingDiffProcessor)this.getDiffProcessor();
        }

        protected FeatureFilter createFeatureFilter() {
            return new FeatureFilter(){

                public Iterator<EReference> getReferencesToCheck(Match match) {
                    return Iterators.filter((Iterator)super.getReferencesToCheck(match), (Predicate)new Predicate<EReference>(){

                        public boolean apply(EReference input) {
                            return !EditionDistance.this.toBeIgnored.contains(input) && !input.isContainment();
                        }
                    });
                }

                public Iterator<EAttribute> getAttributesToCheck(Match match) {
                    return Iterators.filter((Iterator)super.getAttributesToCheck(match), (Predicate)new Predicate<EAttribute>(){

                        public boolean apply(EAttribute input) {
                            return !EditionDistance.this.toBeIgnored.contains(input);
                        }
                    });
                }
            };
        }
    }

    class CountingDiffProcessor
    implements IDiffProcessor {
        private int distance;

        CountingDiffProcessor() {
        }

        public void referenceChange(Match match, EReference reference, EObject value, DifferenceKind kind, DifferenceSource source) {
            this.distance += EditionDistance.this.getWeight((EStructuralFeature)reference) * EditionDistance.this.referenceChangeCoef;
        }

        public void attributeChange(Match match, EAttribute attribute, Object value, DifferenceKind kind, DifferenceSource source) {
            Object aValue = ReferenceUtil.safeEGet((EObject)match.getLeft(), (EStructuralFeature)attribute);
            Object bValue = ReferenceUtil.safeEGet((EObject)match.getRight(), (EStructuralFeature)attribute);
            switch (kind) {
                case MOVE: {
                    this.distance += EditionDistance.this.getWeight((EStructuralFeature)attribute) * EditionDistance.this.orderChangeCoef;
                    break;
                }
                case ADD: 
                case DELETE: 
                case CHANGE: {
                    if (aValue instanceof String && bValue instanceof String) {
                        this.distance = (int)((double)this.distance + (double)EditionDistance.this.getWeight((EStructuralFeature)attribute) * (1.0 - DiffUtil.diceCoefficient((String)((String)aValue), (String)((String)bValue))) * (double)EditionDistance.this.attributeChangeCoef);
                        break;
                    }
                    this.distance += EditionDistance.this.getWeight((EStructuralFeature)attribute) * EditionDistance.this.attributeChangeCoef;
                    break;
                }
            }
        }

        public void resourceAttachmentChange(Match match, String uri, DifferenceKind kind, DifferenceSource source) {
        }

        public int getComputedDistance() {
            return this.distance;
        }
    }
}

