/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.compiler.saver;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mylyn.docs.intent.client.compiler.utils.IntentCompilerInformationHolder;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.query.CompilationStatusQuery;
import org.eclipse.mylyn.docs.intent.collab.common.query.TraceabilityInformationsQuery;
import org.eclipse.mylyn.docs.intent.collab.handlers.RepositoryObjectHandler;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationMessageType;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatusManager;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatusSeverity;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilerFactory;
import org.eclipse.mylyn.docs.intent.core.compiler.InstructionTraceabilityEntry;
import org.eclipse.mylyn.docs.intent.core.compiler.TraceabilityIndex;
import org.eclipse.mylyn.docs.intent.core.compiler.TraceabilityIndexEntry;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.genericunit.UnitInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ContributionInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.InstanciationInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnit;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnitInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ResourceDeclaration;
import org.eclipse.mylyn.docs.intent.core.modelingunit.StructuralFeatureAffectation;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ValueForStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerInformationsSaver {
    private Map<ResourceDeclaration, Map<EObject, Collection<IntentGenericElement>>> resourceToTraceabilityElementIndexEntry;
    private IProgressMonitor progressMonitor;
    private TraceabilityInformationsQuery traceabilityInfoQuery;
    private CompilationStatusQuery statusQuery;

    public CompilerInformationsSaver(IProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public void saveOnRepository(IntentCompilerInformationHolder informationHolder, RepositoryObjectHandler handler) {
        this.traceabilityInfoQuery = new TraceabilityInformationsQuery(handler.getRepositoryAdapter());
        this.statusQuery = new CompilationStatusQuery(handler.getRepositoryAdapter());
        this.resourceToTraceabilityElementIndexEntry = Maps.newLinkedHashMap();
        try {
            if (!this.progressMonitor.isCanceled()) {
                Map<ResourceDeclaration, String> resourceToGeneratedPath = this.saveGeneratedResources(informationHolder, handler);
                if (!this.progressMonitor.isCanceled()) {
                    this.saveStatusInformations(informationHolder, handler);
                }
                if (!this.progressMonitor.isCanceled()) {
                    this.saveTraceabilityInformations(resourceToGeneratedPath, handler, informationHolder);
                }
            }
        }
        catch (Exception e) {
            IntentLogger.getInstance().log(IIntentLogger.LogType.ERROR, "Compiler failed to save changes", (Throwable)e);
            try {
                handler.getRepositoryAdapter().undo();
            }
            catch (ReadOnlyException readOnlyException) {
                IntentLogger.getInstance().log(IIntentLogger.LogType.ERROR, "Compiler failed to save changes", (Throwable)e);
            }
        }
    }

    private Map<ResourceDeclaration, String> saveGeneratedResources(IntentCompilerInformationHolder informationHolder, RepositoryObjectHandler handler) throws ReadOnlyException {
        HashMap<ResourceDeclaration, String> resourceInfos = new HashMap<ResourceDeclaration, String>();
        for (ResourceDeclaration resource : informationHolder.getDeclaredResources()) {
            String internalResourcePath;
            if (this.progressMonitor.isCanceled() || (internalResourcePath = this.getInternalResourcePath(resource)) == null) continue;
            Resource generatedResource = handler.getRepositoryAdapter().getOrCreateResource(internalResourcePath);
            resourceInfos.put(resource, internalResourcePath);
            generatedResource.getContents().clear();
            this.updateTraceabilityFromResourceContent(resource, informationHolder, informationHolder.getResourceContent(resource));
            generatedResource.getContents().addAll(informationHolder.getResourceContent(resource));
        }
        return resourceInfos;
    }

    private void updateTraceabilityFromResourceContent(ResourceDeclaration resource, IntentCompilerInformationHolder informationHolder, EList<EObject> elementsToConsider) {
        for (EObject element : elementsToConsider) {
            Collection<UnitInstruction> instructions;
            if (this.progressMonitor.isCanceled()) continue;
            if (this.resourceToTraceabilityElementIndexEntry.get(resource) == null) {
                this.resourceToTraceabilityElementIndexEntry.put(resource, Maps.newLinkedHashMap());
            }
            if ((instructions = informationHolder.getAllInstructionsByCreatedElement(element)) == null || instructions.isEmpty()) continue;
            if (this.resourceToTraceabilityElementIndexEntry.get(resource).get(element) == null) {
                this.resourceToTraceabilityElementIndexEntry.get(resource).put(element, Sets.newLinkedHashSet());
            }
            this.resourceToTraceabilityElementIndexEntry.get(resource).get(element).addAll(instructions);
            this.updateTraceabilityFromResourceContent(resource, informationHolder, (EList<EObject>)element.eContents());
        }
    }

    private void saveStatusInformations(IntentCompilerInformationHolder informationHolder, RepositoryObjectHandler handler) throws ReadOnlyException {
        CompilationStatusManager manager = this.statusQuery.getOrCreateCompilationStatusManager();
        if (!this.progressMonitor.isCanceled()) {
            this.mergeCompilationStatusManager(informationHolder.getStatusManager(), manager, manager.eResource());
        }
    }

    private void saveTraceabilityInformations(Map<ResourceDeclaration, String> resourceToGeneratedPath, RepositoryObjectHandler handler, IntentCompilerInformationHolder informationHolder) throws ReadOnlyException {
        TraceabilityIndex traceIndex = this.traceabilityInfoQuery.getOrCreateTraceabilityIndex();
        ArrayList<TraceabilityIndexEntry> newTraceabilityEntries = new ArrayList<TraceabilityIndexEntry>();
        LinkedHashSet handledInstructions = Sets.newLinkedHashSet();
        for (ResourceDeclaration resourceDeclaration : resourceToGeneratedPath.keySet()) {
            TraceabilityIndexEntry entry = CompilerFactory.eINSTANCE.createTraceabilityIndexEntry();
            entry.setCompilationTime(BigInteger.valueOf(System.currentTimeMillis()));
            entry.setGeneratedResourcePath(resourceToGeneratedPath.get(resourceDeclaration));
            entry.setResourceDeclaration(resourceDeclaration);
            EMap entryElementsMap = entry.getContainedElementToInstructions();
            if (this.resourceToTraceabilityElementIndexEntry.get(resourceDeclaration) != null) {
                for (Map.Entry<EObject, Collection<IntentGenericElement>> traceabilityEntry : this.resourceToTraceabilityElementIndexEntry.get(resourceDeclaration).entrySet()) {
                    entryElementsMap.put((Object)traceabilityEntry.getKey(), (Object)new BasicEList());
                    for (IntentGenericElement intentGenericElement : traceabilityEntry.getValue()) {
                        InstructionTraceabilityEntry instructionEntry = CompilerFactory.eINSTANCE.createInstructionTraceabilityEntry();
                        instructionEntry.setInstruction(intentGenericElement);
                        instructionEntry.getFeatures().putAll(this.getAffectations(intentGenericElement));
                        ((EList)entryElementsMap.get((Object)traceabilityEntry.getKey())).add((Object)instructionEntry);
                    }
                    handledInstructions.addAll(traceabilityEntry.getValue());
                }
            }
            newTraceabilityEntries.add(entry);
        }
        Sets.SetView instanciationsInstructionNotContainedInResource = Sets.difference(informationHolder.getAllInstanciationsInstructions(), (Set)handledInstructions);
        if (!instanciationsInstructionNotContainedInResource.isEmpty()) {
            TraceabilityIndexEntry entry = CompilerFactory.eINSTANCE.createTraceabilityIndexEntry();
            entry.setCompilationTime(BigInteger.valueOf(System.currentTimeMillis()));
            for (UnitInstruction instruction : instanciationsInstructionNotContainedInResource) {
                entry.getContainedElementToInstructions().put((Object)instruction, (Object)new BasicEList());
                InstructionTraceabilityEntry instructionEntry = CompilerFactory.eINSTANCE.createInstructionTraceabilityEntry();
                instructionEntry.setInstruction((IntentGenericElement)instruction);
                instructionEntry.getFeatures().putAll(this.getAffectations((IntentGenericElement)instruction));
                ((EList)entry.getContainedElementToInstructions().get((Object)instruction)).add((Object)instructionEntry);
            }
            newTraceabilityEntries.add(entry);
        }
        traceIndex.getEntries().clear();
        traceIndex.getEntries().addAll(newTraceabilityEntries);
    }

    private BasicEMap<String, EList<ValueForStructuralFeature>> getAffectations(IntentGenericElement intentGenericElement) {
        BasicEMap affectations;
        block3: {
            block2: {
                affectations = new BasicEMap();
                if (!(intentGenericElement instanceof InstanciationInstruction)) break block2;
                InstanciationInstruction instanciation = (InstanciationInstruction)intentGenericElement;
                for (StructuralFeatureAffectation affectation : instanciation.getStructuralFeatures()) {
                    this.includeValues((BasicEMap<String, EList<ValueForStructuralFeature>>)affectations, affectation);
                }
                break block3;
            }
            if (!(intentGenericElement instanceof ContributionInstruction)) break block3;
            ContributionInstruction contribution = (ContributionInstruction)intentGenericElement;
            for (ModelingUnitInstruction instruction : contribution.getContributions()) {
                if (!(instruction instanceof StructuralFeatureAffectation)) continue;
                this.includeValues((BasicEMap<String, EList<ValueForStructuralFeature>>)affectations, (StructuralFeatureAffectation)instruction);
            }
        }
        return affectations;
    }

    private void includeValues(BasicEMap<String, EList<ValueForStructuralFeature>> affectations, StructuralFeatureAffectation affectation) {
        EList existing = (EList)affectations.get((Object)affectation.getName());
        if (existing == null) {
            existing = new BasicEList();
        }
        existing.addAll((Collection)affectation.getValues());
        affectations.put((Object)affectation.getName(), (Object)existing);
    }

    /*
     * Enabled aggressive block sorting
     */
    private String getInternalResourcePath(ResourceDeclaration resource) {
        String resourcePath;
        block6: {
            resourcePath = null;
            if (resource.getUri() == null) {
                String resourceName = resource.getName();
                if (resourceName != null && resourceName.length() > 0) {
                    resourcePath = resourceName;
                    break block6;
                } else {
                    CompilationStatus status = CompilerFactory.eINSTANCE.createCompilationStatus();
                    status.setSeverity(CompilationStatusSeverity.ERROR);
                    status.setTarget((IntentGenericElement)resource);
                    status.setType(CompilationMessageType.VALIDATION_ERROR);
                    status.setMessage("As this resource has no URI, it should have a name to be identifed.");
                    resource.getCompilationStatus().add((Object)status);
                    return "unnamed-resource.xmi";
                }
            }
            resourcePath = ((String)resource.getUri()).replace("\"", "");
            if (resourcePath.contains("/")) {
                if (resourcePath.contains("#")) {
                    String pathWithoutFragment = resourcePath.substring(0, resourcePath.lastIndexOf(35));
                    resourcePath = String.valueOf(pathWithoutFragment.substring(pathWithoutFragment.lastIndexOf(47) + 1)) + "_" + resourcePath.substring(resourcePath.lastIndexOf(35) + 1).replace("/", "@");
                } else {
                    resourcePath = resourcePath.substring(resourcePath.lastIndexOf(47) + 1);
                }
            }
        }
        resourcePath = resourcePath.replace("*", "").replace("?", "-");
        return "/COMPILATION/GENERATED/" + resourcePath;
    }

    private boolean isContainedCompilationStatus(EList<CompilationStatus> statusList, CompilationStatus status) {
        boolean statusIsContainedInList = false;
        if (statusList != null) {
            Iterator iterator = statusList.iterator();
            while (iterator.hasNext() && !statusIsContainedInList) {
                CompilationStatus containedStatus = (CompilationStatus)iterator.next();
                statusIsContainedInList = this.isSimilarStatus(containedStatus, status);
            }
        }
        return statusIsContainedInList;
    }

    private boolean isSimilarStatus(CompilationStatus containedStatus, CompilationStatus status) {
        try {
            return containedStatus.getMessage().equals(status.getMessage()) && containedStatus.getSeverity().equals((Object)status.getSeverity()) && containedStatus.getType().equals((Object)status.getType());
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    private void mergeCompilationStatusManager(CompilationStatusManager localStatusManager, CompilationStatusManager repositoryStatusManager, Resource statusManagerResource) {
        this.removeDanglingReferences(repositoryStatusManager, statusManagerResource);
        for (ModelingUnit mu : localStatusManager.getModelingUnitToStatusList().keySet()) {
            for (CompilationStatus status : (EList)localStatusManager.getModelingUnitToStatusList().get((Object)mu)) {
                if (this.progressMonitor.isCanceled() || this.isContainedCompilationStatus((EList<CompilationStatus>)((EList)repositoryStatusManager.getModelingUnitToStatusList().get((Object)mu)), status) || repositoryStatusManager.getCompilationStatusList().contains((Object)status)) continue;
                if (status.getTarget() != null && !status.getTarget().getCompilationStatus().contains((Object)status)) {
                    status.getTarget().getCompilationStatus().add((Object)status);
                }
                repositoryStatusManager.getCompilationStatusList().add((Object)status);
                if (repositoryStatusManager.getModelingUnitToStatusList().get((Object)mu) == null) {
                    repositoryStatusManager.getModelingUnitToStatusList().put((Object)mu, (Object)new BasicEList());
                }
                ((EList)repositoryStatusManager.getModelingUnitToStatusList().get((Object)mu)).add((Object)status);
            }
        }
        repositoryStatusManager.setValidationTime(BigInteger.valueOf(System.currentTimeMillis()));
    }

    private void removeDanglingReferences(CompilationStatusManager repositoryStatusManager, Resource statusManagerResource) {
        CompilationStatusManager manager = repositoryStatusManager;
        LinkedHashSet changedModelingUnits = Sets.newLinkedHashSet();
        ListIterator entries = manager.getModelingUnitToStatusList().listIterator();
        while (entries.hasNext()) {
            Map.Entry entry = (Map.Entry)entries.next();
            if (entry.getKey() == null || ((ModelingUnit)entry.getKey()).eResource() == null) {
                manager.getCompilationStatusList().removeAll((Collection)entry.getValue());
                entries.remove();
                continue;
            }
            ListIterator statusList = ((EList)entry.getValue()).listIterator();
            while (statusList.hasNext()) {
                CompilationStatus status = (CompilationStatus)statusList.next();
                if (status.getTarget() != null && status.getTarget().eResource() != null) {
                    status.getTarget().getCompilationStatus().remove((Object)status);
                }
                changedModelingUnits.add(((ModelingUnit)entry.getKey()).eResource().getURI());
                statusList.remove();
            }
        }
    }
}

