/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.bridge.java.ui.renderers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.docs.intent.bridge.java.Classifier;
import org.eclipse.mylyn.docs.intent.bridge.java.Field;
import org.eclipse.mylyn.docs.intent.bridge.java.Method;
import org.eclipse.mylyn.docs.intent.bridge.java.resource.factory.JavaClassExplorer;
import org.eclipse.mylyn.docs.intent.bridge.java.resource.factory.JavaResourceFactory;
import org.eclipse.mylyn.docs.intent.bridge.java.util.JavaBridgeUtils;
import org.eclipse.mylyn.docs.intent.client.ui.editor.renderers.IEditorRendererExtension;
import org.eclipse.mylyn.docs.intent.client.ui.logger.IntentUiLogger;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ExternalContentReference;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ResourceTransfer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaEditorRendererExtension
implements IEditorRendererExtension {
    public boolean isRendererFor(ExternalContentReference externalContentReference) {
        return JavaBridgeUtils.isHandledByJavaBridge(URI.createURI((String)externalContentReference.getUri().toString().trim()));
    }

    public boolean openEditor(ExternalContentReference externalContentReference) {
        URI javaElementURI = URI.createURI((String)externalContentReference.getUri().toString().trim());
        IFile javaFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(javaElementURI.trimFragment().toString()));
        FileEditorInput editorInput = new FileEditorInput(javaFile);
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(javaElementURI.trimFragment().lastSegment());
        IEditorPart openedEditor = null;
        if (desc != null) {
            try {
                openedEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)editorInput, desc.getId());
            }
            catch (PartInitException e) {
                IntentUiLogger.logError((Throwable)e);
            }
        }
        if (openedEditor != null && javaElementURI.hasFragment()) {
            this.updateOpenedEditorSelection(openedEditor, javaFile, javaElementURI);
        }
        return true;
    }

    private void updateOpenedEditorSelection(IEditorPart openedEditor, IFile javaFile, URI javaElementURI) {
        EObject eJavaElement = new JavaResourceFactory().createResource(javaElementURI.trimFragment()).getEObject(javaElementURI.fragment());
        try {
            IType javaType = ((ICompilationUnit)JavaCore.create((IFile)javaFile)).getTypes()[0];
            IType matchingElement = null;
            if (eJavaElement instanceof Classifier) {
                matchingElement = javaType;
            } else if (eJavaElement instanceof Method) {
                IMethod[] iMethodArray = javaType.getMethods();
                int n = iMethodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod method = iMethodArray[n2];
                    if (method.getElementName().equals(((Method)eJavaElement).getSimpleName())) {
                        matchingElement = method;
                    }
                    ++n2;
                }
            } else if (eJavaElement instanceof Field) {
                matchingElement = javaType.getField(((Field)eJavaElement).getName());
            }
            if (matchingElement != null) {
                TextSelection textSelection = new TextSelection(matchingElement.getSourceRange().getOffset(), matchingElement.getSourceRange().getLength());
                openedEditor.getEditorSite().getSelectionProvider().setSelection((ISelection)textSelection);
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    public Collection<Transfer> getAdditionalTransfers() {
        ArrayList<Transfer> transfers = new ArrayList<Transfer>();
        transfers.add((Transfer)ResourceTransfer.getInstance());
        transfers.add((Transfer)LocalSelectionTransfer.getTransfer());
        return transfers;
    }

    public Collection<? extends EObject> getEObjectsFromDropTargetEvent(DropTargetEvent event) {
        LinkedHashSet<EObject> eObjects = new LinkedHashSet<EObject>();
        try {
            if (event.data instanceof IResource[]) {
                IResource[] droppedResources = (IResource[])event.data;
                int i = 0;
                while (i < droppedResources.length) {
                    eObjects.add((EObject)this.getJavaFactoryResourceFromIResource(droppedResources[i]).getContents().iterator().next());
                    ++i;
                }
            } else if (event.data instanceof IStructuredSelection) {
                for (Object element : (IStructuredSelection)event.data) {
                    if (element instanceof IMember) {
                        String elementID = JavaClassExplorer.getMemberID((IMember)element);
                        String elementFragment = "//";
                        elementFragment = element instanceof IMethod ? String.valueOf(elementFragment) + "@methods" : String.valueOf(elementFragment) + "@fields";
                        elementFragment = String.valueOf(elementFragment) + "[name='" + elementID + "']";
                        Resource javaResource = this.getJavaFactoryResourceFromIResource(((IMember)element).getResource());
                        if (elementID != null) {
                            eObjects.add(javaResource.getEObject(elementFragment));
                            continue;
                        }
                        eObjects.add((EObject)javaResource.getContents().iterator().next());
                        continue;
                    }
                    if (!(element instanceof ICompilationUnit)) continue;
                    eObjects.add((EObject)this.getJavaFactoryResourceFromIResource(((ICompilationUnit)element).getResource()).getContents().iterator().next());
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (JavaModelException e) {
            IntentUiLogger.logError((Throwable)e);
        }
        return eObjects;
    }

    Resource getJavaFactoryResourceFromIResource(IResource resource) {
        if (!"java".equals(resource.getFileExtension())) {
            throw new IllegalArgumentException();
        }
        return new JavaResourceFactory().createResource(URI.createURI((String)resource.getFullPath().toString().replaceFirst("/", "")));
    }
}

