/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.core.query;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatus;
import org.eclipse.mylyn.docs.intent.core.document.IntentChapter;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocument;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.document.IntentSection;
import org.eclipse.mylyn.docs.intent.core.document.IntentStructuredElement;
import org.eclipse.mylyn.docs.intent.core.document.IntentSubSectionContainer;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ExternalContentReference;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntentHelper {
    private IntentHelper() {
    }

    public static boolean canBeOpenedByIntentEditor(Object element) {
        return element instanceof IntentStructuredElement;
    }

    public static EList<CompilationStatus> getAllStatus(IntentGenericElement element) {
        BasicEList allCompilationStatus = new BasicEList();
        allCompilationStatus.addAll(element.getCompilationStatus());
        for (EObject object : element.eContents()) {
            if (!(object instanceof IntentGenericElement)) continue;
            allCompilationStatus.addAll(IntentHelper.getAllStatus((IntentGenericElement)object));
        }
        return allCompilationStatus;
    }

    public static boolean containsElement(IntentGenericElement root, IntentGenericElement searchedElement) {
        boolean containsElement;
        boolean bl = containsElement = root == searchedElement;
        if (!containsElement) {
            Iterator containedElementsIterator = root.eContents().iterator();
            while (!containsElement && containedElementsIterator.hasNext()) {
                EObject containedElement = (EObject)containedElementsIterator.next();
                if (!(containedElement instanceof IntentGenericElement)) continue;
                containsElement = IntentHelper.containsElement((IntentGenericElement)containedElement, searchedElement);
            }
        }
        return containsElement;
    }

    public static Collection<ExternalContentReference> getAllExternalContentReferences(IntentGenericElement root) {
        LinkedHashSet<ExternalContentReference> externalContentReferences = new LinkedHashSet<ExternalContentReference>();
        if (root instanceof IntentDocument) {
            for (IntentChapter chapter : ((IntentDocument)root).getChapters()) {
                externalContentReferences.addAll(IntentHelper.getAllExternalContentReferences(chapter));
            }
        } else {
            if (root instanceof IntentSubSectionContainer) {
                for (IntentSection section : ((IntentSubSectionContainer)root).getSubSections()) {
                    externalContentReferences.addAll(IntentHelper.getAllExternalContentReferences(section));
                }
            }
            if (root instanceof IntentSection) {
                for (ModelingUnit unit : ((IntentSection)root).getModelingUnits()) {
                    externalContentReferences.addAll(IntentHelper.getAllExternalContentReferences(unit));
                }
            }
            if (root instanceof ModelingUnit) {
                externalContentReferences.addAll(Sets.newLinkedHashSet((Iterable)Iterables.filter(((ModelingUnit)root).getInstructions(), ExternalContentReference.class)));
            }
        }
        return externalContentReferences;
    }
}

